/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.io.Receiver;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;

public interface HttpEncoder<C, R> {
    public void encode(HttpServerExchange var1, C var2, R var3);

    public static String receiveFullString(HttpServerExchange exchange, Charset charset) throws HttpStatusException {
        return (String)HttpEncoder.receive((f, err) -> exchange.getRequestReceiver().receiveFullString((ex, data) -> f.complete(data), err, charset));
    }

    public static byte[] receiveFullBytes(HttpServerExchange exchange, Charset charset) throws HttpStatusException {
        return (byte[])HttpEncoder.receive((f, err) -> exchange.getRequestReceiver().receiveFullBytes((ex, data) -> f.complete(data), err));
    }

    private static <T> T receive(BiConsumer<CompletableFuture<T>, Receiver.ErrorCallback> completer) throws HttpStatusException {
        CompletableFuture future = new CompletableFuture();
        completer.accept(future, (ex, err) -> future.completeExceptionally(HttpStatusException.serverError(err)));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw HttpStatusException.serverError(e);
        }
        catch (ExecutionException e) {
            throw e.getCause() == null ? HttpStatusException.serverError(e) : HttpStatusException.serverError(e.getCause());
        }
    }
}

