/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import io.vavr.collection.Array;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.function.Function;

public class HttpMethodHandler
implements HttpHandler {
    private final Map<HttpString, HttpHandler> handlers;

    private HttpMethodHandler(Map<HttpString, HttpHandler> handlers) {
        this.handlers = handlers;
    }

    public static HttpMethodHandler of(Map<Method, HttpHandler> handlers) {
        return new HttpMethodHandler((Map<HttpString, HttpHandler>)handlers.mapKeys(Method::httpName));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Option action = this.handlers.get((Object)exchange.getRequestMethod());
        if (action.isDefined()) {
            ((HttpHandler)action.get()).handleRequest(exchange);
        } else {
            exchange.setStatusCode(405);
            exchange.endExchange();
        }
    }

    public HttpMethodHandler add(Method method, HttpHandler handler) {
        return new HttpMethodHandler((Map<HttpString, HttpHandler>)this.handlers.put((Object)method.httpName(), (Object)handler));
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

        static Map<HttpString, Method> METHODS;
        private final HttpString httpName = new HttpString(this.name());

        public HttpString httpName() {
            return this.httpName;
        }

        static {
            METHODS = Array.of((Object[])Method.values()).toMap(Method::httpName, Function.identity());
        }
    }
}

