/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.security;

import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import java.util.function.Function;

public interface Role {
    public String name();

    public boolean implies(Role var1);

    public static OfName ofName(String name) {
        return new OfName(name);
    }

    public static class Hierarchy<R extends Role> {
        private final R self;
        final Set<Role> all;

        @SafeVarargs
        public Hierarchy(R self, Function<? super R, ? extends Hierarchy<R>> resolver, R ... implied) {
            this((R)self, (Function<? super R, Hierarchy<? super R>>)resolver, (Set<? super R>)HashSet.of((Object[])implied));
        }

        public Hierarchy(R self, Function<? super R, ? extends Hierarchy<R>> resolver, Set<R> implied) {
            this.self = self;
            this.all = HashSet.of(self).addAll((Iterable)implied.map(resolver).flatMap(h -> h.all));
        }

        public boolean implies(Role role) {
            return this.all.contains((Object)role);
        }

        public String toString() {
            return Role.class.getSimpleName() + "." + Hierarchy.class.getSimpleName() + "[" + this.self.name() + "->" + this.all.remove(this.self) + "]";
        }
    }

    public static final class OfName
    implements Flat {
        private final String name;

        private OfName(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((OfName)o).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static interface Flat
    extends Role {
        @Override
        default public boolean implies(Role role) {
            return this.equals(role);
        }
    }
}

