/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.library.codec.ObjectCodecFactory;
import ch.raffael.meldioc.library.codec.ObjectDecoder;
import ch.raffael.meldioc.library.codec.ObjectEncoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpContentTypes;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.util.Headers;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.nio.ByteBuffer;

public interface HttpObjectCodecFactory<C> {
    public <T> Option<HttpDecoder<C, ? extends T>> decoder(Class<T> var1);

    public <T> Option<HttpEncoder<C, ? super T>> encoder(Class<T> var1);

    public static HttpObjectCodecFactory<Object> wrapBuffered(ObjectCodecFactory factory) {
        return new Adapter(factory);
    }

    public static class Adapter
    implements HttpObjectCodecFactory<Object> {
        private final ObjectCodecFactory factory;

        public Adapter(ObjectCodecFactory factory) {
            this.factory = factory;
        }

        @Override
        public <T> Option<HttpEncoder<Object, ? super T>> encoder(Class<T> type) {
            if (this.factory.canEncode(type)) {
                return Option.some((exchange, ctx, value) -> {
                    Tuple2 encoded;
                    ObjectEncoder encoder = (ObjectEncoder)Option.of((Object)exchange.getRequestHeaders().getFirst(Headers.ACCEPT)).filter(s -> !s.isBlank()).map(ContentTypes::parseContentTypeListQ).flatMap(ctl -> (Option)ctl.foldLeft((Object)Option.none(), (cur, ct) -> cur.orElse(() -> this.factory.encoder(type, ct)))).orElse(() -> this.factory.encoder(type)).getOrElseThrow(() -> new IllegalStateException("No encoder returned"));
                    try {
                        encoded = encoder.encode(value);
                    }
                    catch (Exception e) {
                        HttpStatusException.serverError("Error writing response: " + e, e).endRequest(exchange);
                        return;
                    }
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ((ContentType)encoded._2).render());
                    exchange.getResponseSender().send(ByteBuffer.wrap((byte[])encoded._1));
                });
            }
            return Option.none();
        }

        @Override
        public <T> Option<HttpDecoder<Object, ? extends T>> decoder(Class<T> type) {
            if (this.factory.canDecodeAs(type)) {
                return Option.some((exchange, ctx, consumer) -> exchange.getRequestReceiver().receiveFullBytes((ex, bytes) -> {
                    block5: {
                        Option decoder = this.factory.decoder(HttpContentTypes.contentType(exchange), type);
                        if (decoder.isDefined()) {
                            try {
                                consumer.accept(exchange, ((ObjectDecoder)decoder.get()).decode(bytes));
                            }
                            catch (Exception e) {
                                if (((ObjectDecoder)decoder.get()).isInvalidInput((Throwable)e)) {
                                    HttpStatusException.badRequest(e.toString(), e).endRequest(exchange);
                                    break block5;
                                }
                                HttpStatusException.serverError(e.toString(), e).endRequest(exchange);
                            }
                        } else {
                            HttpStatusException.serverError("No decoder found").endRequest(exchange);
                        }
                    }
                }, HttpStatusException::endRequestWithServerError));
            }
            return Option.none();
        }
    }
}

