/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HttpString;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

public class RequestLoggingHandler
implements HttpHandler {
    public static final String STANDARD_REQUEST_ID_MDC_KEY = "http-request-id";
    private final AttachmentKey<Info> startNanosKey = AttachmentKey.create(Info.class);
    private final AtomicInteger counter;
    private final Level level;
    private final Logger logger;
    private final HttpHandler next;
    @Nullable
    private final String mdcKey;
    @Nullable
    private final Marker marker;
    @Nullable
    private final BiConsumer<? super HttpServerExchange, ? super Integer> idConsumer;

    public RequestLoggingHandler(Level level, Logger logger, HttpHandler next) {
        this(level, logger, next, null, null, null, new AtomicInteger());
    }

    private RequestLoggingHandler(Level level, Logger logger, HttpHandler next, @Nullable String mdcKey, @Nullable Marker marker, @Nullable BiConsumer<? super HttpServerExchange, ? super Integer> idConsumer, AtomicInteger counter) {
        this.level = level;
        this.logger = logger;
        this.next = next;
        this.mdcKey = mdcKey;
        this.marker = marker;
        this.idConsumer = idConsumer;
        this.counter = counter;
    }

    public static RequestLoggingHandler trace(Logger logger, HttpHandler next) {
        return new RequestLoggingHandler(Level.TRACE, logger, next);
    }

    public static RequestLoggingHandler debug(Logger logger, HttpHandler next) {
        return new RequestLoggingHandler(Level.DEBUG, logger, next);
    }

    public static RequestLoggingHandler info(Logger logger, HttpHandler next) {
        return new RequestLoggingHandler(Level.INFO, logger, next);
    }

    public RequestLoggingHandler withStandardMdcKey() {
        return this.withMdcKey(STANDARD_REQUEST_ID_MDC_KEY);
    }

    public RequestLoggingHandler withMdcKey(String mdcKey) {
        return new RequestLoggingHandler(this.level, this.logger, this.next, mdcKey, this.marker, this.idConsumer, this.counter);
    }

    public RequestLoggingHandler withMarker(Marker marker) {
        return new RequestLoggingHandler(this.level, this.logger, this.next, this.mdcKey, marker, this.idConsumer, this.counter);
    }

    public RequestLoggingHandler addIdConsumer(BiConsumer<? super HttpServerExchange, ? super Integer> idConsumer) {
        BiConsumer<? super HttpServerExchange, ? super Integer> newConsumer;
        if (this.idConsumer != null) {
            BiConsumer<? super HttpServerExchange, ? super Integer> prev = this.idConsumer;
            newConsumer = (ex, id) -> {
                prev.accept((HttpServerExchange)ex, (Integer)id);
                idConsumer.accept((HttpServerExchange)ex, (Integer)id);
            };
        } else {
            newConsumer = idConsumer;
        }
        return new RequestLoggingHandler(this.level, this.logger, this.next, this.mdcKey, this.marker, newConsumer, this.counter);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Info info = new Info(System.nanoTime(), this.counter.getAndIncrement(), exchange);
        exchange.putAttachment(this.startNanosKey, (Object)info);
        if (this.mdcKey != null) {
            MDC.put((String)this.mdcKey, (String)String.valueOf(info.id));
        }
        this.level.logBegin(this.logger, this.marker, info);
        exchange.addExchangeCompleteListener(this::exchangeComplete);
        if (this.idConsumer != null) {
            this.idConsumer.accept((HttpServerExchange)exchange, (Integer)info.id);
        }
        this.next.handleRequest(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exchangeComplete(HttpServerExchange exchange, ExchangeCompletionListener.NextListener next) {
        try {
            Info info = (Info)exchange.getAttachment(this.startNanosKey);
            if (info != null) {
                this.level.logEnd(this.logger, this.marker, info, exchange);
            }
        }
        finally {
            if (this.mdcKey != null) {
                MDC.remove((String)this.mdcKey);
            }
        }
        next.proceed();
    }

    private static final class Info {
        final long startTime;
        final int id;
        final HttpString method;
        final String uri;

        private Info(long startTime, int id, HttpServerExchange exchange) {
            this.startTime = startTime;
            this.id = id;
            this.method = exchange.getRequestMethod();
            this.uri = exchange.getRequestURI();
        }
    }

    public static enum Level {
        TRACE{

            @Override
            void log(Logger logger, @Nullable Marker marker, String msg) {
                logger.trace(marker, msg);
            }

            @Override
            boolean enabled(Logger logger, @Nullable Marker marker) {
                return logger.isTraceEnabled(marker);
            }
        }
        ,
        DEBUG{

            @Override
            void log(Logger logger, @Nullable Marker marker, String msg) {
                logger.debug(marker, msg);
            }

            @Override
            boolean enabled(Logger logger, @Nullable Marker marker) {
                return logger.isDebugEnabled(marker);
            }
        }
        ,
        INFO{

            @Override
            void log(Logger logger, @Nullable Marker marker, String msg) {
                logger.info(marker, msg);
            }

            @Override
            boolean enabled(Logger logger, @Nullable Marker marker) {
                return logger.isInfoEnabled(marker);
            }
        };


        void logBegin(Logger logger, @Nullable Marker marker, Info info) {
            if (this.enabled(logger, marker)) {
                this.log(logger, marker, this.format(">>HTTP #{}: {} {}", info.id, info.method, info.uri));
            }
        }

        void logEnd(Logger logger, @Nullable Marker marker, Info info, HttpServerExchange exchange) {
            if (this.enabled(logger, marker)) {
                Duration duration = Duration.ofNanos(System.nanoTime() - info.startTime);
                this.log(logger, marker, this.format("<<HTTP #{}: {}: {} {} ({})", info.id, exchange.getStatusCode(), info.method, info.uri, duration));
            }
        }

        String format(String msg, Object ... args) {
            return MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        }

        abstract void log(Logger var1, @Nullable Marker var2, String var3);

        abstract boolean enabled(Logger var1, @Nullable Marker var2);
    }
}

