/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.routing.Blocks;
import ch.raffael.meldioc.library.http.server.undertow.routing.Capture;
import ch.raffael.meldioc.library.http.server.undertow.routing.Converter;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import ch.raffael.meldioc.library.http.server.undertow.routing.Paths;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinition;
import io.vavr.control.Either;

public class RoutingBuilder<C> {
    private static final String STRING_NAME = "string";
    private static final String INT_NAME = "int";
    private final Frame<C> initiatingFrame;

    RoutingBuilder(Frame<C> initiatingFrame) {
        this.initiatingFrame = initiatingFrame;
    }

    static <C> InitialFragment begin(Frame<C> frame) {
        return new RoutingBuilder<C>(frame).new InitialFragment();
    }

    private static String captureName(Converter<?> converter) {
        return "capture";
    }

    public final class Fragment3<T1, T2, T3>
    extends FollowupFragment {
        private final Blocks.Curry3<T1, T2, T3> curry;

        private Fragment3(AbstractFragment parent, Blocks.Curry3<T1, T2, T3> curry, String fixed) {
            super(parent, fixed);
            this.curry = curry;
        }

        private Fragment3(AbstractFragment parent, Blocks.Curry2<T1, T2> curry, Capture.Attachment<T3> capture) {
            super(parent, capture);
            this.curry = curry.append(capture);
        }

        public Fragment3<T1, T2, T3> path(String path) {
            return Paths.empty(path) ? this : new Fragment3<T1, T2, T3>((AbstractFragment)this, this.curry, path);
        }

        public void route(Blocks.Block3<? super T1, ? super T2, ? super T3> block) {
            this.resolve().run(this.curry.runnable(block));
        }
    }

    public final class Fragment2<T1, T2>
    extends FollowupFragment {
        private final Blocks.Curry2<T1, T2> curry;

        private Fragment2(AbstractFragment parent, Blocks.Curry2<T1, T2> curry, String fixed) {
            super(parent, fixed);
            this.curry = curry;
        }

        private Fragment2(AbstractFragment parent, Blocks.Curry1<T1> curry, Capture.Attachment<T2> capture) {
            super(parent, capture);
            this.curry = curry.append(capture);
        }

        public Fragment2<T1, T2> path(String path) {
            return Paths.empty(path) ? this : new Fragment2<T1, T2>((AbstractFragment)this, this.curry, path);
        }

        public Fragment3<T1, T2, String> captureString() {
            return this.capture(RoutingBuilder.STRING_NAME, Converter.asString());
        }

        public Fragment3<T1, T2, String> captureString(String name) {
            return this.capture(name, Converter.asString());
        }

        public Fragment3<T1, T2, Integer> captureInt() {
            return this.capture(RoutingBuilder.INT_NAME, Converter.asInt());
        }

        public Fragment3<T1, T2, Integer> captureInt(String name) {
            return this.capture(name, Converter.asInt());
        }

        public <T> Fragment3<T1, T2, T> capture(Converter<? extends T> converter) {
            return this.capture(RoutingBuilder.captureName(converter), converter);
        }

        public <T> Fragment3<T1, T2, T> capture(String name, Converter<? extends T> converter) {
            return new Fragment3<T1, T2, T>((AbstractFragment)this, this.curry, new Capture.Attachment<T>(name, converter));
        }

        public void route(Blocks.Block2<? super T1, ? super T2> block) {
            this.resolve().run(this.curry.runnable(block));
        }
    }

    public final class Fragment1<T1>
    extends FollowupFragment {
        private final Blocks.Curry1<T1> curry;

        private Fragment1(AbstractFragment parent, Blocks.Curry1<T1> curry, String path) {
            super(parent, path);
            this.curry = curry;
        }

        private Fragment1(AbstractFragment parent, Capture.Attachment<T1> capture) {
            super(parent, capture);
            this.curry = Blocks.curry(capture);
        }

        public Fragment1<T1> path(String path) {
            return Paths.empty(path) ? this : new Fragment1<T1>(this, this.curry, path);
        }

        public Fragment2<T1, String> captureString() {
            return this.capture(RoutingBuilder.STRING_NAME, Converter.asString());
        }

        public Fragment2<T1, String> captureString(String name) {
            return this.capture(name, Converter.asString());
        }

        public Fragment2<T1, Integer> captureInt() {
            return this.capture(RoutingBuilder.INT_NAME, Converter.asInt());
        }

        public Fragment2<T1, Integer> captureInt(String name) {
            return this.capture(name, Converter.asInt());
        }

        public <T> Fragment2<T1, T> capture(Converter<? extends T> converter) {
            return this.capture(RoutingBuilder.captureName(converter), converter);
        }

        public <T> Fragment2<T1, T> capture(String name, Converter<? extends T> converter) {
            return new Fragment2<T1, T>((AbstractFragment)this, this.curry, new Capture.Attachment<T>(name, converter));
        }

        public void route(Blocks.Block1<? super T1> block) {
            this.resolve().run(this.curry.runnable(block));
        }
    }

    public final class Fragment0
    extends FollowupFragment {
        public Fragment0(AbstractFragment parent, String path) {
            super(parent, path);
        }

        public Fragment0(AbstractFragment parent, Capture.Attachment<?> capture) {
            super(parent, capture);
        }

        public Fragment0 path(String path) {
            return Paths.empty(path) ? this : new Fragment0((AbstractFragment)this, path);
        }

        public Fragment1<String> captureString() {
            return this.capture(RoutingBuilder.STRING_NAME, Converter.asString());
        }

        public Fragment1<String> captureString(String name) {
            return this.capture(name, Converter.asString());
        }

        public Fragment1<Integer> captureInt() {
            return this.capture(RoutingBuilder.INT_NAME, Converter.asInt());
        }

        public Fragment1<Integer> captureInt(String name) {
            return this.capture(name, Converter.asInt());
        }

        public <T> Fragment1<T> capture(Converter<? extends T> converter) {
            return this.capture(RoutingBuilder.captureName(converter), converter);
        }

        public <T> Fragment1<T> capture(String name, Converter<? extends T> converter) {
            return new Fragment1<T>(this, new Capture.Attachment<T>("{" + name + "}", converter));
        }

        public void route(Blocks.Block0 block) {
            this.resolve().run(block);
        }

        public void merge(RoutingDefinition<? super C> that) {
            this.resolve().merge(that.rootFrame);
        }
    }

    public abstract class FollowupFragment
    extends AbstractFragment {
        private final AbstractFragment parent;
        private final Either<String, Capture.Attachment<?>> segment;

        private FollowupFragment(AbstractFragment parent, String path) {
            this.parent = parent;
            this.segment = Either.left((Object)path);
        }

        private FollowupFragment(AbstractFragment parent, Capture.Attachment<?> capture) {
            this.parent = parent;
            this.segment = Either.right(capture);
        }

        @Override
        Frame<C> resolve() {
            Frame frame = this.parent.resolve();
            return (Frame)this.segment.fold(frame::pathChild, frame::captureChild);
        }

        @Override
        void name(StringBuilder buf) {
            buf.append("/");
            this.segment.fold(buf::append, c -> buf.append("{").append(c.name()).append("}"));
        }
    }

    public final class InitialFragment
    extends AbstractFragment {
        private InitialFragment() {
        }

        public Fragment0 path(String path) {
            return new Fragment0((AbstractFragment)this, path);
        }

        public Fragment1<String> captureString() {
            return this.capture(RoutingBuilder.STRING_NAME, Converter.asString());
        }

        public Fragment1<String> captureString(String name) {
            return this.capture(name, Converter.asString());
        }

        public Fragment1<Integer> captureInt() {
            return this.capture(RoutingBuilder.INT_NAME, Converter.asInt());
        }

        public Fragment1<Integer> captureInt(String name) {
            return this.capture(name, Converter.asInt());
        }

        public <T> Fragment1<T> capture(Converter<? extends T> converter) {
            return this.capture(RoutingBuilder.captureName(converter), converter);
        }

        public <T> Fragment1<T> capture(String name, Converter<? extends T> converter) {
            return new Fragment1<T>(this, new Capture.Attachment<T>(name, converter));
        }

        @Override
        Frame<C> resolve() {
            return RoutingBuilder.this.initiatingFrame;
        }

        @Override
        void name(StringBuilder buf) {
            buf.append("/");
        }
    }

    public abstract class AbstractFragment {
        abstract Frame<C> resolve();

        String name() {
            StringBuilder buf = new StringBuilder();
            this.name(buf);
            return buf.toString();
        }

        abstract void name(StringBuilder var1);

        public String toString() {
            StringBuilder buf = new StringBuilder("RoutingBuilder[");
            this.name(buf);
            return buf.append("]").toString();
        }
    }
}

