/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.util;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.function.Function;

public final class RequestContextStore<C>
implements Function<HttpServerExchange, C> {
    private final AttachmentKey<C> key = AttachmentKey.create(Object.class);
    private final Function<? super HttpServerExchange, ? extends C> factory;

    public RequestContextStore(Function<? super HttpServerExchange, ? extends C> factory) {
        this.factory = factory;
    }

    @Override
    public C apply(HttpServerExchange exchange) {
        Object ctx = exchange.getAttachment(this.key);
        if (ctx == null) {
            ctx = this.factory.apply((HttpServerExchange)exchange);
            exchange.putAttachment(this.key, ctx);
        }
        return (C)ctx;
    }

    public HttpHandler createHandler(HttpHandler next) {
        return exchange -> {
            this.apply(exchange);
            next.handleRequest(exchange);
        };
    }
}

