/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.library.base.lifecycle.ShutdownFeature;
import ch.raffael.meldioc.library.base.threading.DefaultWorkExecutorProvider;
import ch.raffael.meldioc.library.base.threading.TaskAdviceFeature;
import ch.raffael.meldioc.library.base.threading.ThreadingFeature;
import ch.raffael.meldioc.library.http.server.undertow.UndertowBlueprint;
import ch.raffael.meldioc.library.http.server.undertow.util.XnioOptions;
import ch.raffael.meldioc.logging.Logging;
import ch.raffael.meldioc.util.advice.AroundAdvice;
import ch.raffael.meldioc.util.concurrent.Disposer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

@Feature
@Parameter.Prefix(value="undertow")
public abstract class UndertowServerFeature<C> {
    public static final String UNDERTOW_PARAM_PREFIX = "undertow";
    private static final Logger LOG = Logging.logger();
    private final UndertowBlueprint.EP<C> undertowBlueprint = UndertowBlueprint.holder(this::createUndertowBuilder);
    protected final Object startStopLock = new Object();
    private final Disposer workerDisposer = new Disposer(this.startStopLock);
    private final Disposer undertowDisposer = new Disposer(this.startStopLock);

    public void start() {
        this.undertowServer();
    }

    public void start(Executor starter) {
        starter.execute(this::start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        Object object = this.startStopLock;
        synchronized (object) {
            this.stopUndertow();
            this.stopWorker();
        }
    }

    public void stopWorker() {
        this.workerDisposer.dispose();
    }

    public void stopUndertow() {
        this.undertowDisposer.dispose();
    }

    @Parameter
    protected int coreWorkers() {
        return this.ioThreads() * 8;
    }

    @Parameter
    protected int maxWorkers() {
        return this.coreWorkers();
    }

    @Parameter
    protected Duration workerKeepAlive() {
        return Duration.ofMinutes(1L);
    }

    @Parameter
    protected int taskQueueLimit() {
        return Integer.MAX_VALUE;
    }

    @Parameter
    protected int ioThreads() {
        return Math.max(Runtime.getRuntime().availableProcessors(), 2);
    }

    @Parameter(value="xnio.worker-options")
    protected Config workerOptions() {
        return ConfigFactory.empty();
    }

    @Parameter(value="xnio.socket-options")
    protected Config socketOptions() {
        return ConfigFactory.empty();
    }

    @Parameter
    protected Config serverOptions() {
        return ConfigFactory.empty();
    }

    @ExtensionPoint
    protected UndertowBlueprint<C> undertowBuilderConfiguration() {
        UndertowBlueprint<C> config = this.undertowBlueprint.acceptor();
        config.postConstruct(u -> this.undertowDisposer.onDispose(() -> {
            LOG.info("Shutting down undertow: {}", (Object)u.getListenerInfo());
            u.stop();
        }));
        this.preConfigure(config);
        return config;
    }

    @Provision(singleton=true)
    protected XnioWorker xnioWorker() {
        Object object = this.startStopLock;
        synchronized (object) {
            Xnio xnio = Xnio.getInstance((ClassLoader)this.xnioClassLoader());
            XnioOptions workerOptions = new XnioOptions(this.xnioClassLoader(), Options.class).set(Options.WORKER_TASK_CORE_THREADS, this.coreWorkers()).set(Options.WORKER_TASK_MAX_THREADS, this.maxWorkers()).set(Options.WORKER_TASK_KEEPALIVE, Math.toIntExact(this.workerKeepAlive().toMillis())).set(Options.WORKER_TASK_LIMIT, this.taskQueueLimit()).set(Options.WORKER_IO_THREADS, this.ioThreads()).set(Options.CONNECTION_HIGH_WATER, 1000000).set(Options.CONNECTION_LOW_WATER, 1000000).set(Options.TCP_NODELAY, true).set(Options.CORK, true).load(this.workerOptions());
            try {
                return (XnioWorker)this.workerDisposer.onDispose((Object)xnio.createWorker(workerOptions.options()), w -> {
                    LOG.info("Shutting down XNIO worker {}", (Object)w.getName());
                    w.shutdownNow();
                });
            }
            catch (IOException e) {
                throw new IllegalStateException("I/O error initializing Xnio worker", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Provision(singleton=true)
    protected Undertow undertowServer() {
        Object object = this.startStopLock;
        synchronized (object) {
            return this.undertowBlueprint.apply();
        }
    }

    protected ClassLoader xnioClassLoader() {
        return this.getClass().getClassLoader();
    }

    protected Undertow.Builder createUndertowBuilder() {
        Undertow.Builder builder = Undertow.builder();
        new XnioOptions(this.xnioClassLoader(), UndertowOptions.class).load(this.serverOptions()).forEach((arg_0, arg_1) -> ((Undertow.Builder)builder).setServerOption(arg_0, arg_1));
        new XnioOptions(this.xnioClassLoader(), Options.class).load(this.socketOptions()).forEach((arg_0, arg_1) -> ((Undertow.Builder)builder).setSocketOption(arg_0, arg_1));
        builder.setWorker(this.xnioWorker());
        return builder;
    }

    protected void preConfigure(UndertowBlueprint<C> config) {
        config.postStart(u -> LOG.info("Undertow started: {}", (Object)u.getListenerInfo()));
    }

    @Feature
    public static abstract class WithSharedWorkersAndShutdown<C>
    extends WithSharedWorkers<C>
    implements ShutdownFeature {
        @Override
        @Provision(singleton=true)
        protected XnioWorker xnioWorker() {
            this.shutdownController().onFinalize(this::stopWorker);
            this.shutdownController().onPrepare(this::stopUndertow);
            return super.xnioWorker();
        }
    }

    @Feature
    public static abstract class WithSharedWorkers<C>
    extends UndertowServerFeature<C>
    implements ThreadingFeature,
    TaskAdviceFeature {
        private final DefaultWorkExecutorProvider workExecutorProvider = new DefaultWorkExecutorProvider(this::xnioWorker);

        @Provision(singleton=true)
        public ExecutorService workExecutor() {
            return this.workExecutorProvider.workExecutor();
        }

        @Provision(singleton=true)
        public AroundAdvice taskAdvice() {
            return this.workExecutorProvider.taskAdvice();
        }

        @ExtensionPoint
        protected TaskAdviceFeature.Profile taskAdviceProfile() {
            return this.workExecutorProvider.taskAdviceProfile();
        }

        public void startAsync() {
            this.start(this.workExecutor());
        }

        @Override
        protected void preConfigure(UndertowBlueprint<C> config) {
            super.preConfigure(config);
            config.dispatchAdvice(this::taskAdvice);
        }
    }

    @Feature
    public static abstract class WithShutdown<C>
    extends UndertowServerFeature<C>
    implements ShutdownFeature {
        @Override
        @Provision(singleton=true)
        protected XnioWorker xnioWorker() {
            this.shutdownController().onPrepare(this::stopAll);
            return super.xnioWorker();
        }
    }
}

