/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.routing.Converter;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.Objects;

public abstract class Capture<T> {
    private final String name;

    Capture(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    abstract T get(HttpServerExchange var1) throws HttpStatusException;

    public <R> Capture<R> map(final Mapper<? super T, ? extends R> mapper) {
        return new Capture<R>(this.name()){

            @Override
            R get(HttpServerExchange exchange) throws HttpStatusException {
                return mapper.map(Capture.this.get(exchange));
            }
        };
    }

    public <T2, R> Capture<R> merge(Capture<? extends T2> that, BiMapper<? super T, ? super T2, ? extends R> mapper) {
        return this.merge(this.name() + "+" + that.name(), that, mapper);
    }

    public <T2, R> Capture<R> merge(String name, final Capture<? extends T2> that, final BiMapper<? super T, ? super T2, ? extends R> mapper) {
        return new Capture<R>(name){

            @Override
            R get(HttpServerExchange exchange) throws HttpStatusException {
                return mapper.map(Capture.this.get(exchange), that.get(exchange));
            }
        };
    }

    @FunctionalInterface
    public static interface BiMapper<T1, T2, R> {
        public R map(T1 var1, T2 var2) throws HttpStatusException;
    }

    @FunctionalInterface
    public static interface Mapper<T, R> {
        public R map(T var1) throws HttpStatusException;
    }

    public static final class Attachment<T>
    extends Capture<T> {
        private final AttachmentKey<String> key = AttachmentKey.create(String.class);
        private final Converter<? extends T> converter;

        Attachment(String name, Converter<? extends T> converter) {
            super(name);
            this.converter = converter;
        }

        @Override
        T get(HttpServerExchange exchange) throws HttpStatusException {
            return (T)Objects.requireNonNullElseGet(this.converter.convert(this.name(), (String)exchange.getAttachment(this.key)), () -> {
                throw new IllegalStateException("No captured value for '" + this.name() + "'");
            });
        }

        void capture(HttpServerExchange exchange, String value) {
            exchange.putAttachment(this.key, (Object)value);
        }
    }
}

