/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.vavr.control.Option;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class TextCodec
implements HttpEncoder<Object, CharSequence>,
HttpDecoder<Object, String> {
    private final ContentType inputContentType;
    private final ContentType outputContentType;

    public TextCodec(ContentType inputContentType, ContentType outputContentType) {
        this.inputContentType = inputContentType.withDefaultCharset(StandardCharsets.UTF_8);
        this.outputContentType = outputContentType.withDefaultCharset(StandardCharsets.UTF_8);
    }

    public TextCodec(ContentType contentType) {
        this(contentType, contentType);
    }

    public TextCodec(ContentType contentType, Charset charset) {
        this(contentType.addCharsetAttribute(charset));
    }

    public TextCodec(ContentType contentType, Charset inCharset, Charset outCharset) {
        this(contentType.addCharsetAttribute(inCharset), contentType.addCharsetAttribute(outCharset));
    }

    public static TextCodec plainText() {
        return TextCodec.plainText(StandardCharsets.UTF_8);
    }

    public static TextCodec plainText(Charset charset) {
        return new TextCodec(ContentTypes.PLAIN_TEXT, charset);
    }

    public static TextCodec plainText(Charset inCharset, Charset outCharset) {
        return new TextCodec(ContentTypes.PLAIN_TEXT, inCharset, outCharset);
    }

    public static TextCodec html() {
        return TextCodec.html(StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
    }

    public static TextCodec html(Charset charset) {
        return new TextCodec(ContentTypes.HTML.addCharsetAttribute(charset));
    }

    public static TextCodec html(Charset inCharset, Charset outCharset) {
        return new TextCodec(ContentTypes.HTML, inCharset, outCharset);
    }

    public static TextCodec xml() {
        return TextCodec.xml(StandardCharsets.UTF_8);
    }

    public static TextCodec xml(Charset charset) {
        return new TextCodec(ContentTypes.XML, charset);
    }

    public static TextCodec xml(Charset inCharset, Charset outCharset) {
        return new TextCodec(ContentTypes.XML, inCharset, outCharset);
    }

    public static TextCodec xhtml() {
        return TextCodec.html(StandardCharsets.UTF_8);
    }

    public static TextCodec xhtml(Charset charset) {
        return new TextCodec(ContentTypes.XHTML.addCharsetAttribute(charset));
    }

    public static TextCodec xhtml(Charset inCharset, Charset outCharset) {
        return new TextCodec(ContentTypes.XHTML, inCharset, outCharset);
    }

    public static TextCodec json() {
        return new TextCodec(ContentTypes.JSON);
    }

    @Override
    public void encode(HttpServerExchange exchange, Object ctx, CharSequence value) {
        ContentType contentType = (ContentType)Option.of((Object)exchange.getRequestHeaders().getFirst(Headers.ACCEPT)).filter(String::isBlank).map(ContentTypes::parseContentTypeListQ).flatMap(ctl -> ctl.find(ct -> ct.equalsTypeOnly(this.outputContentType))).map(ct -> ct.withDefaultCharset((Charset)this.outputContentType.charset().get())).getOrElse((Object)this.outputContentType);
        if (value instanceof String) {
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType.render());
            exchange.getResponseSender().send((String)value, (Charset)contentType.charset().get());
        } else {
            ByteBuffer bytes = ((Charset)this.outputContentType.charset().get()).encode(CharBuffer.wrap(value));
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType.render());
            exchange.getResponseSender().send(bytes);
        }
    }

    @Override
    public void decode(HttpServerExchange exchange, Object ctx, HttpDecoder.Consumer<? super Object, ? super String> consumer) {
        ContentType contentType = (ContentType)Option.of((Object)exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE)).flatMap(ContentTypes::parseContentType).map(ct -> ct.withDefaultCharset((Charset)this.inputContentType.charset().get())).getOrElse((Object)this.inputContentType);
        exchange.getRequestReceiver().receiveFullString((ex, data) -> {
            try {
                consumer.accept(ex, data);
            }
            catch (Exception e) {
                HttpStatusException.serverError(e).endRequest(ex);
            }
        }, HttpStatusException::endRequestWithServerError);
    }
}

