/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.util.advice.AroundAdvice;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.vavr.control.Option;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class AdvisedDispatchHandler
implements HttpHandler {
    private static final AttachmentKey<AroundAdvice> DISPATCH_ADVICE = AttachmentKey.create(AroundAdvice.class);
    private final HttpHandler next;
    private final Supplier<? extends AroundAdvice> advice;

    public AdvisedDispatchHandler(HttpHandler next, Supplier<? extends AroundAdvice> advice) {
        this.advice = advice;
        this.next = next;
    }

    public static HttpHandler prepend(HttpHandler next, Supplier<? extends AroundAdvice> advice) {
        return AdvisedDispatchHandler.prepend(next, (Option<? extends Supplier<? extends AroundAdvice>>)Option.some(advice));
    }

    public static HttpHandler prepend(HttpHandler next, Option<? extends Supplier<? extends AroundAdvice>> advice) {
        return (HttpHandler)advice.map(a -> new AdvisedDispatchHandler(next, (Supplier<? extends AroundAdvice>)a)).getOrElse((Object)next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        AroundAdvice advice = this.advice.get();
        exchange.putAttachment(DISPATCH_ADVICE, (Object)advice);
        exchange.setDispatchExecutor(AdvisedDispatchHandler.standardExecutor(exchange));
        this.next.handleRequest(exchange);
    }

    public static Executor standardExecutor(HttpServerExchange exchange) {
        return AdvisedDispatchHandler.advise(exchange, (AroundAdvice)exchange.getAttachment(DISPATCH_ADVICE), null);
    }

    public static Executor advise(HttpServerExchange exchange, Executor executor) {
        return AdvisedDispatchHandler.advise(exchange, (AroundAdvice)exchange.getAttachment(DISPATCH_ADVICE), executor);
    }

    private static Executor advise(HttpServerExchange exchange, @Nullable AroundAdvice advice, @Nullable Executor executor) {
        Executor x = Objects.requireNonNullElse(executor, r -> exchange.getConnection().getWorker().execute(r));
        if (advice != null) {
            return r -> x.execute(() -> {
                try (AroundAdvice.AdviceCloseable __ = advice.before();){
                    r.run();
                }
            });
        }
        return x;
    }
}

