/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpObjectCodecFactory;
import ch.raffael.meldioc.library.http.server.undertow.codec.TextCodec;
import ch.raffael.meldioc.library.http.server.undertow.handler.AccessCheckHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.HttpMethodHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.PathSegmentHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.ActionBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.Blocks;
import ch.raffael.meldioc.library.http.server.undertow.routing.Capture;
import ch.raffael.meldioc.library.http.server.undertow.routing.Paths;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinition;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinitionException;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class Frame<C> {
    private final RoutingDefinition<C> routingDefinition;
    final Option<Frame<C>> parent;
    private Map<String, Frame<C>> segments = HashMap.empty();
    private Map<HttpMethodHandler.Method, ActionBuilder.LazyActionHandler<C, ?, ?>> actions = HashMap.empty();
    private Option<Tuple2<Seq<Capture.Attachment<?>>, Frame<C>>> captures = Option.none();
    Option<AccessCheckHandler.AccessRestriction> restriction = Option.none();
    Option<HttpObjectCodecFactory<? super C>> objectCodecFactory = Option.none();
    final StandardEncoders enc = new StandardEncoders();
    final StandardDecoders dec = new StandardDecoders();

    Frame(RoutingDefinition<C> routingDefinition, Option<Frame<C>> parent) {
        this.routingDefinition = routingDefinition;
        this.parent = parent;
    }

    Frame<C> pathChild(String path) {
        Frame frame = this;
        for (String seg : Paths.segments(path)) {
            Option child = frame.segments.get((Object)seg);
            if (child.isEmpty()) {
                child = Option.some(new Frame<C>(frame.routingDefinition, Option.some((Object)frame)));
                frame.segments = frame.segments.put((Object)seg, (Object)((Frame)child.get()));
            }
            frame = (Frame)child.get();
        }
        return frame;
    }

    Frame<C> captureChild(Capture.Attachment<?> capture) {
        return this.captureChild((Seq<Capture.Attachment<?>>)List.of(capture));
    }

    Frame<C> captureChild(Seq<Capture.Attachment<?>> capture) {
        this.captures = this.captures.orElse(Option.some((Object)Tuple.of((Object)List.empty(), new Frame<C>(this.routingDefinition, Option.some((Object)this))))).map(t -> t.map1(s -> s.appendAll((Iterable)capture)));
        return (Frame)((Tuple2)this.captures.get())._2;
    }

    private Frame<C> child(String segment) {
        Option child = this.segments.get((Object)segment);
        if (child.isEmpty()) {
            child = Option.some(new Frame<C>(this.routingDefinition, Option.some((Object)this)));
            this.segments = this.segments.put((Object)segment, (Object)((Frame)child.get()));
        }
        return (Frame)child.get();
    }

    void run(Blocks.Block0 block) {
        Frame prev = this.routingDefinition.currentFrame;
        try {
            this.routingDefinition.currentFrame = this;
            block.run();
        }
        finally {
            this.routingDefinition.currentFrame = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T1> void run(Capture<? extends T1> p1, Blocks.Block1<? super T1> block) {
        Frame prev = this.routingDefinition.currentFrame;
        try {
            this.routingDefinition.currentFrame = this;
            block.run(p1);
        }
        finally {
            this.routingDefinition.currentFrame = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T1, T2> void run(Capture<? extends T1> p1, Capture<? extends T2> p2, Blocks.Block2<? super T1, ? super T2> block) {
        Frame prev = this.routingDefinition.currentFrame;
        try {
            this.routingDefinition.currentFrame = this;
            block.run(p1, p2);
        }
        finally {
            this.routingDefinition.currentFrame = prev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T1, T2, T3> void run(Capture<? extends T1> p1, Capture<? extends T2> p2, Capture<? extends T3> p3, Blocks.Block3<? super T1, ? super T2, ? super T3> block) {
        Frame prev = this.routingDefinition.currentFrame;
        try {
            this.routingDefinition.currentFrame = this;
            block.run(p1, p2, p3);
        }
        finally {
            this.routingDefinition.currentFrame = prev;
        }
    }

    void action(HttpMethodHandler.Method method, ActionBuilder.LazyActionHandler<C, ?, ?> handler) {
        if (this.actions.containsKey((Object)method)) {
            throw new RoutingDefinitionException("Duplicate handler for method " + method);
        }
        this.actions = this.actions.put((Object)method, handler);
    }

    HttpHandler handler(Function<? super HttpServerExchange, ? extends C> contextFactory) {
        PathSegmentHandler.Builder routing = PathSegmentHandler.builder();
        ((Option)this.actions.foldLeft((Object)Option.none(), (h, a) -> h.orElse(Option.some((Object)HttpMethodHandler.of((Map<HttpMethodHandler.Method, HttpHandler>)HashMap.empty()))).map(h2 -> h2.add((HttpMethodHandler.Method)((Object)((Object)((Object)a._1))), ((ActionBuilder.LazyActionHandler)a._2).handler(contextFactory, this))))).forEach(routing::hereHandler);
        this.segments.forEach(seg -> routing.exactSegment((String)seg._1, ((Frame)seg._2).handler(contextFactory)));
        this.captures.forEach(cap -> routing.capture((Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>)((Seq)cap._1).map(c -> c::capture), ((Frame)cap._2).handler(contextFactory)));
        return (HttpHandler)this.restriction.map(r -> new AuthenticationConstraintHandler((HttpHandler)new AuthenticationCallHandler((HttpHandler)new AccessCheckHandler((AccessCheckHandler.AccessRestriction)r, routing.build())))).getOrElse(routing::build);
    }

    void merge(Frame<? super C> that) {
        if (that.objectCodecFactory.isDefined()) {
            this.objectCodecFactory = Option.some((Object)((HttpObjectCodecFactory)that.objectCodecFactory.get()));
        }
        that.actions.forEach(a -> this.action((HttpMethodHandler.Method)((Object)((Object)a._1)), ((ActionBuilder.LazyActionHandler)a._2).covariant()));
        that.captures.forEach(thatCaps -> this.captureChild((Seq)thatCaps._1).merge((Frame)thatCaps._2));
        that.segments.forEach(thatSegs -> this.pathChild((String)thatSegs._1).merge((Frame)thatSegs._2));
    }

    private <T> Option<T> find(Function<? super Frame<C>, Option<T>> getter) {
        Option<T> current = getter.apply(this);
        return current.orElse(() -> this.parent.flatMap(p -> p.find(getter)));
    }

    public final class StandardEncoders {
        Option<HttpEncoder<? super C, CharSequence>> plainText = Option.none();
        Option<HttpEncoder<? super C, CharSequence>> html = Option.none();
        Option<HttpEncoder<? super C, Object>> object = Option.none();

        private StandardEncoders() {
        }

        public HttpEncoder<? super C, CharSequence> plainText() {
            return (HttpEncoder)Frame.this.find(t -> t.enc.plainText).getOrElse(TextCodec::plainText);
        }

        public HttpEncoder<? super C, CharSequence> html() {
            return (HttpEncoder)Frame.this.find(t -> t.enc.html).getOrElse(TextCodec::html);
        }

        public <T> HttpEncoder<? super C, ? super T> object(Class<T> type) {
            return (HttpEncoder)Frame.this.find(f -> f.objectCodecFactory.flatMap(ocf -> ocf.encoder(type))).getOrElseThrow(() -> new IllegalStateException("No object decoder for " + type));
        }
    }

    public final class StandardDecoders {
        Option<HttpDecoder<? super C, ? super String>> plainText = Option.none();

        private StandardDecoders() {
        }

        public HttpDecoder<? super C, ? super String> plainText() {
            return (HttpDecoder)Frame.this.find(t -> t.dec.plainText).getOrElse(TextCodec::plainText);
        }

        public <T> HttpDecoder<? super C, ? extends T> object(Class<T> type) {
            return (HttpDecoder)Frame.this.find(f -> f.objectCodecFactory.flatMap(ocf -> ocf.decoder(type))).getOrElseThrow(() -> new IllegalStateException("No object decoder for " + type));
        }
    }
}

