/*
 *  Copyright (c) 2022 Raffael Herzog
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to
 *  deal in the Software without restriction, including without limitation the
 *  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 *  sell copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 *  IN THE SOFTWARE.
 */

package ch.raffael.meldioc.library.http.server.undertow.routing;

// vagen Thu Nov 17 08:23:55 CET 2022
/**
 * TODO JavaDoc
 */
@SuppressWarnings("RedundantSuppression")
public final class Actions {
  private Actions() {
  }

  // Action0

  @SuppressWarnings({"unchecked", "overloads"})
  public static <R> Action0<R> of(Action0<? extends R> action) {
    return (Action0<R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static Action0Void of(Action0Void action) {
    return action;
  }

  public static <R> Action0<R> of(R returnValue, Action0Void action) {
    return () -> {
      action.perform();
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <R> Action0<R> action(Action0<? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static Action0Void action(Action0Void action) {
    return of(action);
  }

  public static <R> Action0<R> action(R returnValue, Action0Void action) {
    return of(returnValue, action);
  }

  // Action1

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, R> Action1<P1, R> of(Action1<? super P1, ? extends R> action) {
    return (Action1<P1, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1> Action1Void<P1> of(Action1Void<? super P1> action) {
    return (Action1Void<P1>) action;
  }

  public static <P1, R> Action1<P1, R> of(R returnValue, Action1Void<? super P1> action) {
    return (P1 arg1) -> {
      action.perform(arg1);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, R> Action1<P1, R> action(Action1<? super P1, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1> Action1Void<P1> action(Action1Void<? super P1> action) {
    return of(action);
  }

  public static <P1, R> Action1<P1, R> action(R returnValue, Action1Void<? super P1> action) {
    return of(returnValue, action);
  }

  // Action2

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, R> Action2<P1, P2, R> of(Action2<? super P1, ? super P2, ? extends R> action) {
    return (Action2<P1, P2, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2> Action2Void<P1, P2> of(Action2Void<? super P1, ? super P2> action) {
    return (Action2Void<P1, P2>) action;
  }

  public static <P1, P2, R> Action2<P1, P2, R> of(R returnValue, Action2Void<? super P1, ? super P2> action) {
    return (P1 arg1, P2 arg2) -> {
      action.perform(arg1, arg2);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, R> Action2<P1, P2, R> action(Action2<? super P1, ? super P2, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2> Action2Void<P1, P2> action(Action2Void<? super P1, ? super P2> action) {
    return of(action);
  }

  public static <P1, P2, R> Action2<P1, P2, R> action(R returnValue, Action2Void<? super P1, ? super P2> action) {
    return of(returnValue, action);
  }

  // Action3

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, R> Action3<P1, P2, P3, R> of(Action3<? super P1, ? super P2, ? super P3, ? extends R> action) {
    return (Action3<P1, P2, P3, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3> Action3Void<P1, P2, P3> of(Action3Void<? super P1, ? super P2, ? super P3> action) {
    return (Action3Void<P1, P2, P3>) action;
  }

  public static <P1, P2, P3, R> Action3<P1, P2, P3, R> of(R returnValue, Action3Void<? super P1, ? super P2, ? super P3> action) {
    return (P1 arg1, P2 arg2, P3 arg3) -> {
      action.perform(arg1, arg2, arg3);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, R> Action3<P1, P2, P3, R> action(Action3<? super P1, ? super P2, ? super P3, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3> Action3Void<P1, P2, P3> action(Action3Void<? super P1, ? super P2, ? super P3> action) {
    return of(action);
  }

  public static <P1, P2, P3, R> Action3<P1, P2, P3, R> action(R returnValue, Action3Void<? super P1, ? super P2, ? super P3> action) {
    return of(returnValue, action);
  }

  // Action4

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, R> Action4<P1, P2, P3, P4, R> of(Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends R> action) {
    return (Action4<P1, P2, P3, P4, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4> Action4Void<P1, P2, P3, P4> of(Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
    return (Action4Void<P1, P2, P3, P4>) action;
  }

  public static <P1, P2, P3, P4, R> Action4<P1, P2, P3, P4, R> of(R returnValue, Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
    return (P1 arg1, P2 arg2, P3 arg3, P4 arg4) -> {
      action.perform(arg1, arg2, arg3, arg4);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, R> Action4<P1, P2, P3, P4, R> action(Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4> Action4Void<P1, P2, P3, P4> action(Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
    return of(action);
  }

  public static <P1, P2, P3, P4, R> Action4<P1, P2, P3, P4, R> action(R returnValue, Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
    return of(returnValue, action);
  }

  // Action5

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, R> Action5<P1, P2, P3, P4, P5, R> of(Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends R> action) {
    return (Action5<P1, P2, P3, P4, P5, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5> Action5Void<P1, P2, P3, P4, P5> of(Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
    return (Action5Void<P1, P2, P3, P4, P5>) action;
  }

  public static <P1, P2, P3, P4, P5, R> Action5<P1, P2, P3, P4, P5, R> of(R returnValue, Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
    return (P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5) -> {
      action.perform(arg1, arg2, arg3, arg4, arg5);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, R> Action5<P1, P2, P3, P4, P5, R> action(Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5> Action5Void<P1, P2, P3, P4, P5> action(Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
    return of(action);
  }

  public static <P1, P2, P3, P4, P5, R> Action5<P1, P2, P3, P4, P5, R> action(R returnValue, Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
    return of(returnValue, action);
  }

  // Action6

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, R> Action6<P1, P2, P3, P4, P5, P6, R> of(Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends R> action) {
    return (Action6<P1, P2, P3, P4, P5, P6, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6> Action6Void<P1, P2, P3, P4, P5, P6> of(Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
    return (Action6Void<P1, P2, P3, P4, P5, P6>) action;
  }

  public static <P1, P2, P3, P4, P5, P6, R> Action6<P1, P2, P3, P4, P5, P6, R> of(R returnValue, Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
    return (P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6) -> {
      action.perform(arg1, arg2, arg3, arg4, arg5, arg6);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, R> Action6<P1, P2, P3, P4, P5, P6, R> action(Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6> Action6Void<P1, P2, P3, P4, P5, P6> action(Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
    return of(action);
  }

  public static <P1, P2, P3, P4, P5, P6, R> Action6<P1, P2, P3, P4, P5, P6, R> action(R returnValue, Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
    return of(returnValue, action);
  }

  // Action7

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, R> Action7<P1, P2, P3, P4, P5, P6, P7, R> of(Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends R> action) {
    return (Action7<P1, P2, P3, P4, P5, P6, P7, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7> Action7Void<P1, P2, P3, P4, P5, P6, P7> of(Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
    return (Action7Void<P1, P2, P3, P4, P5, P6, P7>) action;
  }

  public static <P1, P2, P3, P4, P5, P6, P7, R> Action7<P1, P2, P3, P4, P5, P6, P7, R> of(R returnValue, Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
    return (P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7) -> {
      action.perform(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, R> Action7<P1, P2, P3, P4, P5, P6, P7, R> action(Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7> Action7Void<P1, P2, P3, P4, P5, P6, P7> action(Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
    return of(action);
  }

  public static <P1, P2, P3, P4, P5, P6, P7, R> Action7<P1, P2, P3, P4, P5, P6, P7, R> action(R returnValue, Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
    return of(returnValue, action);
  }

  // Action8

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8, R> Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> of(Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends R> action) {
    return (Action8<P1, P2, P3, P4, P5, P6, P7, P8, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8> Action8Void<P1, P2, P3, P4, P5, P6, P7, P8> of(Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
    return (Action8Void<P1, P2, P3, P4, P5, P6, P7, P8>) action;
  }

  public static <P1, P2, P3, P4, P5, P6, P7, P8, R> Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> of(R returnValue, Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
    return (P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7, P8 arg8) -> {
      action.perform(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8, R> Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> action(Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8> Action8Void<P1, P2, P3, P4, P5, P6, P7, P8> action(Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
    return of(action);
  }

  public static <P1, P2, P3, P4, P5, P6, P7, P8, R> Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> action(R returnValue, Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
    return of(returnValue, action);
  }

  // Action9

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8, P9, R> Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> of(Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends R> action) {
    return (Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R>) action;
  }

  @SuppressWarnings({"unchecked", "overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8, P9> Action9Void<P1, P2, P3, P4, P5, P6, P7, P8, P9> of(Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
    return (Action9Void<P1, P2, P3, P4, P5, P6, P7, P8, P9>) action;
  }

  public static <P1, P2, P3, P4, P5, P6, P7, P8, P9, R> Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> of(R returnValue, Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
    return (P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7, P8 arg8, P9 arg9) -> {
      action.perform(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
      return returnValue;
    };
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8, P9, R> Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> action(Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends R> action) {
    return of(action);
  }

  @SuppressWarnings({"overloads"})
  public static <P1, P2, P3, P4, P5, P6, P7, P8, P9> Action9Void<P1, P2, P3, P4, P5, P6, P7, P8, P9> action(Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
    return of(action);
  }

  public static <P1, P2, P3, P4, P5, P6, P7, P8, P9, R> Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> action(R returnValue, Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
    return of(returnValue, action);
  }

  // Action interfaces

  @FunctionalInterface
  public interface Action0<R> {
    R perform() throws Exception;
  }

  @FunctionalInterface
  public interface Action0Void {
    void perform() throws Exception;
  }

  @FunctionalInterface
  public interface Action1<P1, R> {
    R perform(P1 arg1) throws Exception;
  }

  @FunctionalInterface
  public interface Action1Void<P1> {
    void perform(P1 arg1) throws Exception;
  }

  @FunctionalInterface
  public interface Action2<P1, P2, R> {
    R perform(P1 arg1, P2 arg2) throws Exception;
  }

  @FunctionalInterface
  public interface Action2Void<P1, P2> {
    void perform(P1 arg1, P2 arg2) throws Exception;
  }

  @FunctionalInterface
  public interface Action3<P1, P2, P3, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3) throws Exception;
  }

  @FunctionalInterface
  public interface Action3Void<P1, P2, P3> {
    void perform(P1 arg1, P2 arg2, P3 arg3) throws Exception;
  }

  @FunctionalInterface
  public interface Action4<P1, P2, P3, P4, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4) throws Exception;
  }

  @FunctionalInterface
  public interface Action4Void<P1, P2, P3, P4> {
    void perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4) throws Exception;
  }

  @FunctionalInterface
  public interface Action5<P1, P2, P3, P4, P5, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5) throws Exception;
  }

  @FunctionalInterface
  public interface Action5Void<P1, P2, P3, P4, P5> {
    void perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5) throws Exception;
  }

  @FunctionalInterface
  public interface Action6<P1, P2, P3, P4, P5, P6, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6) throws Exception;
  }

  @FunctionalInterface
  public interface Action6Void<P1, P2, P3, P4, P5, P6> {
    void perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6) throws Exception;
  }

  @FunctionalInterface
  public interface Action7<P1, P2, P3, P4, P5, P6, P7, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7) throws Exception;
  }

  @FunctionalInterface
  public interface Action7Void<P1, P2, P3, P4, P5, P6, P7> {
    void perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7) throws Exception;
  }

  @FunctionalInterface
  public interface Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7, P8 arg8) throws Exception;
  }

  @FunctionalInterface
  public interface Action8Void<P1, P2, P3, P4, P5, P6, P7, P8> {
    void perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7, P8 arg8) throws Exception;
  }

  @FunctionalInterface
  public interface Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> {
    R perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7, P8 arg8, P9 arg9) throws Exception;
  }

  @FunctionalInterface
  public interface Action9Void<P1, P2, P3, P4, P5, P6, P7, P8, P9> {
    void perform(P1 arg1, P2 arg2, P3 arg3, P4 arg4, P5 arg5, P6 arg6, P7 arg7, P8 arg8, P9 arg9) throws Exception;
  }
}
