/*
 *  Copyright (c) 2022 Raffael Herzog
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to
 *  deal in the Software without restriction, including without limitation the
 *  rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 *  sell copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 *  IN THE SOFTWARE.
 */

package ch.raffael.meldioc.library.http.server.undertow.routing;

// vagen Thu Nov 17 08:23:55 CET 2022
/**
 * TODO JavaDoc
 */
public final class Blocks {
  private Blocks() {
  }

  @FunctionalInterface
  public interface Block0 {
    void run();
  }

  @FunctionalInterface
  public interface Block1<T1> {
    void run(Capture<? extends T1> v1);
  }

  @FunctionalInterface
  public interface Block2<T1, T2> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2);
  }

  @FunctionalInterface
  public interface Block3<T1, T2, T3> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3);
  }

  @FunctionalInterface
  public interface Block4<T1, T2, T3, T4> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4);
  }

  @FunctionalInterface
  public interface Block5<T1, T2, T3, T4, T5> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5);
  }

  @FunctionalInterface
  public interface Block6<T1, T2, T3, T4, T5, T6> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6);
  }

  @FunctionalInterface
  public interface Block7<T1, T2, T3, T4, T5, T6, T7> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7);
  }

  @FunctionalInterface
  public interface Block8<T1, T2, T3, T4, T5, T6, T7, T8> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Capture<? extends T8> v8);
  }

  @FunctionalInterface
  public interface Block9<T1, T2, T3, T4, T5, T6, T7, T8, T9> {
    void run(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Capture<? extends T8> v8, Capture<? extends T9> v9);
  }

  static <T> Curry1<T> curry(Capture<? extends T> v1) {
    return new Curry1<>(v1);
  }

  static <T1, T2> Curry2<T1, T2> curry(Capture<? extends T1> v1, Capture<? extends T2> v2) {
    return Blocks.<T1>curry(v1).append(v2);
  }
  static <T1, T2, T3> Curry3<T1, T2, T3> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3) {
    return Blocks.<T1, T2>curry(v1, v2).append(v3);
  }
  static <T1, T2, T3, T4> Curry4<T1, T2, T3, T4> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4) {
    return Blocks.<T1, T2, T3>curry(v1, v2, v3).append(v4);
  }
  static <T1, T2, T3, T4, T5> Curry5<T1, T2, T3, T4, T5> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5) {
    return Blocks.<T1, T2, T3, T4>curry(v1, v2, v3, v4).append(v5);
  }
  static <T1, T2, T3, T4, T5, T6> Curry6<T1, T2, T3, T4, T5, T6> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6) {
    return Blocks.<T1, T2, T3, T4, T5>curry(v1, v2, v3, v4, v5).append(v6);
  }
  static <T1, T2, T3, T4, T5, T6, T7> Curry7<T1, T2, T3, T4, T5, T6, T7> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7) {
    return Blocks.<T1, T2, T3, T4, T5, T6>curry(v1, v2, v3, v4, v5, v6).append(v7);
  }
  static <T1, T2, T3, T4, T5, T6, T7, T8> Curry8<T1, T2, T3, T4, T5, T6, T7, T8> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Capture<? extends T8> v8) {
    return Blocks.<T1, T2, T3, T4, T5, T6, T7>curry(v1, v2, v3, v4, v5, v6, v7).append(v8);
  }
  static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Curry9<T1, T2, T3, T4, T5, T6, T7, T8, T9> curry(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Capture<? extends T8> v8, Capture<? extends T9> v9) {
    return Blocks.<T1, T2, T3, T4, T5, T6, T7, T8>curry(v1, v2, v3, v4, v5, v6, v7, v8).append(v9);
  }

  static class Curry1<T1> {
    private final Capture<? extends T1> curry;

    Curry1(Capture<? extends T1> curry) {
      this.curry = curry;
    }

    void run(Block1<? super T1> block) {
      block.run(curry);
    }

    Block0 runnable(Block1<? super T1> block) {
      return () -> run(block);
    }

    <T> Curry2<T1, T> append(Capture<? extends T> curry) {
      return new Curry2<>(this, curry);
    }
  }

  static class Curry2<T1, T2> {
    private final Curry1<? extends T1> prev;
    private final Capture<? extends T2> curry;

    Curry2(Curry1<? extends T1> prev, Capture<? extends T2> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block2<? super T1, ? super T2> block) {
      block.run(prev.curry, curry);
    }

    Block0 runnable(Block2<? super T1, ? super T2> block) {
      return () -> run(block);
    }

    <T> Curry3<T1, T2, T> append(Capture<? extends T> curry) {
      return new Curry3<>(this, curry);
    }
  }

  static class Curry3<T1, T2, T3> {
    private final Curry2<? extends T1, ? extends T2> prev;
    private final Capture<? extends T3> curry;

    Curry3(Curry2<? extends T1, ? extends T2> prev, Capture<? extends T3> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block3<? super T1, ? super T2, ? super T3> block) {
      block.run(prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block3<? super T1, ? super T2, ? super T3> block) {
      return () -> run(block);
    }

    <T> Curry4<T1, T2, T3, T> append(Capture<? extends T> curry) {
      return new Curry4<>(this, curry);
    }
  }

  static class Curry4<T1, T2, T3, T4> {
    private final Curry3<? extends T1, ? extends T2, ? extends T3> prev;
    private final Capture<? extends T4> curry;

    Curry4(Curry3<? extends T1, ? extends T2, ? extends T3> prev, Capture<? extends T4> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block4<? super T1, ? super T2, ? super T3, ? super T4> block) {
      block.run(prev.prev.prev.curry, prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block4<? super T1, ? super T2, ? super T3, ? super T4> block) {
      return () -> run(block);
    }

    <T> Curry5<T1, T2, T3, T4, T> append(Capture<? extends T> curry) {
      return new Curry5<>(this, curry);
    }
  }

  static class Curry5<T1, T2, T3, T4, T5> {
    private final Curry4<? extends T1, ? extends T2, ? extends T3, ? extends T4> prev;
    private final Capture<? extends T5> curry;

    Curry5(Curry4<? extends T1, ? extends T2, ? extends T3, ? extends T4> prev, Capture<? extends T5> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5> block) {
      block.run(prev.prev.prev.prev.curry, prev.prev.prev.curry, prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5> block) {
      return () -> run(block);
    }

    <T> Curry6<T1, T2, T3, T4, T5, T> append(Capture<? extends T> curry) {
      return new Curry6<>(this, curry);
    }
  }

  static class Curry6<T1, T2, T3, T4, T5, T6> {
    private final Curry5<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5> prev;
    private final Capture<? extends T6> curry;

    Curry6(Curry5<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5> prev, Capture<? extends T6> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> block) {
      block.run(prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.curry, prev.prev.prev.curry, prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6> block) {
      return () -> run(block);
    }

    <T> Curry7<T1, T2, T3, T4, T5, T6, T> append(Capture<? extends T> curry) {
      return new Curry7<>(this, curry);
    }
  }

  static class Curry7<T1, T2, T3, T4, T5, T6, T7> {
    private final Curry6<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5, ? extends T6> prev;
    private final Capture<? extends T7> curry;

    Curry7(Curry6<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5, ? extends T6> prev, Capture<? extends T7> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7> block) {
      block.run(prev.prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.curry, prev.prev.prev.curry, prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7> block) {
      return () -> run(block);
    }

    <T> Curry8<T1, T2, T3, T4, T5, T6, T7, T> append(Capture<? extends T> curry) {
      return new Curry8<>(this, curry);
    }
  }

  static class Curry8<T1, T2, T3, T4, T5, T6, T7, T8> {
    private final Curry7<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5, ? extends T6, ? extends T7> prev;
    private final Capture<? extends T8> curry;

    Curry8(Curry7<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5, ? extends T6, ? extends T7> prev, Capture<? extends T8> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8> block) {
      block.run(prev.prev.prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.curry, prev.prev.prev.curry, prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8> block) {
      return () -> run(block);
    }

    <T> Curry9<T1, T2, T3, T4, T5, T6, T7, T8, T> append(Capture<? extends T> curry) {
      return new Curry9<>(this, curry);
    }
  }

  static class Curry9<T1, T2, T3, T4, T5, T6, T7, T8, T9> {
    private final Curry8<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5, ? extends T6, ? extends T7, ? extends T8> prev;
    private final Capture<? extends T9> curry;

    Curry9(Curry8<? extends T1, ? extends T2, ? extends T3, ? extends T4, ? extends T5, ? extends T6, ? extends T7, ? extends T8> prev, Capture<? extends T9> curry) {
      this.prev = prev;
      this.curry = curry;
    }

    void run(Block9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> block) {
      block.run(prev.prev.prev.prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.prev.curry, prev.prev.prev.prev.curry, prev.prev.prev.curry, prev.prev.curry, prev.curry, curry);
    }

    Block0 runnable(Block9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9> block) {
      return () -> run(block);
    }
  }
}
