/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow;

import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.library.http.server.undertow.handler.AdvisedDispatchHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.DispatchToWorkerHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.ErrorMessageHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinition;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinitions;
import ch.raffael.meldioc.util.advice.AroundAdvice;
import io.undertow.Undertow;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.Nullable;

@ExtensionPoint
public final class UndertowConfig {
    public static final String ADDRESS_ALL = "0.0.0.0";
    public static final String ADDRESS_LOCAL = "localhost";
    private static final Function<HttpHandler, HttpHandler> DISPATCH = DispatchToWorkerHandler::new;
    private static final Function<HttpHandler, HttpHandler> COMPRESS = n -> new EncodingHandler.Builder().build(Map.of()).wrap(n);
    private static final Function<HttpHandler, HttpHandler> ERROR = ErrorMessageHandler::new;
    private Seq<Consumer<? super Undertow.Builder>> listeners = io.vavr.collection.List.empty();
    private Seq<Function<? super HttpHandler, ? extends HttpHandler>> handlerChain = io.vavr.collection.List.of((Object[])new Function[]{DISPATCH, COMPRESS, ERROR});
    @Nullable
    private Supplier<? extends HttpHandler> mainHandler = null;
    private Seq<Consumer<? super Undertow>> postConstruct = io.vavr.collection.List.empty();
    private Seq<Consumer<? super Undertow>> postStart = io.vavr.collection.List.empty();
    private Option<? extends Supplier<? extends AroundAdvice>> dispatchAdvice = Option.none();

    public static Handle create(Supplier<? extends Undertow.Builder> undertowBuilderSupplier) {
        return new Handle(new UndertowConfig(), undertowBuilderSupplier);
    }

    public UndertowConfig httpAll(int port) {
        return this.http(ADDRESS_ALL, port);
    }

    public UndertowConfig httpLocal(int port) {
        return this.http(ADDRESS_LOCAL, port);
    }

    public UndertowConfig http(String address, int port) {
        this.listeners = this.listeners.append(b -> b.addHttpListener(port, address));
        return this;
    }

    public synchronized UndertowConfig httpAllSecure(int port, SSLContext sslContext) {
        return this.httpSecure(ADDRESS_ALL, port, sslContext);
    }

    public synchronized UndertowConfig httpLocalSecure(int port, SSLContext sslContext) {
        return this.httpSecure(ADDRESS_LOCAL, port, sslContext);
    }

    public synchronized UndertowConfig httpSecure(String address, int port, SSLContext sslContext) {
        this.listeners = this.listeners.append(b -> b.addHttpsListener(port, address, sslContext));
        return this;
    }

    public UndertowConfig handler(Function<? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlerChain = this.handlerChain.append(handler);
        return this;
    }

    public UndertowConfig prependHandler(Function<? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlerChain = this.handlerChain.prepend(handler);
        return this;
    }

    public UndertowConfig dispatchAdvice(Supplier<? extends AroundAdvice> dispatchAdvice) {
        return this.dispatchAdvice((Option<? extends Supplier<? extends AroundAdvice>>)Option.some(dispatchAdvice));
    }

    public UndertowConfig dispatchAdvice(Option<? extends Supplier<? extends AroundAdvice>> dispatchAdvice) {
        this.dispatchAdvice = dispatchAdvice;
        return this;
    }

    public SecurityBuilder security(IdentityManager identityManager) {
        return new SecurityBuilder(this, identityManager);
    }

    public UndertowConfig security(IdentityManager identityManager, AuthenticationMechanism ... mechanisms) {
        return new SecurityBuilder(this, identityManager).mechanism(mechanisms).end();
    }

    public UndertowConfig security(IdentityManager identityManager, Iterable<? extends AuthenticationMechanism> mechanisms) {
        return new SecurityBuilder(this, identityManager).mechanism(mechanisms).end();
    }

    public UndertowConfig basicSecurity(IdentityManager identityManager) {
        return new SecurityBuilder(this, identityManager).basicAuth().end();
    }

    public UndertowConfig basicSecurity(IdentityManager identityManager, String realm) {
        return new SecurityBuilder(this, identityManager).basicAuth(realm).end();
    }

    public UndertowConfig customMainHandler(Supplier<? extends HttpHandler> mainHandler) {
        this.mainHandler = mainHandler;
        return this;
    }

    public UndertowConfig routing(Supplier<? extends RoutingDefinition> routing) {
        return this.customMainHandler(() -> RoutingDefinitions.materialize((RoutingDefinition)routing.get()));
    }

    public UndertowConfig disableCompression() {
        this.handlerChain = this.handlerChain.remove(COMPRESS);
        return this;
    }

    public UndertowConfig disableStandardErrorHandler() {
        this.handlerChain = this.handlerChain.remove(ERROR);
        return this;
    }

    public UndertowConfig disableEarlyDispatch() {
        this.handlerChain = this.handlerChain.remove(DISPATCH);
        return this;
    }

    public UndertowConfig enableStackTraces() {
        return this.enableStackTraces(true);
    }

    public UndertowConfig enableStackTraces(boolean enable) {
        if (enable) {
            this.handlerChain = this.handlerChain.prepend(ErrorMessageHandler.ExceptionRenderer::enableStackTracesHandler);
        }
        return this;
    }

    public UndertowConfig enableStackTraces(Supplier<Boolean> enable) {
        this.handlerChain = this.handlerChain.prepend(n -> ErrorMessageHandler.ExceptionRenderer.enableStackTracesHandler(n, enable));
        return this;
    }

    public UndertowConfig enableStackTraces(Predicate<? super HttpServerExchange> enable) {
        this.handlerChain = this.handlerChain.prepend(n -> ErrorMessageHandler.ExceptionRenderer.enableStackTracesHandler(n, enable));
        return this;
    }

    public UndertowConfig clearHandlerChain() {
        this.handlerChain = io.vavr.collection.List.empty();
        return this;
    }

    public UndertowConfig addCompressionHandler() {
        return this.addStandardHandler(COMPRESS);
    }

    public UndertowConfig addStandardErrorHandler() {
        return this.addStandardHandler(ERROR);
    }

    public UndertowConfig addDispatchHandler() {
        return this.addStandardHandler(DISPATCH);
    }

    private UndertowConfig addStandardHandler(Function<HttpHandler, HttpHandler> handler) {
        if (!this.handlerChain.contains(handler)) {
            this.handlerChain = this.handlerChain.append(handler);
        }
        return this;
    }

    public UndertowConfig postConstruct(Consumer<? super Undertow> consumer) {
        this.postConstruct = this.postConstruct.append(consumer);
        return this;
    }

    public UndertowConfig postStart(Consumer<? super Undertow> consumer) {
        this.postStart = this.postStart.append(consumer);
        return this;
    }

    public static class Handle {
        private final UndertowConfig config;
        private final Supplier<? extends Undertow.Builder> undertowBuilderSupplier;

        protected Handle(UndertowConfig config, Supplier<? extends Undertow.Builder> undertowBuilderSupplier) {
            this.config = config;
            this.undertowBuilderSupplier = undertowBuilderSupplier;
        }

        public UndertowConfig config() {
            return this.config;
        }

        public Undertow apply() {
            return this.start(this.build(this.prepareBuilder()));
        }

        protected Undertow.Builder prepareBuilder() {
            if (this.config.listeners.isEmpty()) {
                throw new IllegalStateException("No listeners");
            }
            if (this.config.mainHandler == null) {
                throw new IllegalStateException("No main handler");
            }
            Undertow.Builder builder = this.undertowBuilderSupplier.get();
            this.config.listeners.forEach(l -> l.accept(builder));
            HttpHandler handler = (HttpHandler)this.config.handlerChain.foldRight((Object)this.config.mainHandler.get(), Function::apply);
            builder.setHandler(AdvisedDispatchHandler.prepend(handler, this.config.dispatchAdvice));
            return builder;
        }

        public Undertow build(Undertow.Builder builder) {
            Undertow undertow = builder.build();
            this.config.postConstruct.forEach(h -> h.accept(undertow));
            return undertow;
        }

        public Undertow start(Undertow undertow) {
            undertow.start();
            this.config.postStart.forEach(h -> h.accept(undertow));
            return undertow;
        }
    }

    public static final class SecurityBuilder {
        private final UndertowConfig parent;
        private final IdentityManager identityManager;
        private AuthenticationMode authenticationMode = AuthenticationMode.CONSTRAINT_DRIVEN;
        private Seq<AuthenticationMechanism> mechanisms = io.vavr.collection.List.empty();

        private SecurityBuilder(UndertowConfig parent, IdentityManager identityManager) {
            this.parent = parent;
            this.identityManager = identityManager;
        }

        public SecurityBuilder constraintDriven() {
            return this.authenticationMode(AuthenticationMode.CONSTRAINT_DRIVEN);
        }

        public SecurityBuilder proActive() {
            return this.authenticationMode(AuthenticationMode.PRO_ACTIVE);
        }

        public SecurityBuilder authenticationMode(AuthenticationMode mode) {
            this.authenticationMode = mode;
            return this;
        }

        public SecurityBuilder mechanism(AuthenticationMechanism ... mechanisms) {
            return this.mechanism(Arrays.asList(mechanisms));
        }

        public SecurityBuilder mechanism(Iterable<? extends AuthenticationMechanism> mechanisms) {
            this.mechanisms = this.mechanisms.appendAll(mechanisms);
            return this;
        }

        public SecurityBuilder basicAuth() {
            return this.mechanism(new AuthenticationMechanism[]{new BasicAuthenticationMechanism("undertow")});
        }

        public SecurityBuilder basicAuth(String realm) {
            return this.mechanism(new AuthenticationMechanism[]{new BasicAuthenticationMechanism(realm)});
        }

        public UndertowConfig end() {
            List mechanisms = (List)Option.of(this.mechanisms).filter(l -> !l.isEmpty()).map(Seq::asJava).getOrElseThrow(() -> new IllegalStateException("No security mechanisms"));
            return this.parent.handler(n -> new SecurityInitialHandler(this.authenticationMode, this.identityManager, (HttpHandler)new AuthenticationMechanismsHandler(n, mechanisms)));
        }
    }
}

