/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ContentTypes;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.vavr.collection.Array;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Traversable;

public abstract class BinaryCodec<T>
implements HttpEncoder<T>,
HttpDecoder<T> {
    private final Seq<ContentType> contentTypes;

    protected BinaryCodec(String ... contentTypes) {
        this((Traversable<? extends ContentType>)Stream.of((Object[])contentTypes).map(t -> (ContentType)ContentTypes.parseContentType((String)t).getOrElseThrow(() -> new IllegalArgumentException("Cannot parse content type: " + t))));
    }

    protected BinaryCodec(ContentType contentType) {
        this((Traversable<? extends ContentType>)List.of((Object)contentType));
    }

    BinaryCodec(Traversable<? extends ContentType> contentTypes) {
        this.contentTypes = contentTypes.isEmpty() ? List.of((Object)ContentTypes.OCTET_STREAM) : Traversable.narrow(contentTypes).toList();
    }

    @Override
    public void decode(HttpServerExchange exchange, HttpDecoder.Consumer<? super T> consumer) throws Exception {
        exchange.getRequestReceiver().receiveFullBytes((ex, bytes) -> {
            try {
                consumer.accept(ex, (T)this.fromBytes(bytes));
            }
            catch (Exception e) {
                HttpStatusException.serverError(e).endRequest(exchange);
            }
        }, HttpStatusException::endRequestWithServerError);
    }

    @Override
    public void encode(HttpServerExchange exchange, T value) {
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, ((ContentType)this.contentTypes.headOption().getOrElse((Object)ContentTypes.OCTET_STREAM)).render());
        exchange.getResponseSender().send(this.toByteBuffers(value));
    }

    protected abstract java.nio.ByteBuffer[] toByteBuffers(T var1);

    protected abstract T fromBytes(byte[] var1);

    public static final class ByteBufferArray
    extends BinaryCodec<java.nio.ByteBuffer[]> {
        public ByteBufferArray(String ... contentTypes) {
            super(contentTypes);
        }

        public ByteBufferArray(ContentType ... contentType) {
            super((Traversable<? extends ContentType>)Array.of((Object[])contentType));
        }

        public ByteBufferArray(Traversable<? extends ContentType> contentTypes) {
            super(contentTypes);
        }

        @Override
        protected java.nio.ByteBuffer[] toByteBuffers(java.nio.ByteBuffer[] value) {
            return value;
        }

        @Override
        protected java.nio.ByteBuffer[] fromBytes(byte[] bytes) {
            return new java.nio.ByteBuffer[]{java.nio.ByteBuffer.wrap(bytes)};
        }
    }

    public static final class ByteBuffer
    extends BinaryCodec<java.nio.ByteBuffer> {
        public ByteBuffer(String ... contentTypes) {
            super(contentTypes);
        }

        public ByteBuffer(ContentType ... contentType) {
            super((Traversable<? extends ContentType>)Array.of((Object[])contentType));
        }

        public ByteBuffer(Traversable<? extends ContentType> contentTypes) {
            super(contentTypes);
        }

        @Override
        protected java.nio.ByteBuffer[] toByteBuffers(java.nio.ByteBuffer value) {
            return new java.nio.ByteBuffer[]{value};
        }

        @Override
        protected java.nio.ByteBuffer fromBytes(byte[] bytes) {
            return java.nio.ByteBuffer.wrap(bytes);
        }
    }

    public static final class ByteArray
    extends BinaryCodec<byte[]> {
        public ByteArray(String ... contentTypes) {
            super(contentTypes);
        }

        public ByteArray(ContentType ... contentType) {
            super((Traversable<? extends ContentType>)Array.of((Object[])contentType));
        }

        public ByteArray(Traversable<? extends ContentType> contentTypes) {
            super(contentTypes);
        }

        @Override
        protected java.nio.ByteBuffer[] toByteBuffers(byte[] value) {
            return new java.nio.ByteBuffer[]{java.nio.ByteBuffer.wrap(value)};
        }

        @Override
        protected byte[] fromBytes(byte[] bytes) {
            return bytes;
        }
    }
}

