/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.codec;

import ch.raffael.meldioc.library.codec.ObjectDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.EmptyBody;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.vavr.control.Option;
import java.util.function.Supplier;

public interface HttpDecoder<B> {
    public void decode(HttpServerExchange var1, Consumer<? super B> var2) throws Exception;

    public static <B> HttpDecoder<B> wrapBuffered(ObjectDecoder<? extends B> decoder) {
        return (exchange, consumer) -> exchange.getRequestReceiver().receiveFullBytes((ex, bytes) -> {
            block2: {
                try {
                    consumer.accept(exchange, decoder.decode(bytes));
                }
                catch (Exception e) {
                    if (!decoder.isInvalidInput((Throwable)e)) break block2;
                    HttpStatusException.badRequest(e.toString(), e).endRequest(exchange);
                }
            }
        }, HttpStatusException::endRequestWithServerError);
    }

    public static Option<String> contentType(HeaderMap headers) {
        String contentType = headers.getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return Option.none();
        }
        int pos = contentType.indexOf(59);
        return Option.some((Object)(pos < 0 ? contentType : contentType.substring(0, pos)).trim());
    }

    @FunctionalInterface
    public static interface Consumer<B> {
        public void accept(HttpServerExchange var1, B var2) throws Exception;
    }

    public static class IgnoreBodyDecoder<B>
    implements HttpDecoder<B> {
        private static final IgnoreBodyDecoder<EmptyBody> EMPTY_BODY = new IgnoreBodyDecoder<EmptyBody>(EmptyBody::instance);
        private final Supplier<? extends B> body;

        public IgnoreBodyDecoder(Supplier<? extends B> body) {
            this.body = body;
        }

        public static IgnoreBodyDecoder<EmptyBody> emptyBody() {
            return EMPTY_BODY;
        }

        @Override
        public void decode(HttpServerExchange exchange, Consumer<? super B> consumer) throws Exception {
            consumer.accept(exchange, this.body.get());
        }
    }
}

