/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.http.server.undertow.security.Role;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.vavr.Value;
import io.vavr.collection.Array;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.Objects;
import java.util.function.Function;

public class AccessCheckHandler
implements HttpHandler {
    private final AccessRestriction restriction;
    private final HttpHandler next;

    public AccessCheckHandler(AccessRestriction restriction, HttpHandler next) {
        this.restriction = restriction;
        this.next = next;
    }

    public static <R extends Role> AccessByRole<R> accessByRole(Function<? super String, ? extends Option<? extends R>> mapper, Set<? extends R> roles) {
        return new AccessByRole<R>(mapper, roles);
    }

    public static <R extends Enum<?>> AccessByRoleEnum<R> accessByRole(Class<R> enumType, Set<? extends R> roles) {
        return new AccessByRoleEnum<R>(enumType, roles);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext securityContext = Objects.requireNonNull(exchange.getSecurityContext(), "exchange.getSecurityContext()");
        boolean forbidden = true;
        Account account = securityContext.getAuthenticatedAccount();
        if (account != null) {
            boolean bl = forbidden = !this.restriction.accessPermitted(account);
        }
        if (forbidden) {
            new HttpStatusException(HttpStatus.FORBIDDEN).endRequest(exchange);
        } else {
            this.next.handleRequest(exchange);
        }
    }

    private static <T extends Enum<?>> Function<String, Option<T>> enumMapper(Class<T> roleEnum) {
        return arg_0 -> ((Map)Array.of((Object[])((Enum[])roleEnum.getEnumConstants())).toMap(rec$ -> ((Role)rec$).name(), Function.identity())).get(arg_0);
    }

    public static interface AccessRestriction {
        public boolean accessPermitted(Account var1);
    }

    public static class AccessByRole<R extends Role>
    implements AccessRestriction {
        private final Function<? super String, ? extends Option<? extends R>> mapper;
        private final Set<? extends R> roles;

        public AccessByRole(Function<? super String, ? extends Option<? extends R>> mapper, Set<? extends R> roles) {
            this.mapper = mapper;
            this.roles = roles;
        }

        @Override
        public boolean accessPermitted(Account account) {
            return account.getRoles().stream().map(this.mapper).flatMap(Value::toJavaStream).anyMatch(r -> this.roles.exists(r::implies));
        }

        public String toString() {
            return this.getClass().getName() + "[" + String.valueOf(this.roles) + "]";
        }
    }

    static class AccessByRoleEnum<R extends Enum<?>>
    extends AccessByRole<R> {
        public AccessByRoleEnum(Class<R> enumType, Set<? extends R> roles) {
            super(AccessCheckHandler.enumMapper(enumType), roles);
        }
    }
}

