/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.http.server.undertow.codec.EmptyBody;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.handler.ErrorMessageHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.Actions;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import ch.raffael.meldioc.util.Exceptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.function.Function;
import java.util.function.Supplier;

public class EndpointHandler<B, T>
implements HttpHandler {
    private static final Function<? super HttpServerExchange, ?> INITIAL_CONTEXT = e -> {
        throw new IllegalStateException("Context factory not set");
    };
    private final HttpStatus defaultStatus;
    private final Supplier<? extends HttpDecoder<? extends B>> decoder;
    private final Processor<? super B, ? extends T> processor;
    private final Option<Supplier<? extends HttpEncoder<? super T>>> encoder;

    public EndpointHandler(HttpStatus defaultStatus, Supplier<? extends HttpDecoder<? extends B>> decoder, Processor<? super B, ? extends T> processor, Option<Supplier<? extends HttpEncoder<? super T>>> encoder) {
        this.defaultStatus = defaultStatus;
        this.decoder = decoder;
        this.processor = processor;
        this.encoder = encoder;
    }

    public static EndpointHandler<EmptyBody, EmptyBody> initial() {
        return new EndpointHandler<EmptyBody, EmptyBody>(HttpStatus.OK, HttpDecoder.IgnoreBodyDecoder::emptyBody, Processor.nop(), Option.none());
    }

    public EndpointHandler<B, T> defaultStatus(HttpStatus defaultStatus) {
        return new EndpointHandler<B, T>(defaultStatus, this.decoder, this.processor, this.encoder);
    }

    public <BB> EndpointHandler<BB, BB> decoder(Supplier<? extends HttpDecoder<? extends BB>> decoder) {
        return new EndpointHandler(this.defaultStatus, decoder, Processor.nop(), Option.none());
    }

    public <BB> EndpointHandler<BB, BB> decoder(HttpDecoder<? extends BB> decoder) {
        return this.decoder(() -> decoder);
    }

    public <U> EndpointHandler<B, U> processor(Processor<? super T, ? extends U> next) {
        return new EndpointHandler<B, U>(this.defaultStatus, this.decoder, this.processor.append(next), Option.none());
    }

    public EndpointHandler<B, T> encoder(Supplier<? extends HttpEncoder<? super T>> encoder) {
        return new EndpointHandler<B, T>(this.defaultStatus, this.decoder, this.processor, Option.some(encoder));
    }

    public EndpointHandler<B, T> encoder(HttpEncoder<? super T> encoder) {
        return this.encoder(() -> encoder);
    }

    public EndpointHandler<B, T> fallbackEncoder(Supplier<? extends HttpEncoder<? super T>> encoder) {
        if (this.encoder.isDefined()) {
            return this;
        }
        return this.encoder(encoder);
    }

    public EndpointHandler<B, T> fallbackEncoder(HttpEncoder<? super T> encoder) {
        return this.fallbackEncoder(() -> encoder);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        this.decoder.get().decode(exchange, this::consumeBody);
    }

    private void consumeBody(HttpServerExchange exchange, B body) {
        State<T> result = Processor.invoke(State.of(exchange, body), this.processor);
        if (result.isException()) {
            Throwable exception = result.exception();
            ErrorMessageHandler.addMessage(exchange, exception);
            if (result.exceptionHttpStatus().isDefined()) {
                this.applyHttpStatus(exchange, (HttpStatus)result.exceptionHttpStatus().get());
            } else if (exception instanceof HttpStatusException) {
                this.applyHttpStatus(exchange, ((HttpStatusException)exception).status());
            } else {
                this.applyHttpStatus(exchange, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else {
            this.applyHttpStatus(exchange, (HttpStatus)result.httpStatus.getOrElse((Object)this.defaultStatus));
            if (this.encoder.isEmpty() || result.value() instanceof EmptyBody) {
                EmptyBody.encoder().encode(exchange, EmptyBody.empty());
            } else {
                ((HttpEncoder)((Supplier)this.encoder.get()).get()).encode(exchange, result.value());
            }
        }
    }

    private void applyHttpStatus(HttpServerExchange exchange, HttpStatus status) {
        exchange.setStatusCode(status.code());
        exchange.setReasonPhrase(status.reason());
    }

    @FunctionalInterface
    public static interface Processor<T, R> {
        public State<? extends R> process(State<? extends T> var1) throws Exception;

        default public <U> Processor<T, U> append(Processor<? super R, ? extends U> next) {
            return s -> Processor.invoke(Processor.invoke(s, this), next);
        }

        public static <T> Processor<T, T> nop() {
            return s -> s;
        }

        public static <T, U> State<? extends U> invoke(State<T> state, Processor<? super T, ? extends U> processor) {
            try {
                return processor.process(state);
            }
            catch (Throwable e) {
                Exceptions.rethrowIfFatal((Throwable)e, (Throwable)(state.isException() ? state.exception() : null));
                return state.exception(e);
            }
        }
    }

    public static final class State<T> {
        final HttpServerExchange exchange;
        final Either<Throwable, T> value;
        final Option<HttpStatus> httpStatus;
        final Option<HttpStatus> exceptionHttpStatus;

        private State(HttpServerExchange exchange, Either<Throwable, T> value, Option<HttpStatus> httpStatus, Option<HttpStatus> exceptionHttpStatus) {
            this.exchange = exchange;
            this.value = value;
            this.httpStatus = httpStatus;
            this.exceptionHttpStatus = exceptionHttpStatus;
        }

        private static <B> State<B> of(HttpServerExchange exchange, B body) {
            return new State(exchange, Either.right(body), (Option<HttpStatus>)Option.none(), (Option<HttpStatus>)Option.none());
        }

        public boolean isException() {
            return this.value.isLeft();
        }

        public <U> State<U> promoteException() {
            this.checkException();
            return this;
        }

        public T value() {
            this.checkValue();
            return (T)this.value.get();
        }

        public Throwable exception() {
            this.checkException();
            if (this.value.isRight()) {
                throw new IllegalStateException("State is a value: " + String.valueOf(this.value.get()));
            }
            return (Throwable)this.value.getLeft();
        }

        public HttpServerExchange exchange() {
            return this.exchange;
        }

        public Option<HttpStatus> httpStatus() {
            return this.httpStatus;
        }

        public Option<HttpStatus> exceptionHttpStatus() {
            return this.exceptionHttpStatus;
        }

        public <U> State<U> value(U value) {
            this.checkValue();
            return new State<T>(this.exchange, Either.right(value), this.httpStatus, (Option<HttpStatus>)Option.none());
        }

        public <U> State<U> recover(U value) {
            return new State<T>(this.exchange, Either.right(value), (Option<HttpStatus>)this.exceptionHttpStatus.orElse(this.httpStatus), (Option<HttpStatus>)Option.none());
        }

        public <U> State<U> map(Actions.Action1<? super T, ? extends U> mapper) {
            if (this.isException()) {
                return this.promoteException();
            }
            try {
                return this.value(mapper.perform(this.value()));
            }
            catch (Exception e) {
                return this.exception(e);
            }
        }

        public <U> State<U> exception(Throwable exception) {
            Exceptions.rethrowIfFatal((Throwable)exception);
            if (this.isException() && exception != this.exception()) {
                exception.addSuppressed(this.exception());
            }
            return new State<T>(this.exchange, Either.left((Object)exception), this.httpStatus, (Option<HttpStatus>)Option.none());
        }

        public State<T> httpStatus(HttpStatus httpStatus) {
            return this.httpStatus((Option<HttpStatus>)Option.some((Object)httpStatus));
        }

        public State<T> httpStatus(Option<HttpStatus> httpStatus) {
            return new State<T>(this.exchange, this.value, (Option<HttpStatus>)httpStatus.orElse(this.httpStatus), this.exceptionHttpStatus);
        }

        public State<T> clearHttpStatus() {
            return new State<T>(this.exchange, this.value, (Option<HttpStatus>)Option.none(), this.exceptionHttpStatus);
        }

        public State<T> exceptionHttpStatus(HttpStatus exceptionHttpStatus) {
            return this.exceptionHttpStatus((Option<HttpStatus>)Option.some((Object)exceptionHttpStatus));
        }

        public State<T> exceptionHttpStatus(Option<HttpStatus> exceptionHttpStatus) {
            return new State<T>(this.exchange, this.value, this.httpStatus, (Option<HttpStatus>)exceptionHttpStatus.orElse(this.exceptionHttpStatus));
        }

        public State<T> clearExceptionHttpStatus() {
            return new State<T>(this.exchange, this.value, this.httpStatus, (Option<HttpStatus>)Option.none());
        }

        private void checkValue() {
            if (this.value.isLeft()) {
                IllegalStateException throwing = new IllegalStateException("State is an exception: " + String.valueOf(this.value.getLeft()));
                throwing.addSuppressed((Throwable)this.value.getLeft());
                throw throwing;
            }
        }

        private void checkException() {
            if (this.value.isRight()) {
                throw new IllegalStateException("State is a value: " + String.valueOf(this.value.get()));
            }
        }

        public String toString() {
            return "State[" + String.valueOf(this.isException() ? this.exception() : String.valueOf(this.value()) + "->" + String.valueOf(this.httpStatus()) + "/" + String.valueOf(this.exceptionHttpStatus())) + "]";
        }
    }
}

