/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import ch.raffael.meldioc.logging.Logging;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.Objects;
import org.slf4j.Logger;

public interface ExceptionLogger {
    public static final AttachmentKey<ExceptionLogger> EXCEPTION_LOGGER_KEY = AttachmentKey.create(ExceptionLogger.class);

    public void log(HttpServerExchange var1, Throwable var2);

    public static ExceptionLogger get(HttpServerExchange exchange) {
        return Objects.requireNonNullElse((ExceptionLogger)exchange.getAttachment(EXCEPTION_LOGGER_KEY), Default.instance());
    }

    public static class Default
    implements ExceptionLogger {
        private static Logger LOG = Logging.logger();
        private static final Default INSTANCE = new Default();

        protected Default() {
        }

        public static Default instance() {
            return INSTANCE;
        }

        @Override
        public void log(HttpServerExchange exchange, Throwable exception) {
            if (exception instanceof HttpStatusException) {
                HttpStatusException se = (HttpStatusException)exception;
                switch (se.status().category()) {
                    case INFORMATIONAL: 
                    case SUCCESS: 
                    case REDIRECT: {
                        LOG.debug("{} {}: Returning: {} {}", new Object[]{exchange.getRequestMethod(), exchange.getRequestURI(), se.status().code(), se});
                        break;
                    }
                    case CLIENT_ERROR: {
                        LOG.info("{} {}: Client error: {} {}", new Object[]{exchange.getRequestMethod(), exchange.getRequestURI(), se.status().code(), se});
                        break;
                    }
                    default: {
                        LOG.error("{} {}: Server error: {}", new Object[]{exchange.getRequestMethod(), exchange.getRequestURI(), se.status().code(), se});
                    }
                }
            }
        }
    }
}

