/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.http.server.undertow.util.HttpMethod;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.vavr.collection.Map;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;

public class HttpMethodHandler
implements HttpHandler {
    private final Map<HttpMethod, HttpHandler> handlers;

    private HttpMethodHandler(Map<HttpMethod, HttpHandler> handlers) {
        if (handlers.containsKey((Object)HttpMethod.GET) && !handlers.containsKey((Object)HttpMethod.HEAD)) {
            handlers = handlers.put((Object)HttpMethod.HEAD, (Object)((HttpHandler)handlers.get((Object)HttpMethod.GET).get()));
        }
        this.handlers = handlers;
    }

    public static HttpMethodHandler of(Map<HttpMethod, HttpHandler> handlers) {
        return new HttpMethodHandler(handlers);
    }

    public HttpMethodHandler add(HttpMethod method, HttpHandler handler) {
        return new HttpMethodHandler((Map<HttpMethod, HttpHandler>)this.handlers.put((Object)method.checkUserImplementable(), (Object)handler));
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (HttpMethod.isOptionsRequest(exchange)) {
            HttpMethod.optionsResponse(exchange, (Traversable<String>)this.handlers.keySet().map(Enum::toString));
        } else {
            this.handleMethod(exchange);
        }
    }

    private void handleMethod(HttpServerExchange exchange) throws Exception {
        Option action;
        HttpMethod method = (HttpMethod)((Object)HttpMethod.forName(exchange.getRequestMethod()).getOrNull());
        if (method == null) {
            new HttpStatusException(HttpStatus.NOT_IMPLEMENTED).endRequest(exchange);
        }
        if ((action = this.handlers.get((Object)method)).isDefined()) {
            ((HttpHandler)action.get()).handleRequest(exchange);
        } else {
            HttpMethod.methodNotAllowedResponse(exchange, (Traversable<String>)this.handlers.keySet().map(Enum::toString));
        }
    }
}

