/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.handler;

import ch.raffael.meldioc.library.http.server.undertow.util.HttpMethod;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public final class PathSegmentHandler
implements HttpHandler {
    private static final Pattern DECODE_SLASH_RE = Pattern.compile("%2[fF]");
    private final Option<HttpHandler> hereHandler;
    private final Map<String, HttpHandler> exactSegments;
    private final Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> captureHandler;
    private final HttpHandler defaultHandler;
    private final HttpHandler notFoundHandler;

    private PathSegmentHandler(Option<HttpHandler> hereHandler, Map<String, HttpHandler> exactSegments, Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> captureHandler, HttpHandler defaultHandler, HttpHandler notFoundHandler) {
        this.hereHandler = hereHandler;
        this.exactSegments = exactSegments;
        this.captureHandler = captureHandler;
        this.defaultHandler = defaultHandler;
        this.notFoundHandler = notFoundHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String segment = exchange.getRelativePath();
        if (segment.isEmpty() || segment.equals("/")) {
            if (!segment.isEmpty()) {
                exchange.setResolvedPath(exchange.getResolvedPath() + segment);
                exchange.setRelativePath("");
            }
            ((HttpHandler)this.hereHandler.getOrElse(() -> this.defaultHandler)).handleRequest(exchange);
        } else {
            Option exact;
            if (!exchange.getRelativePath().startsWith("/")) {
                throw new IllegalStateException("Relative path must start with '/'");
            }
            int slash = (segment = segment.substring(1)).indexOf(47);
            if (slash >= 0) {
                segment = segment.substring(0, slash);
            }
            if ((exact = this.exactSegments.get((Object)segment)).isDefined()) {
                this.updateMatch(exchange, segment);
                ((HttpHandler)exact.get()).handleRequest(exchange);
            } else {
                Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> cap = this.captureHandler;
                if (cap.isDefined()) {
                    String decodedSegment = this.decodeSegment(segment);
                    for (BiConsumer c : (Seq)((Tuple2)cap.get())._1) {
                        c.accept(exchange, decodedSegment);
                    }
                    this.updateMatch(exchange, segment);
                    ((HttpHandler)((Tuple2)cap.get())._2).handleRequest(exchange);
                } else {
                    this.notFoundHandler.handleRequest(exchange);
                }
            }
        }
    }

    private String decodeSegment(String segment) {
        return segment.indexOf(37) >= 0 ? DECODE_SLASH_RE.matcher(segment).replaceAll("/") : segment;
    }

    private void updateMatch(HttpServerExchange exchange, String segment) {
        exchange.setRelativePath(exchange.getRelativePath().substring(segment.length() + 1));
        exchange.setResolvedPath(exchange.getResolvedPath() + "/" + segment);
    }

    public static final class Builder {
        private Option<HttpHandler> hereHandler = Option.none();
        private Map<String, HttpHandler> exactSegments = HashMap.empty();
        private Option<Tuple2<Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>, HttpHandler>> capture = Option.none();
        private HttpHandler defaultHandler = NoEndpointHandler.INSTANCE;
        private HttpHandler notFoundHandler = ResponseCodeHandler.HANDLE_404;

        private Builder() {
        }

        public Builder hereHandler(HttpHandler hereHandler) {
            this.hereHandler = Option.some((Object)hereHandler);
            return this;
        }

        public Builder exactSegment(String segment, HttpHandler handler) {
            this.exactSegments = this.exactSegments.put((Object)segment, (Object)handler);
            return this;
        }

        public Builder capture(BiConsumer<? super HttpServerExchange, ? super String> capture, HttpHandler handler) {
            this.capture = Option.some((Object)Tuple.of((Object)List.of(capture), (Object)handler));
            return this;
        }

        public Builder capture(Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>> capture, HttpHandler handler) {
            this.capture = Option.some((Object)Tuple.of(capture, (Object)handler));
            return this;
        }

        public Builder defaultHandler(HttpHandler defaultHandler) {
            this.defaultHandler = defaultHandler;
            return this;
        }

        public Builder notFoundHandler(HttpHandler notFoundHandler) {
            this.notFoundHandler = notFoundHandler;
            return this;
        }

        public PathSegmentHandler build() {
            return new PathSegmentHandler(this.hereHandler, this.exactSegments, this.capture, this.defaultHandler, this.notFoundHandler);
        }
    }

    private static final class NoEndpointHandler
    implements HttpHandler {
        private static final NoEndpointHandler INSTANCE = new NoEndpointHandler();

        private NoEndpointHandler() {
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            if (HttpMethod.isOptionsRequest(exchange)) {
                HttpMethod.optionsResponse(exchange, (Traversable<String>)List.of((Object[])new String[0]));
            } else {
                HttpMethod.methodNotAllowedResponse(exchange, (Traversable<String>)List.of((Object[])new String[0]));
            }
        }
    }
}

