/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.routing.Actions;
import ch.raffael.meldioc.library.http.server.undertow.routing.Converter;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Capture<T> {
    private final String name;

    Capture(String name) {
        this.name = name;
    }

    public static <T> Capture<T> of(String name, Supplier<? extends T> fun) {
        return Capture.ofExtractor(name, __ -> fun.get());
    }

    public static <T> Capture<T> of(String name, Function<? super HttpServerExchange, ? extends T> fun) {
        return Capture.ofExtractor(name, t -> Objects.requireNonNull(fun.apply(t), "fun.apply(t)"));
    }

    public static <T> Capture<T> ofExtractor(String name, Extractor<? extends T> extractor) {
        return new OfExtractor<T>(name, extractor);
    }

    private static <T> T invokeExtractor(HttpServerExchange exchange, Extractor<? extends T> extractor) throws HttpStatusException {
        try {
            return extractor.get(exchange);
        }
        catch (HttpStatusException | Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public String name() {
        return this.name;
    }

    abstract T get(HttpServerExchange var1) throws HttpStatusException;

    public <R> Capture<R> map(Actions.Action1<? super T, ? extends R> action) {
        return this.map("f(" + this.name() + ")", action);
    }

    public <R> Capture<R> map(String name, Actions.Action1<? super T, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x)));
    }

    public <R, T1> Capture<R> map(Capture<? extends T1> v1, Actions.Action2<? super T, ? super T1, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + ")", v1, action);
    }

    public <R, T1> Capture<R> map(String name, Capture<? extends T1> v1, Actions.Action2<? super T, ? super T1, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x)));
    }

    public <R, T1, T2> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Actions.Action3<? super T, ? super T1, ? super T2, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + ")", v1, v2, action);
    }

    public <R, T1, T2> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Actions.Action3<? super T, ? super T1, ? super T2, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x)));
    }

    public <R, T1, T2, T3> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Actions.Action4<? super T, ? super T1, ? super T2, ? super T3, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + "," + v3.name() + ")", v1, v2, v3, action);
    }

    public <R, T1, T2, T3> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Actions.Action4<? super T, ? super T1, ? super T2, ? super T3, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x), (Object)v3.get(x)));
    }

    public <R, T1, T2, T3, T4> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Actions.Action5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + "," + v3.name() + "," + v4.name() + ")", v1, v2, v3, v4, action);
    }

    public <R, T1, T2, T3, T4> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Actions.Action5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x), (Object)v3.get(x), (Object)v4.get(x)));
    }

    public <R, T1, T2, T3, T4, T5> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Actions.Action6<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + "," + v3.name() + "," + v4.name() + "," + v5.name() + ")", v1, v2, v3, v4, v5, action);
    }

    public <R, T1, T2, T3, T4, T5> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Actions.Action6<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x), (Object)v3.get(x), (Object)v4.get(x), (Object)v5.get(x)));
    }

    public <R, T1, T2, T3, T4, T5, T6> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Actions.Action7<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + "," + v3.name() + "," + v4.name() + "," + v5.name() + "," + v6.name() + ")", v1, v2, v3, v4, v5, v6, action);
    }

    public <R, T1, T2, T3, T4, T5, T6> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Actions.Action7<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x), (Object)v3.get(x), (Object)v4.get(x), (Object)v5.get(x), (Object)v6.get(x)));
    }

    public <R, T1, T2, T3, T4, T5, T6, T7> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Actions.Action8<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + "," + v3.name() + "," + v4.name() + "," + v5.name() + "," + v6.name() + "," + v7.name() + ")", v1, v2, v3, v4, v5, v6, v7, action);
    }

    public <R, T1, T2, T3, T4, T5, T6, T7> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Actions.Action8<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x), (Object)v3.get(x), (Object)v4.get(x), (Object)v5.get(x), (Object)v6.get(x), (Object)v7.get(x)));
    }

    public <R, T1, T2, T3, T4, T5, T6, T7, T8> Capture<R> map(Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Capture<? extends T8> v8, Actions.Action9<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> action) {
        return this.map("f(" + this.name() + "," + v1.name() + "," + v2.name() + "," + v3.name() + "," + v4.name() + "," + v5.name() + "," + v6.name() + "," + v7.name() + "," + v8.name() + ")", v1, v2, v3, v4, v5, v6, v7, v8, action);
    }

    public <R, T1, T2, T3, T4, T5, T6, T7, T8> Capture<R> map(String name, Capture<? extends T1> v1, Capture<? extends T2> v2, Capture<? extends T3> v3, Capture<? extends T4> v4, Capture<? extends T5> v5, Capture<? extends T6> v6, Capture<? extends T7> v7, Capture<? extends T8> v8, Actions.Action9<? super T, ? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> action) {
        return new Mapped<Object>(name, x -> action.perform((T)this.get(x), (Object)v1.get(x), (Object)v2.get(x), (Object)v3.get(x), (Object)v4.get(x), (Object)v5.get(x), (Object)v6.get(x), (Object)v7.get(x), (Object)v8.get(x)));
    }

    @FunctionalInterface
    static interface Extractor<T> {
        public T get(HttpServerExchange var1) throws Exception;
    }

    static final class OfExtractor<T>
    extends Cached<T> {
        private final Extractor<? extends T> extractor;

        OfExtractor(String name, Extractor<? extends T> extractor) {
            super(name);
            this.extractor = extractor;
        }

        @Override
        T extract(HttpServerExchange exchange) throws HttpStatusException {
            return Capture.invokeExtractor(exchange, this.extractor);
        }
    }

    static final class Mapped<T>
    extends Cached<T> {
        private final Extractor<? extends T> extractor;

        Mapped(String name, Extractor<? extends T> extractor) {
            super(name);
            this.extractor = extractor;
        }

        @Override
        T extract(HttpServerExchange exchange) throws HttpStatusException {
            return Capture.invokeExtractor(exchange, this.extractor);
        }
    }

    static abstract class Cached<T>
    extends Capture<T> {
        private final AttachmentKey<T> key = AttachmentKey.create(Object.class);

        Cached(String name) {
            super(name);
        }

        @Override
        T get(HttpServerExchange exchange) throws HttpStatusException {
            Object value = exchange.getAttachment(this.key);
            if (value == null) {
                value = Objects.requireNonNull(this.extract(exchange), "extract(exchange)");
                exchange.putAttachment(this.key, value);
            }
            return (T)value;
        }

        abstract T extract(HttpServerExchange var1) throws HttpStatusException;
    }

    public static final class Attachment<T>
    extends Capture<T> {
        private final AttachmentKey<String> key = AttachmentKey.create(String.class);
        private final Converter<? extends T> converter;

        Attachment(String name, Converter<? extends T> converter) {
            super(name);
            this.converter = converter;
        }

        @Override
        T get(HttpServerExchange exchange) throws HttpStatusException {
            return (T)Objects.requireNonNullElseGet(this.converter.convert(this.name(), (String)exchange.getAttachment(this.key)), () -> {
                throw new IllegalStateException("No captured value for '" + this.name() + "'");
            });
        }

        void capture(HttpServerExchange exchange, String value) {
            exchange.putAttachment(this.key, (Object)value);
        }
    }
}

