/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.http.server.undertow.codec.BinaryCodec;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import io.vavr.collection.Traversable;
import java.util.function.Function;

public final class Codecs {
    private final CodecSupplier<String> plainTextCodec = new CodecSupplier<String>(){

        @Override
        public HttpDecoder<? extends String> decoder(Frame frame) {
            return frame.dec.plainText();
        }

        @Override
        public HttpEncoder<? super String> encoder(Frame frame) {
            return frame.enc.plainText();
        }
    };
    private final EncoderSupplier<String> htmlCodec = f -> f.enc.html();

    Codecs() {
    }

    public CodecSupplier<String> plainText() {
        return this.plainTextCodec;
    }

    public EncoderSupplier<String> html() {
        return this.htmlCodec;
    }

    public CodecSupplier<byte[]> byteArray(String ... types) {
        return CodecSupplier.combined(__ -> new BinaryCodec.ByteArray(types));
    }

    public CodecSupplier<byte[]> byteArray(ContentType ... types) {
        return CodecSupplier.combined(__ -> new BinaryCodec.ByteArray(types));
    }

    public CodecSupplier<byte[]> byteArray(Traversable<? extends ContentType> types) {
        return CodecSupplier.combined(__ -> new BinaryCodec.ByteArray(types));
    }

    public CodecSupplier<byte[]> byteBuffer(String ... types) {
        return CodecSupplier.combined(__ -> new BinaryCodec.ByteArray(types));
    }

    public CodecSupplier<byte[]> byteBuffer(ContentType ... types) {
        return CodecSupplier.combined(__ -> new BinaryCodec.ByteArray(types));
    }

    public CodecSupplier<byte[]> byteBuffer(Traversable<? extends ContentType> types) {
        return CodecSupplier.combined(__ -> new BinaryCodec.ByteArray(types));
    }

    static interface CodecSupplier<T>
    extends DecoderSupplier<T>,
    EncoderSupplier<T> {
        public static <T, C extends HttpEncoder<T> & HttpDecoder<T>> CodecSupplier<T> combined(final Function<? super Frame, ? extends C> fun) {
            return new CodecSupplier<T>(){

                @Override
                public HttpDecoder<? extends T> decoder(Frame frame) {
                    return (HttpDecoder)fun.apply(frame);
                }

                @Override
                public HttpEncoder<? super T> encoder(Frame frame) {
                    return (HttpEncoder)fun.apply(frame);
                }
            };
        }
    }

    @FunctionalInterface
    static interface EncoderSupplier<T> {
        public HttpEncoder<? super T> encoder(Frame var1);
    }

    @FunctionalInterface
    static interface DecoderSupplier<T> {
        public HttpDecoder<? extends T> decoder(Frame var1);
    }
}

