/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinition;
import io.vavr.control.Option;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

final class DslTrace {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final String INTERNAL_PREFIX = DslTrace.class.getPackageName() + ".";
    private static final Predicate<StackWalker.StackFrame> IS_INTERNAL = f -> f.getDeclaringClass().getName().startsWith(INTERNAL_PREFIX);
    private static final Predicate<StackWalker.StackFrame> IS_NOT_INTERNAL = IS_INTERNAL.negate();
    private final Option<DslTrace> parent;
    private final Kind kind;
    private final String path;
    private final Option<StackWalker.StackFrame> location;

    DslTrace(Option<DslTrace> parent, Kind kind) {
        this(parent, kind, "");
    }

    DslTrace(DslTrace parent, Kind kind) {
        this((Option<DslTrace>)Option.some((Object)parent), kind, "");
    }

    DslTrace(DslTrace parent, Kind kind, String path) {
        this((Option<DslTrace>)Option.some((Object)parent), kind, path);
    }

    DslTrace(Option<DslTrace> parent, Kind kind, String path) {
        this(parent, kind, path, DslTrace.locationFromCurrentStack());
    }

    DslTrace(DslTrace parent, Kind kind, String path, Option<StackWalker.StackFrame> location) {
        this((Option<DslTrace>)Option.some((Object)parent), kind, path, location);
    }

    DslTrace(Option<DslTrace> parent, Kind kind, String path, Option<StackWalker.StackFrame> location) {
        this.parent = parent;
        this.kind = kind;
        this.path = path;
        this.location = location;
    }

    private static Option<StackWalker.StackFrame> locationFromCurrentStack() {
        return Option.ofOptional((Optional)STACK_WALKER.walk(s -> s.dropWhile(IS_NOT_INTERNAL).dropWhile(IS_INTERNAL).filter(f -> RoutingDefinition.class.isAssignableFrom(f.getDeclaringClass())).findFirst()));
    }

    Option<DslTrace> parent() {
        return this.parent;
    }

    DslTrace root() {
        return (DslTrace)this.parent.map(DslTrace::root).getOrElse((Object)this);
    }

    DslTrace reroot(DslTrace newRoot) {
        if (this.parent.isEmpty()) {
            return new DslTrace(newRoot, this.kind, this.path, this.location);
        }
        return new DslTrace(((DslTrace)this.parent.get()).reroot(newRoot), this.kind, this.path, this.location);
    }

    Kind kind() {
        return this.kind;
    }

    String path() {
        return this.path;
    }

    Option<StackWalker.StackFrame> location() {
        return this.location;
    }

    String description() {
        StringBuilder buf = new StringBuilder();
        this.description(true, buf);
        return buf.toString();
    }

    private StringBuilder description(boolean first, StringBuilder buf) {
        if (first) {
            buf.append(this.kind.prefix());
        }
        if (this.parent.isDefined()) {
            buf = ((DslTrace)this.parent.get()).description(false, buf);
        }
        if (!this.path.isEmpty()) {
            buf.append('/').append(this.path);
        }
        return buf;
    }

    String stackTrace() {
        StringBuilder buf = new StringBuilder();
        buf = this.description(true, buf);
        DslTrace current = this;
        DslTrace previous = null;
        while (current != null) {
            if (this.includeInStackTrace(current, previous)) {
                buf.append(System.lineSeparator()).append("  - ");
                String tag = current.kind.tag();
                if (!tag.isEmpty()) {
                    buf.append('<').append(tag).append("> ");
                }
                buf.append(current.location().get());
                previous = current;
            }
            current = (DslTrace)current.parent().getOrNull();
        }
        return buf.toString();
    }

    private boolean includeInStackTrace(DslTrace current, @Nullable DslTrace previous) {
        if (previous == null) {
            return true;
        }
        if (!current.location().isDefined()) {
            return false;
        }
        if (current.kind() == Kind.MERGE) {
            return true;
        }
        if (previous.location().isEmpty()) {
            return true;
        }
        return !this.locationEquals(current, previous, StackWalker.StackFrame::getDeclaringClass) || !this.locationEquals(current, previous, StackWalker.StackFrame::getMethodName) || !this.locationEquals(current, previous, StackWalker.StackFrame::getDescriptor);
    }

    private boolean locationEquals(@Nullable DslTrace a, @Nullable DslTrace b, Function<? super StackWalker.StackFrame, ?> value) {
        if (a == null || b == null || a.location.isEmpty() || b.location.isEmpty()) {
            return false;
        }
        return Objects.equals(value.apply((StackWalker.StackFrame)a.location.get()), value.apply((StackWalker.StackFrame)b.location.get()));
    }

    public String toString() {
        return "DslTrace[" + String.valueOf((Object)this.kind) + "," + this.path + "," + String.valueOf(this.location) + "]";
    }

    static enum Kind {
        FRAME,
        MERGE,
        ENDPOINT;


        String prefix() {
            switch (this) {
                case ENDPOINT: {
                    return "";
                }
            }
            return this.name() + ":";
        }

        String tag() {
            switch (this) {
                case FRAME: {
                    return "";
                }
            }
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

