/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.codec.EmptyBody;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.handler.EndpointHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.Actions;
import ch.raffael.meldioc.library.http.server.undertow.routing.Capture;
import ch.raffael.meldioc.library.http.server.undertow.routing.Codecs;
import ch.raffael.meldioc.library.http.server.undertow.routing.DslTrace;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpMethod;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class EndpointBuilder<B, T> {
    final DslTrace trace;
    final BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback;
    final Set<HttpMethod> methods;
    final BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init;

    EndpointBuilder(DslTrace trace, BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
        this.trace = trace;
        this.updateCallback = updateCallback;
        this.methods = methods;
        this.init = init;
    }

    EndpointBuilder(EndpointBuilder<?, ?> prev, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
        this(prev, prev.trace, prev.methods, init);
    }

    EndpointBuilder(EndpointBuilder<?, ?> prev, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
        this(prev, prev.trace, methods, init);
    }

    EndpointBuilder(EndpointBuilder<?, ?> prev, DslTrace trace, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
        this.updateCallback = prev.updateCallback;
        this.trace = trace;
        this.methods = methods;
        this.init = init;
        this.updateCallback.accept(prev, this);
    }

    EndpointHandler<B, T> handler(Frame frame) {
        return this.init.apply(frame, EndpointHandler.initial());
    }

    <BB, RR> BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<BB, RR>> addInit(BiFunction<Frame, EndpointHandler<B, T>, EndpointHandler<BB, RR>> init) {
        return (f, h) -> (EndpointHandler)init.apply((Frame)f, this.init.apply((Frame)f, (EndpointHandler<EmptyBody, EmptyBody>)h));
    }

    <BB, RR> BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<BB, RR>> addInit(Function<EndpointHandler<B, T>, EndpointHandler<BB, RR>> init) {
        return (f, h) -> (EndpointHandler)init.apply(this.init.apply((Frame)f, (EndpointHandler<EmptyBody, EmptyBody>)h));
    }

    EndpointBuilder<B, T> fork(DslTrace trace, BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback) {
        return new EndpointBuilder<B, T>(trace, updateCallback, this.methods, this.init);
    }

    public static class Response<B, T>
    extends EndpointBuilder<B, T> {
        Response(DslTrace trace, BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
            super(trace, updateCallback, methods, init);
        }

        Response(EndpointBuilder<?, ?> prev, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
            super(prev, init);
        }

        Response(EndpointBuilder<?, ?> prev, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
            super(prev, methods, init);
        }

        public EndpointBuilder<B, T> respond() {
            return this.respond(HttpStatus.OK);
        }

        public EndpointBuilder<B, T> respond(HttpStatus status) {
            return this.respond(status, Object.class);
        }

        public EndpointBuilder<B, T> respond(Class<? super T> type) {
            return this.respond(HttpStatus.OK, type);
        }

        public EndpointBuilder<B, T> respond(HttpStatus status, Class<? super T> type) {
            return new EndpointBuilder(this, this.addInit((Frame f, EndpointHandler<B, T> h) -> h.defaultStatus(status).encoder(f.enc.object(type))));
        }

        public EndpointBuilder<B, T> respond(Codecs.EncoderSupplier<? super T> encoder) {
            return this.respond(HttpStatus.OK, encoder);
        }

        public EndpointBuilder<B, T> respond(HttpStatus status, Codecs.EncoderSupplier<? super T> encoder) {
            return new EndpointBuilder(this, this.addInit((Frame f, EndpointHandler<B, T> h) -> h.defaultStatus(status).encoder(encoder.encoder((Frame)f))));
        }

        public EndpointBuilder<B, T> respond(HttpEncoder<? super T> encoder) {
            return this.respond(HttpStatus.OK, encoder);
        }

        public EndpointBuilder<B, T> respond(HttpStatus status, HttpEncoder<? super T> encoder) {
            return new EndpointBuilder(this, this.addInit((EndpointHandler<B, T> h) -> h.defaultStatus(status).encoder(encoder)));
        }

        public EndpointBuilder<B, EmptyBody> respondEmpty() {
            return this.respondEmpty(HttpStatus.OK);
        }

        public EndpointBuilder<B, EmptyBody> respondEmpty(HttpStatus status) {
            return new EndpointBuilder(this, this.addInit((EndpointHandler<B, T> h) -> h.processor(s -> s.map(__ -> EmptyBody.instance())).defaultStatus(status).encoder(EmptyBody.encoder())));
        }
    }

    public static class Processing<B, T>
    extends Response<B, T> {
        Processing(DslTrace trace, BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
            super(trace, updateCallback, methods, init);
        }

        Processing(EndpointBuilder<?, ?> prev, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
            super(prev, init);
        }

        Processing(EndpointBuilder<?, ?> prev, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<B, T>> init) {
            super(prev, methods, init);
        }

        private <U> Processing<B, U> map0(Actions.Action1<? super EndpointHandler.State<? extends T>, ? extends U> invoke) {
            return new Processing<B, T>(this, this.addInit((EndpointHandler<B, T> h) -> h.processor(s -> {
                if (s.isException()) {
                    return s.promoteException();
                }
                return s.value(invoke.perform(s));
            })));
        }

        private Processing<B, T> status0(Actions.Action1<? super EndpointHandler.State<? extends T>, ? extends Option<? extends HttpStatus>> invoke) {
            return new Processing<B, T>(this, this.addInit((EndpointHandler<B, T> h) -> h.processor(s -> {
                if (s.isException()) {
                    return s.promoteException();
                }
                return s.httpStatus((Option<HttpStatus>)Option.narrow((Option)((Option)invoke.perform(s))));
            })));
        }

        private <X extends Throwable> Processing<B, T> recover0(Class<X> excType, Actions.Action2<? super X, ? super EndpointHandler.State<? extends T>, ? extends T> invoke) {
            return new Processing<B, T>(this, this.addInit((EndpointHandler<B, T> h) -> h.processor(s -> {
                if (!s.isException() || !excType.isInstance(s.exception())) {
                    return s;
                }
                return s.recover(invoke.perform((Object)excType.cast(s.exception()), (Object)s));
            })));
        }

        private <X extends Throwable> Processing<B, T> exceptionStatus0(Class<X> excType, Actions.Action2<? super X, ? super EndpointHandler.State<? extends T>, ? extends Option<? extends HttpStatus>> invoke) {
            return new Processing<B, T>(this, this.addInit((EndpointHandler<B, T> h) -> h.processor(s -> {
                if (!s.isException() || !excType.isInstance(s.exception())) {
                    return s;
                }
                return s.exceptionHttpStatus((Option<HttpStatus>)Option.narrow((Option)((Option)invoke.perform((Object)excType.cast(s.exception()), (Object)s))));
            })));
        }

        public <U> Processing<B, U> map(Actions.Action1<? super T, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value()));
        }

        public <U> Processing<B, U> map(Actions.Action0<? extends U> action) {
            return this.map0(s -> action.perform());
        }

        public Processing<B, T> tap(Actions.Action1Void<? super T> action) {
            return this.map0(s -> {
                action.perform((Object)s.value());
                return s.value();
            });
        }

        public Processing<B, T> tap(Actions.Action0Void action) {
            return this.map0(s -> {
                action.perform();
                return s.value();
            });
        }

        public Processing<B, EmptyBody> consume(Actions.Action1Void<? super T> action) {
            return this.map0(s -> {
                action.perform((Object)s.value());
                return EmptyBody.instance();
            });
        }

        public Processing<B, EmptyBody> consume(Actions.Action0Void action) {
            return this.map0(s -> {
                action.perform();
                return EmptyBody.instance();
            });
        }

        public Processing<B, T> status(HttpStatus status) {
            return this.status0(__ -> Option.some((Object)status));
        }

        public Processing<B, T> status(Actions.Action1<? super T, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value()));
        }

        public Processing<B, T> status(Actions.Action0<? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform());
        }

        public <X extends Throwable> Processing<B, T> recover(Class<X> excType, Actions.Action1<? super X, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e));
        }

        public <X extends Throwable> Processing<B, T> recover(Class<X> excType, Actions.Action0<? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform());
        }

        public <X extends Throwable> Processing<B, T> exceptionStatus(Class<X> excType, HttpStatus status) {
            return this.exceptionStatus0(excType, (e, s) -> Option.some((Object)status));
        }

        public <X extends Throwable> Processing<B, T> exceptionStatus(Class<X> excType, Actions.Action1<? super X, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e));
        }

        public <X extends Throwable> Processing<B, T> exceptionStatus(Class<X> excType, Actions.Action0<? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform());
        }

        public <V> Pipe<V> pipe(Actions.Action1<? super T, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value()));
        }

        public <V> Pipe<V> pipe(Actions.Action0<? extends V> action) {
            return new Pipe<Object>(s -> action.perform());
        }

        public <U, P1> Processing<B, U> map(Capture<? extends P1> p1, Actions.Action2<? super T, ? super P1, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange())));
        }

        public <U, P1> Processing<B, U> map(Capture<? extends P1> p1, Actions.Action1<? super P1, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange())));
        }

        public <P1> Processing<B, T> tap(Capture<? extends P1> p1, Actions.Action2Void<? super T, ? super P1> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()));
                return s.value();
            });
        }

        public <P1> Processing<B, T> tap(Capture<? extends P1> p1, Actions.Action1Void<? super P1> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()));
                return s.value();
            });
        }

        public <P1> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Actions.Action2Void<? super T, ? super P1> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Actions.Action1Void<? super P1> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1> Processing<B, T> status(Capture<? extends P1> p1, Actions.Action2<? super T, ? super P1, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange())));
        }

        public <P1> Processing<B, T> status(Capture<? extends P1> p1, Actions.Action1<? super P1, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange())));
        }

        public <X extends Throwable, P1> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Actions.Action2<? super X, ? super P1, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange())));
        }

        public <X extends Throwable, P1> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Actions.Action1<? super P1, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange())));
        }

        public <X extends Throwable, P1> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Actions.Action2<? super X, ? super P1, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange())));
        }

        public <X extends Throwable, P1> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Actions.Action1<? super P1, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange())));
        }

        public <V, P1> Pipe<V> pipe(Capture<? extends P1> p1, Actions.Action2<? super T, ? super P1, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange())));
        }

        public <V, P1> Pipe<V> pipe(Capture<? extends P1> p1, Actions.Action1<? super P1, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange())));
        }

        public <U, P1, P2> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super T, ? super P1, ? super P2, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <U, P1, P2> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2<? super P1, ? super P2, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <P1, P2> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3Void<? super T, ? super P1, ? super P2> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2Void<? super P1, ? super P2> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3Void<? super T, ? super P1, ? super P2> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2Void<? super P1, ? super P2> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super T, ? super P1, ? super P2, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <P1, P2> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2<? super P1, ? super P2, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super X, ? super P1, ? super P2, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2<? super P1, ? super P2, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super X, ? super P1, ? super P2, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2<? super P1, ? super P2, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <V, P1, P2> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super T, ? super P1, ? super P2, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <V, P1, P2> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action2<? super P1, ? super P2, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
        }

        public <U, P1, P2, P3> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super T, ? super P1, ? super P2, ? super P3, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <U, P1, P2, P3> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3<? super P1, ? super P2, ? super P3, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <P1, P2, P3> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4Void<? super T, ? super P1, ? super P2, ? super P3> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3Void<? super P1, ? super P2, ? super P3> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4Void<? super T, ? super P1, ? super P2, ? super P3> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3Void<? super P1, ? super P2, ? super P3> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super T, ? super P1, ? super P2, ? super P3, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <P1, P2, P3> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3<? super P1, ? super P2, ? super P3, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super X, ? super P1, ? super P2, ? super P3, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3<? super P1, ? super P2, ? super P3, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super X, ? super P1, ? super P2, ? super P3, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3<? super P1, ? super P2, ? super P3, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <V, P1, P2, P3> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super T, ? super P1, ? super P2, ? super P3, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <V, P1, P2, P3> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action3<? super P1, ? super P2, ? super P3, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <P1, P2, P3, P4> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <P1, P2, P3, P4> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6, P7> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6, P7> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6, P7> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6, P7> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6, P7> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6, P7> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends U> action) {
            return this.map0(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9Void<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
            return this.map0(s -> {
                action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super X, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)e, (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6, P7, P8> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6, P7, P8> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
        }

        public <U, P1, P2, P3, P4, P5, P6, P7, P8, P9> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends U> action) {
            return this.map0(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange())));
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8, P9> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange()));
                return s.value();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8, P9> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
            return this.map0(s -> {
                action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange()));
                return EmptyBody.instance();
            });
        }

        public <P1, P2, P3, P4, P5, P6, P7, P8, P9> Processing<B, T> status(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends Option<? extends HttpStatus>> action) {
            return this.status0(s -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7, P8, P9> Processing<B, T> recover(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends T> action) {
            return this.recover0(excType, (e, s) -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange())));
        }

        public <X extends Throwable, P1, P2, P3, P4, P5, P6, P7, P8, P9> Processing<B, T> exceptionStatus(Class<X> excType, Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends Option<? extends HttpStatus>> action) {
            return this.exceptionStatus0(excType, (e, s) -> (Option)action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange())));
        }

        public <V, P1, P2, P3, P4, P5, P6, P7, P8, P9> Pipe<V> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Capture<? extends P9> p9, Actions.Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends V> action) {
            return new Pipe<Object>(s -> action.perform((Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()), (Object)p9.get(s.exchange())));
        }

        public final class Pipe<V> {
            private final Actions.Action1<EndpointHandler.State<? extends T>, ? extends V> pipeFun;

            Pipe(Actions.Action1<EndpointHandler.State<? extends T>, ? extends V> pipeFun) {
                this.pipeFun = pipeFun;
            }

            public <U> Processing<B, U> map(Actions.Action2<? super V, ? super T, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value()));
            }

            public <U> Processing<B, U> map(Actions.Action1<? super V, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s)));
            }

            public Processing<B, T> tap(Actions.Action2Void<? super V, ? super T> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value());
                    return s.value();
                });
            }

            public Processing<B, T> tap(Actions.Action1Void<? super V> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s));
                    return s.value();
                });
            }

            public Processing<B, EmptyBody> consume(Actions.Action2Void<? super V, ? super T> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value());
                    return EmptyBody.instance();
                });
            }

            public Processing<B, EmptyBody> consume(Actions.Action1Void<? super V> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s));
                    return EmptyBody.instance();
                });
            }

            public <U> Pipe<U> pipe(Actions.Action2<? super V, ? super T, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value()));
            }

            public <U> Pipe<U> pipe(Actions.Action1<? super V, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s)));
            }

            public <U, P1> Processing<B, U> map(Capture<? extends P1> p1, Actions.Action3<? super V, ? super T, ? super P1, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange())));
            }

            public <U, P1> Processing<B, U> map(Capture<? extends P1> p1, Actions.Action2<? super V, ? super P1, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange())));
            }

            public <P1> Processing<B, T> tap(Capture<? extends P1> p1, Actions.Action3Void<? super V, ? super T, ? super P1> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1> Processing<B, T> tap(Capture<? extends P1> p1, Actions.Action2Void<? super V, ? super P1> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Actions.Action3Void<? super V, ? super T, ? super P1> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Actions.Action2Void<? super V, ? super P1> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1> Pipe<U> pipe(Capture<? extends P1> p1, Actions.Action3<? super V, ? super T, ? super P1, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange())));
            }

            public <U, P1> Pipe<U> pipe(Capture<? extends P1> p1, Actions.Action2<? super V, ? super P1, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange())));
            }

            public <U, P1, P2> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action4<? super V, ? super T, ? super P1, ? super P2, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
            }

            public <U, P1, P2> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super V, ? super P1, ? super P2, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
            }

            public <P1, P2> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action4Void<? super V, ? super T, ? super P1, ? super P2> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3Void<? super V, ? super P1, ? super P2> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action4Void<? super V, ? super T, ? super P1, ? super P2> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1, P2> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3Void<? super V, ? super P1, ? super P2> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action4<? super V, ? super T, ? super P1, ? super P2, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
            }

            public <U, P1, P2> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Actions.Action3<? super V, ? super P1, ? super P2, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange())));
            }

            public <U, P1, P2, P3> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action5<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
            }

            public <U, P1, P2, P3> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super V, ? super P1, ? super P2, ? super P3, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
            }

            public <P1, P2, P3> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action5Void<? super V, ? super T, ? super P1, ? super P2, ? super P3> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4Void<? super V, ? super P1, ? super P2, ? super P3> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action5Void<? super V, ? super T, ? super P1, ? super P2, ? super P3> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1, P2, P3> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4Void<? super V, ? super P1, ? super P2, ? super P3> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2, P3> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action5<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
            }

            public <U, P1, P2, P3> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Actions.Action4<? super V, ? super P1, ? super P2, ? super P3, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action6<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
            }

            public <P1, P2, P3, P4> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action6Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action6Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1, P2, P3, P4> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2, P3, P4> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action6<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Actions.Action5<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action7<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
            }

            public <P1, P2, P3, P4, P5> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action7Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action7Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1, P2, P3, P4, P5> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2, P3, P4, P5> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action7<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Actions.Action6<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action8<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
            }

            public <P1, P2, P3, P4, P5, P6> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action8Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5, P6> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5, P6> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action8Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1, P2, P3, P4, P5, P6> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2, P3, P4, P5, P6> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action8<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Actions.Action7<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6, P7> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action9<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6, P7> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
            }

            public <P1, P2, P3, P4, P5, P6, P7> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action9Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5, P6, P7> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5, P6, P7> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action9Void<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <P1, P2, P3, P4, P5, P6, P7> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2, P3, P4, P5, P6, P7> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action9<? super V, ? super T, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)s.value(), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6, P7> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Actions.Action8<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange())));
            }

            public <U, P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, U> map(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends U> action) {
                return Processing.this.map0(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
            }

            public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, T> tap(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()));
                    return s.value();
                });
            }

            public <P1, P2, P3, P4, P5, P6, P7, P8> Processing<B, EmptyBody> consume(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9Void<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
                return Processing.this.map0(s -> {
                    action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange()));
                    return EmptyBody.instance();
                });
            }

            public <U, P1, P2, P3, P4, P5, P6, P7, P8> Pipe<U> pipe(Capture<? extends P1> p1, Capture<? extends P2> p2, Capture<? extends P3> p3, Capture<? extends P4> p4, Capture<? extends P5> p5, Capture<? extends P6> p6, Capture<? extends P7> p7, Capture<? extends P8> p8, Actions.Action9<? super V, ? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends U> action) {
                return new Pipe<Object>(s -> action.perform((V)this.pipeFun.perform((EndpointHandler.State)s), (Object)p1.get(s.exchange()), (Object)p2.get(s.exchange()), (Object)p3.get(s.exchange()), (Object)p4.get(s.exchange()), (Object)p5.get(s.exchange()), (Object)p6.get(s.exchange()), (Object)p7.get(s.exchange()), (Object)p8.get(s.exchange())));
            }
        }
    }

    public static class Decoding
    extends Processing<EmptyBody, EmptyBody> {
        Decoding(DslTrace trace, BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback, Set<HttpMethod> methods) {
            super(trace, updateCallback, methods, (Frame f, EndpointHandler<EmptyBody, EmptyBody> p) -> p);
        }

        Decoding(EndpointBuilder<?, ?> prev, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<EmptyBody, EmptyBody>> init) {
            super(prev, init);
        }

        Decoding(EndpointBuilder<?, ?> prev, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<EmptyBody, EmptyBody>> init) {
            super(prev, methods, init);
        }

        public <T> Processing<T, T> accept(Codecs.DecoderSupplier<? extends T> decoder) {
            return new Processing(this, this.addInit((Frame f, EndpointHandler<B, T> h) -> h.decoder(decoder.decoder((Frame)f))));
        }

        public <T> Processing<T, T> accept(HttpDecoder<? extends T> decoder) {
            return new Processing(this, this.addInit((EndpointHandler<B, T> h) -> h.decoder(decoder)));
        }

        public <T> Processing<T, T> accept(Class<T> type) {
            return new Processing(this, this.addInit((Frame f, EndpointHandler<B, T> h) -> h.decoder(f.dec.object(type))));
        }
    }

    public static class Method
    extends Decoding {
        Method(DslTrace trace, BiConsumer<EndpointBuilder<?, ?>, EndpointBuilder<?, ?>> updateCallback, Set<HttpMethod> methods) {
            super(trace, updateCallback, methods);
        }

        Method(EndpointBuilder<?, ?> prev, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<EmptyBody, EmptyBody>> init) {
            super(prev, init);
        }

        Method(EndpointBuilder<?, ?> prev, Set<HttpMethod> methods, BiFunction<Frame, EndpointHandler<EmptyBody, EmptyBody>, EndpointHandler<EmptyBody, EmptyBody>> init) {
            super(prev, methods, init);
        }

        public Method method(HttpMethod ... methods) {
            return new Method((EndpointBuilder<?, ?>)this, (Set<HttpMethod>)this.methods.addAll(Arrays.asList(methods)), this.init);
        }

        public Method get() {
            return this.method(HttpMethod.GET);
        }

        public Method head() {
            return this.method(HttpMethod.HEAD);
        }

        public Method post() {
            return this.method(HttpMethod.POST);
        }

        public Method put() {
            return this.method(HttpMethod.PUT);
        }

        public Method patch() {
            return this.method(HttpMethod.PATCH);
        }

        public Method delete() {
            return this.method(HttpMethod.DELETE);
        }
    }
}

