/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.codec.HttpDecoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpEncoder;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpObjectCodecFactory;
import ch.raffael.meldioc.library.http.server.undertow.codec.TextCodec;
import ch.raffael.meldioc.library.http.server.undertow.handler.AccessCheckHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.HttpMethodHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.PathSegmentHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.Blocks;
import ch.raffael.meldioc.library.http.server.undertow.routing.Capture;
import ch.raffael.meldioc.library.http.server.undertow.routing.DslTrace;
import ch.raffael.meldioc.library.http.server.undertow.routing.EndpointBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.Paths;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinition;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingDefinitionException;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpMethod;
import ch.raffael.meldioc.logging.Logging;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.vavr.Lazy;
import io.vavr.Tuple2;
import io.vavr.collection.HashMap;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.slf4j.Logger;

final class Frame {
    private static final Logger LOG = Logging.logger(RoutingDefinition.class);
    private final RoutingDefinition routingDefinition;
    final Option<Frame> parent;
    DslTrace trace;
    private Map<String, Frame> pathSegments = HashMap.empty();
    private Seq<Capture.Attachment<?>> pathCaptures = List.empty();
    private final Lazy<Frame> pathCaptureFrame;
    private Map<HttpMethod, EndpointBuilder<?, ?>> endpoints = LinkedHashMap.empty();
    Option<AccessCheckHandler.AccessRestriction> restriction = Option.none();
    Option<HttpObjectCodecFactory> objectCodecFactory = Option.none();
    private Seq<Function<? super HttpHandler, ? extends HttpHandler>> handlers = List.empty();
    final StandardEncoders enc = new StandardEncoders();
    final StandardDecoders dec = new StandardDecoders();

    Frame(RoutingDefinition routingDefinition, DslTrace trace, Option<Frame> parent) {
        this.routingDefinition = routingDefinition;
        this.parent = parent;
        this.trace = trace;
        this.pathCaptureFrame = Lazy.of(() -> new Frame(routingDefinition, this.captureTrace(Option.none()), (Option<Frame>)Option.some((Object)this)));
    }

    Frame pathChild(String path) {
        Frame frame = this;
        for (String seg : Paths.segments(path)) {
            Option child = frame.pathSegments.get((Object)seg);
            if (child.isEmpty()) {
                child = Option.some((Object)new Frame(frame.routingDefinition, new DslTrace(this.trace, DslTrace.Kind.FRAME, seg), (Option<Frame>)Option.some((Object)frame)));
                frame.pathSegments = frame.pathSegments.put((Object)seg, (Object)((Frame)child.get()));
            }
            frame = (Frame)child.get();
        }
        return frame;
    }

    Frame captureChild(Capture.Attachment<?> capture) {
        Frame f = (Frame)this.pathCaptureFrame.get();
        this.pathCaptures = this.pathCaptures.append(capture);
        f.trace = this.captureTrace(Option.some(capture));
        return f;
    }

    private DslTrace captureTrace(Option<Capture<?>> capture) {
        return new DslTrace(this.trace, DslTrace.Kind.FRAME, "{" + (String)capture.map(Capture::name).getOrElse((Object)"") + "}");
    }

    void run(Blocks.Block0 block) {
        Frame prev = this.routingDefinition.currentFrame;
        try {
            this.routingDefinition.currentFrame = this;
            block.run();
        }
        finally {
            this.routingDefinition.currentFrame = prev;
        }
    }

    EndpointBuilder.Method endpoint(Set<HttpMethod> initialMethods) {
        initialMethods.forEach(HttpMethod::checkUserImplementable);
        EndpointBuilder.Method ep = new EndpointBuilder.Method(new DslTrace(this.trace, DslTrace.Kind.ENDPOINT), this::endpointUpdate, initialMethods);
        this.addEndpoint(ep);
        return ep;
    }

    EndpointBuilder.Method endpoint(String path, Set<HttpMethod> initialMethods) {
        return this.pathChild(path).endpoint(initialMethods);
    }

    private void addEndpoint(EndpointBuilder<?, ?> ep) {
        ep.methods.filter(arg_0 -> this.endpoints.containsKey(arg_0)).headOption().forEach(m -> {
            throw this.duplicateEndpointException((HttpMethod)((Object)m), ep);
        });
        ep.methods.forEach(m -> {
            this.endpoints = this.endpoints.put((Object)m, (Object)ep);
        });
    }

    private void endpointUpdate(EndpointBuilder<?, ?> prev, EndpointBuilder<?, ?> current) {
        prev.methods.diff(current.methods).forEach(m -> {
            this.endpoints = this.endpoints.remove((Object)m);
        });
        current.methods.forEach(m -> {
            if (!((Boolean)this.endpoints.get((Object)m).map(p -> p.equals(prev)).getOrElse((Object)true)).booleanValue()) {
                throw this.duplicateEndpointException((HttpMethod)((Object)m), current);
            }
            this.endpoints = this.endpoints.put((Object)m, (Object)current);
        });
    }

    void handler(Function<? super HttpHandler, ? extends HttpHandler> handler) {
        this.handlers = this.handlers.append(handler);
    }

    private RoutingDefinitionException duplicateEndpointException(HttpMethod m, EndpointBuilder<?, ?> ep) {
        return new RoutingDefinitionException("Duplicate endpoint: " + this.endpointTrace(m, ep) + (String)this.endpoints.get((Object)m).map(p -> "\nPrevious endpoint: " + this.endpointTrace(m, (EndpointBuilder<?, ?>)p)).getOrElse((Object)""));
    }

    HttpHandler materialize() {
        PathSegmentHandler.Builder routing = PathSegmentHandler.builder();
        ((Option)this.endpoints.foldLeft((Object)Option.none(), (h, a) -> h.orElse(Option.some((Object)HttpMethodHandler.of((Map<HttpMethod, HttpHandler>)HashMap.empty()))).map(h2 -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Materializing endpoint: {}", (Object)this.endpointTrace((Tuple2<HttpMethod, ? extends EndpointBuilder<?, ?>>)a));
            }
            return h2.add((HttpMethod)((Object)((Object)((Object)a._1))), ((EndpointBuilder)a._2).handler(this).fallbackEncoder(() -> (HttpEncoder)this.find(f -> f.objectCodecFactory).flatMap(f -> f.encoder(Object.class)).getOrElseThrow(() -> new RoutingDefinitionException("No object codec set: " + this.endpointTrace((Tuple2<HttpMethod, ? extends EndpointBuilder<?, ?>>)a)))));
        }))).forEach(routing::hereHandler);
        this.pathSegments.forEach(seg -> routing.exactSegment((String)seg._1, ((Frame)seg._2).materialize()));
        if (!this.pathCaptures.isEmpty()) {
            routing.capture((Seq<? extends BiConsumer<? super HttpServerExchange, ? super String>>)this.pathCaptures.map(c -> c::capture), ((Frame)this.pathCaptureFrame.get()).materialize());
        }
        return (HttpHandler)this.handlers.foldLeft((Object)((HttpHandler)this.restriction.map(r -> new AuthenticationConstraintHandler((HttpHandler)new AuthenticationCallHandler((HttpHandler)new AccessCheckHandler((AccessCheckHandler.AccessRestriction)r, routing.build())))).getOrElse(routing::build)), (p, n) -> (HttpHandler)n.apply(p));
    }

    private String endpointTrace(Tuple2<HttpMethod, ? extends EndpointBuilder<?, ?>> ep) {
        return this.endpointTrace((HttpMethod)((Object)ep._1()), (EndpointBuilder)ep._2());
    }

    private String endpointTrace(HttpMethod method, EndpointBuilder<?, ?> ep) {
        return String.valueOf((Object)method) + " " + ep.trace.stackTrace();
    }

    void merge(Frame that) {
        this.merge(new DslTrace(this.trace, DslTrace.Kind.MERGE), that);
    }

    private void merge(DslTrace mergeTrace, Frame that) {
        if (that.objectCodecFactory.isDefined()) {
            this.objectCodecFactory = Option.some((Object)((HttpObjectCodecFactory)that.objectCodecFactory.get()));
        }
        for (EndpointBuilder ep : that.endpoints.values().distinct()) {
            this.addEndpoint(ep.fork(ep.trace.reroot(mergeTrace), this::endpointUpdate));
        }
        if (!that.pathCaptures.isEmpty()) {
            this.pathCaptures = this.pathCaptures.appendAll(that.pathCaptures);
            ((Frame)this.pathCaptureFrame.get()).merge(mergeTrace, (Frame)that.pathCaptureFrame.get());
        }
        that.pathSegments.forEach(thatSegs -> this.pathChild((String)thatSegs._1).merge(mergeTrace, (Frame)thatSegs._2));
        this.handlers = this.handlers.appendAll(that.handlers);
    }

    <T> Option<T> find(Function<? super Frame, Option<T>> getter) {
        Option<T> current = getter.apply(this);
        return current.orElse(() -> this.parent.flatMap(p -> p.find(getter)));
    }

    public final class StandardEncoders {
        Option<HttpEncoder<CharSequence>> plainText = Option.none();
        Option<HttpEncoder<CharSequence>> html = Option.none();

        private StandardEncoders() {
        }

        public HttpEncoder<CharSequence> plainText() {
            return (HttpEncoder)Frame.this.find(t -> t.enc.plainText).getOrElse(() -> TextCodec.plainText());
        }

        public HttpEncoder<CharSequence> html() {
            return (HttpEncoder)Frame.this.find(t -> t.enc.html).getOrElse(() -> TextCodec.html());
        }

        public <T> HttpEncoder<? super T> object(Class<T> type) {
            return (HttpEncoder)Frame.this.find(f -> f.objectCodecFactory.flatMap(ocf -> ocf.encoder(type))).getOrElseThrow(() -> new IllegalStateException("No object decoder for " + String.valueOf(type)));
        }
    }

    public final class StandardDecoders {
        Option<HttpDecoder<? extends String>> plainText = Option.none();

        private StandardDecoders() {
        }

        public HttpDecoder<? extends String> plainText() {
            return (HttpDecoder)Frame.this.find(t -> t.dec.plainText).getOrElse(() -> TextCodec.plainText());
        }

        public <T> HttpDecoder<? extends T> object(Class<T> type) {
            return (HttpDecoder)Frame.this.find(f -> f.objectCodecFactory.flatMap(ocf -> ocf.decoder(type))).getOrElseThrow(() -> new IllegalStateException("No object decoder for " + String.valueOf(type)));
        }
    }
}

