/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.http.server.undertow.routing.Capture;
import ch.raffael.meldioc.library.http.server.undertow.routing.Converter;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public final class QueryCaptureBuilder {
    private final String name;

    QueryCaptureBuilder(String name) {
        this.name = name;
    }

    private static Collection<String> getAll(String name, HttpServerExchange exchange) {
        return Objects.requireNonNullElseGet((Collection)exchange.getQueryParameters().get(name), Collections::emptyList);
    }

    private static Option<String> getFirst(String name, HttpServerExchange exchange) {
        return Option.of((Object)((Deque)exchange.getQueryParameters().get(name))).flatMap(v -> v.isEmpty() ? Option.none() : Option.some((Object)((String)v.peekFirst())));
    }

    public QueryCapture.Single<String> asString() {
        return this.as(Converter.asString());
    }

    public QueryCapture.Single<Integer> asInt() {
        return this.as(Converter.asInt());
    }

    public QueryCapture.Single<Boolean> asBoolean() {
        return this.as(Converter.asBoolean());
    }

    public <T> QueryCapture.Single<T> as(Converter<? extends T> converter) {
        return new QueryCapture.Single<T>(this.name, converter);
    }

    public static abstract class QueryCapture<T>
    extends Capture.Cached<Option<T>> {
        QueryCapture(String name) {
            super(name);
        }

        public static final class Collection<T, C extends Traversable<T>>
        extends Capture.Cached<C> {
            private final Converter<? extends T> converter;
            private final Supplier<? extends C> initial;
            private final BiFunction<? super C, ? super T, ? extends C> appender;
            private final Supplier<? extends C> orElse;

            private Collection(String name, Converter<? extends T> converter, Supplier<? extends C> initial, BiFunction<? super C, ? super T, ? extends C> appender, Supplier<? extends C> orElse) {
                super(name);
                this.converter = converter;
                this.initial = initial;
                this.appender = appender;
                this.orElse = orElse;
            }

            public Capture<C> nonEmpty() {
                return new Capture<C>(this.name()){

                    @Override
                    C get(HttpServerExchange exchange) throws HttpStatusException {
                        Traversable value = (Traversable)this.get(exchange);
                        if (value.isEmpty()) {
                            throw HttpStatusException.badRequest("Missing query parameter '" + this.name() + "'");
                        }
                        return value;
                    }
                };
            }

            public Capture<C> orElse(C orElse) {
                return new Collection<T, Traversable>(this.name(), this.converter, this.initial, this.appender, () -> orElse);
            }

            public Capture<C> orElse(Supplier<? extends C> orElse) {
                return new Collection<T, C>(this.name(), this.converter, this.initial, this.appender, orElse);
            }

            @Override
            C extract(HttpServerExchange exchange) throws HttpStatusException {
                java.util.Collection<String> all = QueryCaptureBuilder.getAll(this.name(), exchange);
                if (!all.isEmpty()) {
                    Traversable result = (Traversable)this.initial.get();
                    for (String v : all) {
                        result = (Traversable)this.appender.apply((C)result, (Traversable)this.converter.convert(this.name(), v));
                    }
                    return (C)result;
                }
                return (C)((Traversable)this.orElse.get());
            }
        }

        public static final class Single<T>
        extends QueryCapture<T> {
            private final Converter<? extends T> converter;

            private Single(String name, Converter<? extends T> converter) {
                super(name);
                this.converter = converter;
            }

            public Capture<T> required() {
                return new Capture<T>(this.name()){

                    @Override
                    T get(HttpServerExchange exchange) throws HttpStatusException {
                        return ((Option)this.get(exchange)).getOrElseThrow(() -> HttpStatusException.badRequest("Missing parameter '" + this.name() + "'"));
                    }
                };
            }

            public Capture<T> rq() {
                return this.required();
            }

            public Capture<T> orElse(final T orElse) {
                return new Capture<T>(this.name()){

                    @Override
                    T get(HttpServerExchange exchange) throws HttpStatusException {
                        return ((Option)this.get(exchange)).getOrElse(orElse);
                    }
                };
            }

            public Capture<T> orElse(final Supplier<? extends T> orElse) {
                return new Capture<T>(this.name()){

                    @Override
                    T get(HttpServerExchange exchange) throws HttpStatusException {
                        return ((Option)this.get(exchange)).getOrElse(orElse);
                    }
                };
            }

            public Collection<T, Seq<T>> list() {
                return new Collection<Object, Seq>(this.name(), this.converter, List::empty, Seq::append, List::empty);
            }

            public Collection<T, Set<T>> set() {
                return new Collection<Object, Set>(this.name(), this.converter, LinkedHashSet::empty, Set::add, LinkedHashSet::empty);
            }

            @Override
            Option<T> extract(HttpServerExchange exchange) throws HttpStatusException {
                Option<String> value = QueryCaptureBuilder.getFirst(this.name(), exchange);
                return !value.isDefined() ? Option.none() : Option.some(this.converter.convert(this.name(), (String)value.get()));
            }
        }
    }
}

