/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.http.server.undertow.codec.BinaryCodec;
import ch.raffael.meldioc.library.http.server.undertow.codec.EmptyBody;
import ch.raffael.meldioc.library.http.server.undertow.routing.Actions;
import ch.raffael.meldioc.library.http.server.undertow.routing.EndpointBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpMethod;
import ch.raffael.meldioc.util.IOStreams;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

class ResourceLoader
implements Actions.Action0<byte[]> {
    private final Class<?> resourceClass;
    private final String resource;
    private final Actions.Action1<? super byte[], ? extends byte[]> processor;
    private final Object lock = new Object();
    private volatile Cache cache;

    ResourceLoader(Class<?> resourceClass, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor, Cache cache) {
        this.resourceClass = resourceClass;
        this.resource = resource;
        this.processor = processor;
        this.cache = cache;
    }

    public static EndpointBuilder<EmptyBody, byte[]> apply(Frame frame, ContentType contentType, Class<?> resourceClass, String resource) {
        return frame.endpoint((Set<HttpMethod>)HashSet.of((Object)((Object)HttpMethod.GET))).map(new ResourceLoader(resourceClass, resource, ResourceLoader.noProcessor(), new Cache.Hard())).respond(new BinaryCodec.ByteArray(new ContentType[]{contentType}));
    }

    public static EndpointBuilder<EmptyBody, byte[]> apply(Frame frame, String contentType, Class<?> resourceClass, String resource) {
        return ResourceLoader.apply(frame, ContentType.of((String)contentType), resourceClass, resource);
    }

    public static EndpointBuilder<EmptyBody, byte[]> apply(Frame frame, ContentType contentType, Class<?> resourceClass, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor) {
        return frame.endpoint((Set<HttpMethod>)HashSet.of((Object)((Object)HttpMethod.GET))).map(new ResourceLoader(resourceClass, resource, processor, new Cache.Hard())).respond(new BinaryCodec.ByteArray(new ContentType[]{contentType}));
    }

    public static EndpointBuilder<EmptyBody, byte[]> apply(Frame frame, String contentType, Class<?> resourceClass, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor) {
        return ResourceLoader.apply(frame, ContentType.of((String)contentType), resourceClass, resource, processor);
    }

    private static Actions.Action1<byte[], byte[]> noProcessor() {
        return b -> b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] perform() throws Exception {
        byte[] b = this.cache.get();
        if (b == null) {
            Object object = this.lock;
            synchronized (object) {
                b = this.cache.get();
                if (b == null) {
                    b = this.processor.perform((byte[])this.load());
                    this.cache = this.cache.put(b);
                }
            }
        }
        return b;
    }

    private byte[] load() throws IOException {
        try (InputStream stream = this.resourceClass.getResourceAsStream(this.resource);){
            if (stream == null) {
                throw new IllegalArgumentException("resource " + String.valueOf(this.resourceClass) + "::" + this.resource);
            }
            byte[] byArray = IOStreams.readFully((InputStream)stream);
            return byArray;
        }
    }

    private static interface Cache {
        public byte @Nullable [] get();

        public Cache put(byte[] var1);

        public static final class Ref
        implements Cache {
            private final Function<? super byte[], ? extends Reference<? extends byte[]>> refFun;
            @Nullable
            private Reference<? extends byte[]> ref;

            private Ref(Function<? super byte[], ? extends Reference<? extends byte[]>> refFun) {
                this.refFun = refFun;
            }

            @Override
            public byte @Nullable [] get() {
                Reference<? extends byte[]> r = this.ref;
                if (r == null) {
                    return null;
                }
                byte[] b = r.get();
                if (b == null) {
                    this.ref = null;
                    return null;
                }
                return b;
            }

            @Override
            public Ref put(byte[] bytes) {
                this.ref = this.refFun.apply((byte[])bytes);
                return this;
            }
        }

        public static final class Hard
        implements Cache {
            private byte @Nullable [] bytes;

            @Override
            public byte @Nullable [] get() {
                return this.bytes;
            }

            @Override
            public Cache put(byte[] bytes) {
                this.bytes = bytes;
                return this;
            }
        }
    }
}

