/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import ch.raffael.meldioc.library.codec.ContentType;
import ch.raffael.meldioc.library.codec.ObjectCodecFactory;
import ch.raffael.meldioc.library.http.server.undertow.codec.EmptyBody;
import ch.raffael.meldioc.library.http.server.undertow.codec.HttpObjectCodecFactory;
import ch.raffael.meldioc.library.http.server.undertow.handler.AccessCheckHandler;
import ch.raffael.meldioc.library.http.server.undertow.routing.Actions;
import ch.raffael.meldioc.library.http.server.undertow.routing.Codecs;
import ch.raffael.meldioc.library.http.server.undertow.routing.DslTrace;
import ch.raffael.meldioc.library.http.server.undertow.routing.EndpointBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.Frame;
import ch.raffael.meldioc.library.http.server.undertow.routing.QueryCaptureBuilder;
import ch.raffael.meldioc.library.http.server.undertow.routing.ResourceLoader;
import ch.raffael.meldioc.library.http.server.undertow.routing.RoutingBuilder;
import ch.raffael.meldioc.library.http.server.undertow.security.Role;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpMethod;
import io.undertow.server.HttpHandler;
import io.vavr.collection.HashSet;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.util.function.Function;

public abstract class RoutingDefinition {
    Frame rootFrame;
    Frame currentFrame;
    private final Codecs codec = new Codecs();

    protected RoutingDefinition() {
        this.rootFrame = this.currentFrame = new Frame(this, new DslTrace((Option<DslTrace>)Option.none(), DslTrace.Kind.FRAME), (Option<Frame>)Option.none());
    }

    public static RoutingDefinition empty() {
        class Empty
        extends RoutingDefinition {
            Empty() {
            }
        }
        return new Empty();
    }

    public RoutingBuilder.InitialFragment path() {
        return RoutingBuilder.begin(this.currentFrame);
    }

    public RoutingBuilder.Fragment0 path(String path) {
        return RoutingBuilder.begin(this.currentFrame).path(path);
    }

    public QueryCaptureBuilder query(String name) {
        return new QueryCaptureBuilder(name);
    }

    public EndpointBuilder.Method endpoint(HttpMethod ... methods) {
        return this.currentFrame.endpoint((Set<HttpMethod>)LinkedHashSet.of((Object[])methods));
    }

    public EndpointBuilder.Method endpoint(String path, HttpMethod ... methods) {
        return this.currentFrame.endpoint(path, (Set<HttpMethod>)LinkedHashSet.of((Object[])methods));
    }

    public EndpointBuilder.Method get() {
        return this.endpoint(HttpMethod.GET);
    }

    public EndpointBuilder.Method get(String path) {
        return this.endpoint(path, HttpMethod.GET);
    }

    public EndpointBuilder.Method head() {
        return this.endpoint(HttpMethod.HEAD);
    }

    public EndpointBuilder.Method head(String path) {
        return this.endpoint(path, HttpMethod.HEAD);
    }

    public EndpointBuilder.Method post() {
        return this.endpoint(HttpMethod.POST);
    }

    public EndpointBuilder.Method post(String path) {
        return this.endpoint(path, HttpMethod.POST);
    }

    public EndpointBuilder.Method put() {
        return this.endpoint(HttpMethod.PUT);
    }

    public EndpointBuilder.Method put(String path) {
        return this.endpoint(path, HttpMethod.PUT);
    }

    public EndpointBuilder.Method patch() {
        return this.endpoint(HttpMethod.PATCH);
    }

    public EndpointBuilder.Method patch(String path) {
        return this.endpoint(path, HttpMethod.PATCH);
    }

    public EndpointBuilder.Method delete() {
        return this.endpoint(HttpMethod.DELETE);
    }

    public EndpointBuilder.Method delete(String path) {
        return this.endpoint(path, HttpMethod.DELETE);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(ContentType contentType, String resource) {
        return ResourceLoader.apply(this.currentFrame, contentType, StackWalker.getInstance().getCallerClass(), resource);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(ContentType contentType, Class<?> resourceClass, String resource) {
        return ResourceLoader.apply(this.currentFrame, contentType, resourceClass, resource);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(String contentType, String resource) {
        return ResourceLoader.apply(this.currentFrame, contentType, StackWalker.getInstance().getCallerClass(), resource);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(String contentType, Class<?> resourceClass, String resource) {
        return ResourceLoader.apply(this.currentFrame, contentType, resourceClass, resource);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(ContentType contentType, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor) {
        return ResourceLoader.apply(this.currentFrame, contentType, StackWalker.getInstance().getCallerClass(), resource, processor);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(ContentType contentType, Class<?> resourceClass, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor) {
        return ResourceLoader.apply(this.currentFrame, contentType, resourceClass, resource, processor);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(String contentType, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor) {
        return ResourceLoader.apply(this.currentFrame, contentType, StackWalker.getInstance().getCallerClass(), resource, processor);
    }

    public EndpointBuilder<EmptyBody, byte[]> resource(String contentType, Class<?> resourceClass, String resource, Actions.Action1<? super byte[], ? extends byte[]> processor) {
        return ResourceLoader.apply(this.currentFrame, contentType, resourceClass, resource, processor);
    }

    public void handler(Function<? super HttpHandler, ? extends HttpHandler> handler) {
        this.currentFrame.handler(handler);
    }

    public void restrict(AccessCheckHandler.AccessRestriction value) {
        this.currentFrame.restriction = Option.some((Object)value);
    }

    public <R extends Role> void restrict(Function<? super String, ? extends Option<? extends R>> mapper, Set<? extends R> roles) {
        this.restrict(AccessCheckHandler.accessByRole(mapper, roles));
    }

    @SafeVarargs
    public final <R extends Role> void restrict(Function<? super String, ? extends Option<? extends R>> mapper, R ... roles) {
        this.restrict(AccessCheckHandler.accessByRole(mapper, HashSet.of((Object[])roles)));
    }

    public <R extends Enum<?>> void restrict(Class<R> roleEnum, Set<? extends R> roles) {
        this.restrict(AccessCheckHandler.accessByRole(roleEnum, roles));
    }

    @SafeVarargs
    public final <R extends Enum<?>> void restrict(Class<R> roleEnum, R ... roles) {
        this.restrict(AccessCheckHandler.accessByRole(roleEnum, HashSet.of((Object[])roles)));
    }

    public Codecs codec() {
        return this.codec;
    }

    public void objectCodec(HttpObjectCodecFactory objectCodecFactory) {
        this.currentFrame.objectCodecFactory = Option.some((Object)objectCodecFactory);
    }

    public void objectCodec(ObjectCodecFactory objectCodecFactory) {
        this.objectCodec(HttpObjectCodecFactory.wrapBuffered(objectCodecFactory));
    }

    public void merge(RoutingDefinition that) {
        this.currentFrame.merge(that.rootFrame);
    }

    public static <R> Actions.Action0<R> action(Actions.Action0<? extends R> action) {
        return Actions.of(action);
    }

    public static Actions.Action0Void action(Actions.Action0Void action) {
        return Actions.of(action);
    }

    public static <R> Actions.Action0<R> action(R returnValue, Actions.Action0Void action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, R> Actions.Action1<P1, R> action(Actions.Action1<? super P1, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1> Actions.Action1Void<P1> action(Actions.Action1Void<? super P1> action) {
        return Actions.of(action);
    }

    public static <P1, R> Actions.Action1<P1, R> action(R returnValue, Actions.Action1Void<? super P1> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, R> Actions.Action2<P1, P2, R> action(Actions.Action2<? super P1, ? super P2, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2> Actions.Action2Void<P1, P2> action(Actions.Action2Void<? super P1, ? super P2> action) {
        return Actions.of(action);
    }

    public static <P1, P2, R> Actions.Action2<P1, P2, R> action(R returnValue, Actions.Action2Void<? super P1, ? super P2> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, R> Actions.Action3<P1, P2, P3, R> action(Actions.Action3<? super P1, ? super P2, ? super P3, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3> Actions.Action3Void<P1, P2, P3> action(Actions.Action3Void<? super P1, ? super P2, ? super P3> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, R> Actions.Action3<P1, P2, P3, R> action(R returnValue, Actions.Action3Void<? super P1, ? super P2, ? super P3> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, P4, R> Actions.Action4<P1, P2, P3, P4, R> action(Actions.Action4<? super P1, ? super P2, ? super P3, ? super P4, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4> Actions.Action4Void<P1, P2, P3, P4> action(Actions.Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, R> Actions.Action4<P1, P2, P3, P4, R> action(R returnValue, Actions.Action4Void<? super P1, ? super P2, ? super P3, ? super P4> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, P4, P5, R> Actions.Action5<P1, P2, P3, P4, P5, R> action(Actions.Action5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5> Actions.Action5Void<P1, P2, P3, P4, P5> action(Actions.Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, R> Actions.Action5<P1, P2, P3, P4, P5, R> action(R returnValue, Actions.Action5Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, P4, P5, P6, R> Actions.Action6<P1, P2, P3, P4, P5, P6, R> action(Actions.Action6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6> Actions.Action6Void<P1, P2, P3, P4, P5, P6> action(Actions.Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, R> Actions.Action6<P1, P2, P3, P4, P5, P6, R> action(R returnValue, Actions.Action6Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, R> Actions.Action7<P1, P2, P3, P4, P5, P6, P7, R> action(Actions.Action7<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7> Actions.Action7Void<P1, P2, P3, P4, P5, P6, P7> action(Actions.Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, R> Actions.Action7<P1, P2, P3, P4, P5, P6, P7, R> action(R returnValue, Actions.Action7Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, P8, R> Actions.Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> action(Actions.Action8<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, P8> Actions.Action8Void<P1, P2, P3, P4, P5, P6, P7, P8> action(Actions.Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, P8, R> Actions.Action8<P1, P2, P3, P4, P5, P6, P7, P8, R> action(R returnValue, Actions.Action8Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8> action) {
        return Actions.of(returnValue, action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, P8, P9, R> Actions.Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> action(Actions.Action9<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9, ? extends R> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, P8, P9> Actions.Action9Void<P1, P2, P3, P4, P5, P6, P7, P8, P9> action(Actions.Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
        return Actions.of(action);
    }

    public static <P1, P2, P3, P4, P5, P6, P7, P8, P9, R> Actions.Action9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> action(R returnValue, Actions.Action9Void<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? super P7, ? super P8, ? super P9> action) {
        return Actions.of(returnValue, action);
    }
}

