/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.routing;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.EnumSet;
import org.jetbrains.annotations.Nullable;

public final class StaticResourcesBuilder {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(EnumSet.of(StackWalker.Option.RETAIN_CLASS_REFERENCE), 2);
    @Nullable
    private ResourceManager resourceManager = null;

    StaticResourcesBuilder() {
    }

    public StaticResourcesBuilder classpath(String path) {
        this.checkResourceManagerChangeable();
        Tuple2<ClassLoader, String> c = this.baseFromCaller();
        return this.classpath((ClassLoader)c._1(), (String)c._2(), path);
    }

    public StaticResourcesBuilder classpath(Class<?> base, String path) {
        this.checkResourceManagerChangeable();
        return this.classpath(base.getClassLoader(), this.baseForClass(base), path);
    }

    public StaticResourcesBuilder classpath(ClassLoader loader, String base, String path) {
        this.checkResourceManagerChangeable();
        boolean absolute = false;
        while (path.length() > 0 && path.charAt(0) == '/') {
            absolute = true;
            path = path.substring(1);
        }
        if (!absolute) {
            path = path.isEmpty() ? base : base + "/" + path;
        }
        this.resourceManager = new ClassPathResourceManager(loader, path);
        return this;
    }

    HttpHandler materialize(HttpHandler next) {
        return new ResourceHandler(this.resourceManager, next);
    }

    private void checkResourceManagerChangeable() {
        if (this.resourceManager != null) {
            throw new IllegalStateException("Resource manager already set");
        }
    }

    private Tuple2<ClassLoader, String> baseFromCaller() {
        if (this.resourceManager == null) {
            throw new IllegalStateException("No resource manager set");
        }
        return STACK_WALKER.walk(s -> s.map(StackWalker.StackFrame::getDeclaringClass).dropWhile(c -> c != StaticResourcesBuilder.class).dropWhile(c -> c == StaticResourcesBuilder.class).findFirst().map(c -> Tuple.of((Object)c.getClassLoader(), (Object)this.baseForClass((Class<?>)c))).orElseThrow(() -> new IllegalStateException("Cannot determine caller class")));
    }

    private String baseForClass(Class<?> c) {
        return c.getPackageName().replace('.', '/');
    }
}

