/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.util;

import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatusException;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.vavr.collection.Array;
import io.vavr.collection.Map;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.util.function.Function;

public enum HttpMethod {
    GET,
    HEAD,
    POST,
    PUT,
    PATCH,
    DELETE,
    OPTIONS;

    private static final Map<HttpString, HttpMethod> METHODS;
    private static final Map<String, HttpMethod> METHODS_STRINGS;
    private final HttpString httpName = new HttpString(this.name());

    public HttpString httpName() {
        return this.httpName;
    }

    public static Option<HttpMethod> forName(HttpString name) {
        return METHODS.get((Object)name);
    }

    public static Option<HttpMethod> forName(String name) {
        return METHODS_STRINGS.get((Object)name);
    }

    public boolean isUserImplementable() {
        return this.ordinal() <= DELETE.ordinal();
    }

    public HttpMethod checkUserImplementable() throws IllegalArgumentException {
        if (!this.isUserImplementable()) {
            throw new IllegalStateException("Method  not user implementable: " + String.valueOf((Object)this));
        }
        return this;
    }

    public static boolean isOptionsRequest(HttpServerExchange exchange) {
        return Methods.OPTIONS.equals(exchange.getRequestMethod());
    }

    public static void optionsResponse(HttpServerExchange exchange, Traversable<String> methods) {
        HttpMethod.addAllowHeader(exchange, methods);
        exchange.getResponseHeaders().add(Headers.CONTENT_LENGTH, 0L);
        HttpStatus.NO_CONTENT.apply(exchange);
        exchange.endExchange();
    }

    public static void methodNotAllowedResponse(HttpServerExchange exchange, Traversable<String> methods) {
        new HttpStatusException(HttpStatus.METHOD_NOT_ALLOWED).endRequest(HttpMethod.addAllowHeader(exchange, methods));
    }

    private static HttpServerExchange addAllowHeader(HttpServerExchange exchange, Traversable<String> methods) {
        exchange.getResponseHeaders().add(Headers.ALLOW, methods.toLinkedSet().add((Object)"OPTIONS").mkString((CharSequence)","));
        return exchange;
    }

    static {
        METHODS = Array.of((Object[])HttpMethod.values()).toMap(HttpMethod::httpName, Function.identity());
        METHODS_STRINGS = METHODS.mapKeys(HttpString::toString);
    }
}

