/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.util;

import ch.raffael.meldioc.library.http.server.undertow.handler.ErrorMessageHandler;
import ch.raffael.meldioc.library.http.server.undertow.handler.ExceptionLogger;
import ch.raffael.meldioc.library.http.server.undertow.util.HttpStatus;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jetbrains.annotations.Nullable;

public class HttpStatusException
extends Exception {
    private final HttpStatus status;

    public HttpStatusException(HttpStatus status) {
        this(status, null);
    }

    public HttpStatusException(HttpStatus status, @Nullable Throwable cause) {
        super(status.toString(), cause);
        this.status = status;
        if (!status.isValid()) {
            IllegalArgumentException throwing = new IllegalArgumentException("Invalid HTTP status code " + String.valueOf((Object)status.category()));
            throwing.addSuppressed(this);
            throw throwing;
        }
    }

    public HttpStatus status() {
        return this.status;
    }

    public static HttpStatusException badRequest() {
        return HttpStatusException.badRequest("Bad request");
    }

    public static HttpStatusException badRequest(String reason) {
        return new HttpStatusException(HttpStatus.BAD_REQUEST.reason(reason));
    }

    public static HttpStatusException badRequest(String reason, Throwable cause) {
        return new HttpStatusException(HttpStatus.BAD_REQUEST.reason(reason), cause);
    }

    public static HttpStatusException badRequest(Throwable cause) {
        return new HttpStatusException(HttpStatus.BAD_REQUEST, cause);
    }

    public static HttpStatusException serverError() {
        return new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static HttpStatusException serverError(String reason) {
        return new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR.reason(reason));
    }

    public static HttpStatusException serverError(String reason, Throwable cause) {
        return new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR.reason(reason), cause);
    }

    public static HttpStatusException serverError(Throwable cause) {
        return new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, cause);
    }

    public void endRequest(HttpServerExchange exchange) {
        ExceptionLogger.get(exchange).log(exchange, this);
        ErrorMessageHandler.addMessage(exchange, this);
        this.status.apply(exchange);
    }

    public static void endRequestWithServerError(HttpServerExchange exchange, Throwable exception) {
        HttpStatusException.serverError().endRequest(exchange);
    }

    public static void endRequestWithBadRequest(HttpServerExchange exchange, Throwable exception) {
        HttpStatusException.serverError(exception).endRequest(exchange);
    }

    public static void endRequestWithBadRequest(HttpServerExchange exchange, String reason) {
        HttpStatusException.serverError(reason).endRequest(exchange);
    }

    public static enum Kind {
        INFO,
        SUCCESS,
        REDIRECT,
        CLIENT_ERROR,
        SERVER_ERROR;


        static Kind ofCode(int code) {
            if (code >= 100 && code < 200) {
                return INFO;
            }
            if (code >= 200 && code < 300) {
                return SUCCESS;
            }
            if (code >= 300 && code < 400) {
                return REDIRECT;
            }
            if (code >= 400 && code < 500) {
                return CLIENT_ERROR;
            }
            return SERVER_ERROR;
        }
    }

    public static class Handler
    implements HttpHandler {
        private final HttpHandler next;

        public Handler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            try {
                this.next.handleRequest(exchange);
            }
            catch (HttpStatusException e) {
                e.endRequest(exchange);
            }
        }
    }
}

