/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.library.http.server.undertow.util;

import ch.raffael.meldioc.logging.Logging;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.xnio.Option;
import org.xnio.OptionMap;

public class XnioOptions {
    private static final Logger LOG = Logging.logger();
    private final OptionMap.Builder builder;
    private final ClassLoader classLoader;
    private final List<Class<?>> classes;

    public XnioOptions(ClassLoader classLoader, Class<?> ... classes) {
        this(OptionMap.builder(), classLoader, classes);
    }

    public XnioOptions(OptionMap.Builder builder, ClassLoader classLoader, Class<?> ... classes) {
        this(builder, classLoader, Arrays.asList(classes));
    }

    public XnioOptions(ClassLoader classLoader, Collection<? extends Class<?>> classes) {
        this(OptionMap.builder(), classLoader, classes);
    }

    public XnioOptions(OptionMap.Builder builder, ClassLoader classLoader, Collection<? extends Class<?>> classes) {
        this.builder = builder;
        this.classLoader = classLoader;
        this.classes = List.copyOf(classes);
    }

    public XnioOptions load(Config config) {
        config.entrySet().stream().map(e -> ConfigUtil.splitPath((String)((String)e.getKey()))).filter(p -> p.size() == 1).map(p -> (String)p.get(0)).forEach((? super T k) -> this.setOption((String)k, config.getString(k)));
        return this;
    }

    private XnioOptions setOption(String key, String value) {
        Field field = this.classes.stream().flatMap(c -> {
            try {
                Field f = c.getField(key);
                return Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers()) && Option.class.isAssignableFrom(f.getType()) ? Stream.of(f) : Stream.empty();
            }
            catch (NoSuchFieldException e) {
                return Stream.empty();
            }
        }).findFirst().orElse(null);
        if (field == null) {
            LOG.warn("Unknown option '{}' for classes {}", (Object)key, this.classes);
        } else {
            Option option = null;
            try {
                option = (Option)field.get(null);
            }
            catch (IllegalAccessException e) {
                LOG.error("Error retrieving option object for '{}' from {}", new Object[]{key, field, e});
            }
            if (option != null) {
                this.setString(option, value);
            }
        }
        return this;
    }

    public <T> XnioOptions set(Option<T> option, T value) {
        this.builder.set(option, value);
        return this;
    }

    public <T> XnioOptions setString(Option<T> option, String value) {
        this.builder.set(option, option.parseValue(value, this.classLoader));
        return this;
    }

    public OptionMap options() {
        return this.builder.getMap();
    }

    public void forEach(Consumer consumer) {
        OptionMap options = this.options();
        options.forEach(o -> this.forwardOption(consumer, options, (Option)o));
    }

    private <T> void forwardOption(Consumer consumer, OptionMap map, Option<T> option) {
        consumer.accept(option, map.get(option));
    }

    @FunctionalInterface
    public static interface Consumer {
        public <T> void accept(Option<T> var1, T var2);
    }
}

