/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.logging.spi;

import ch.raffael.meldioc.logging.spi.Adapter;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.LogManager;

public class Log4J2Adapter
extends Adapter.Default {
    private static final String LOG4J_MANAGER = "org.apache.logging.log4j.jul.LogManager";

    public Log4J2Adapter() {
        super("org.apache.logging.slf4j.Log4jLoggerFactory");
    }

    @Override
    public Set<Adapter.InitFlag> initialize(Adapter.InitLogger initLogger) {
        if (LogManager.getLogManager().getClass().getName().equals(LOG4J_MANAGER)) {
            return EnumSet.of(Adapter.InitFlag.SKIP_JUL_TO_SLF4J_BRIDGE);
        }
        initLogger.warn("java.util.logging is not redirected to Log4j.");
        initLogger.warn("Start the JVM with");
        initLogger.warn("  -Djava.util.logging.manager=org.apache.logging.log4j.jul.LogManager");
        initLogger.warn("to fix this.");
        return Set.of();
    }

    @Override
    public void shutdown() {
        org.apache.logging.log4j.LogManager.shutdown();
    }
}

