/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.logging;

import ch.raffael.meldioc.logging.spi.Adapter;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Logging {
    private static final Map<String, Adapter> LOGGING_INITIALIZERS = ServiceLoader.load(Adapter.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(Adapter::backendClassName, Function.identity()));
    private static final StackWalker WALKER = StackWalker.getInstance(EnumSet.of(StackWalker.Option.RETAIN_CLASS_REFERENCE), 4);
    private static final ClassValue<String> LOGGER_NAME_CACHE = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> type) {
            String name;
            if (type.isArray()) {
                throw new IllegalArgumentException("Cannot create logger for array type: " + type);
            }
            Class<?> loggerType = type;
            while ((name = loggerType.getCanonicalName()) == null) {
                if ((loggerType = loggerType.getEnclosingClass()) != null) continue;
                throw new IllegalStateException("Cannot determine canonical name of " + type);
            }
            return name;
        }
    };
    private static final Optional<Adapter> ADAPTER = Logging.init0();

    private Logging() {
    }

    public static void init() {
    }

    public static void shutdown() {
        ADAPTER.ifPresent(Adapter::shutdown);
    }

    public static Logger logger() {
        return Logging.logger(WALKER.getCallerClass());
    }

    public static Logger logger(Class<?> type) {
        Class<?> loggerType = type;
        while (loggerType.isArray()) {
            loggerType = loggerType.getComponentType();
        }
        return Logging.logger(LOGGER_NAME_CACHE.get(loggerType));
    }

    public static Logger logger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    private static Optional<Adapter> init0() {
        Adapter.InitLogger initLogger = new Adapter.InitLogger(){

            @Override
            public void warn(String message) {
                System.err.println("WARNING: " + Logging.class + ": " + message);
            }
        };
        Optional<Class<Object>> factoryClass = Optional.ofNullable(LoggerFactory.getILoggerFactory().getClass());
        Optional<Object> adapter = Optional.empty();
        while (factoryClass.isPresent() && !(adapter = factoryClass.map(Class::getName).flatMap(c -> Optional.ofNullable(LOGGING_INITIALIZERS.get(c)))).isPresent()) {
            factoryClass = factoryClass.flatMap(c -> Optional.ofNullable(c.getSuperclass()));
        }
        adapter.map(arg_0 -> Logging.lambda$init0$2(initLogger, arg_0)).ifPresentOrElse(arg_0 -> Logging.lambda$init0$3(initLogger, arg_0), () -> Logging.lambda$init0$4(initLogger));
        return adapter;
    }

    private static /* synthetic */ void lambda$init0$4(2 initLogger) {
        initLogger.warn("Unknown SLF4J backend: " + LoggerFactory.getILoggerFactory());
    }

    private static /* synthetic */ void lambda$init0$3(2 initLogger, Set flags) {
        if (!flags.contains((Object)Adapter.InitFlag.SKIP_JUL_TO_SLF4J_BRIDGE)) {
            boolean install;
            initLogger.warn("Installing SLF4JBridgeHandler; this may impact performance, consider a better solution");
            try {
                Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
                install = true;
            }
            catch (ClassNotFoundException e) {
                install = false;
                initLogger.warn("SLF4JBridgeHandler not found on classpath: " + e);
            }
            if (install) {
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
            }
        }
    }

    private static /* synthetic */ Set lambda$init0$2(2 initLogger, Adapter i) {
        return i.initialize(initLogger);
    }
}

