/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.Adaptor;
import ch.raffael.meldioc.model.BuiltinArgument;
import ch.raffael.meldioc.model.CElement;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.Model;
import ch.raffael.meldioc.model.ModelMethod;
import ch.raffael.meldioc.model._CElement;
import ch.raffael.meldioc.model.config.ElementConfig;
import ch.raffael.meldioc.model.config.MountConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.model.messages.Message;
import ch.raffael.meldioc.util.VavrX;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.function.Function;

public final class ModelType<S, T> {
    private final Model<S, T> model;
    private final T type;
    private final CElement<S, T> element;
    private final Role role;
    private final Seq<ModelType<S, T>> superTypes;
    private final Seq<ModelMethod<S, T>> allMethods;
    private final Seq<ModelMethod<S, T>> provisionMethods;
    private final Seq<ModelMethod<S, T>> extensionPointMethods;
    private final Seq<ModelMethod<S, T>> mountMethods;
    private final Seq<ModelMethod<S, T>> setupMethods;
    private final Seq<ModelMethod<S, T>> parameterMethods;

    public ModelType(Model<S, T> model, T type) {
        this.model = model;
        this.type = type;
        this.element = model.adaptor().classElement(type);
        this.role = Role.ofElement(this.element);
        Adaptor adaptor = model.adaptor();
        this.superTypes = adaptor.superTypes(type).map(model::modelOf);
        Map superMethods = this.superTypes.flatMap(cm -> cm.allMethods).groupBy(m -> m.element().methodSignature()).mapValues(candidates -> candidates.sorted((left, right) -> {
            boolean lSubR = adaptor.isSubtypeOf(left.element().type(), right.element().type());
            boolean rSubR = adaptor.isSubtypeOf(right.element().type(), left.element().type());
            if (lSubR && rSubR) {
                return 0;
            }
            if (lSubR) {
                return -1;
            }
            if (rSubR) {
                return 1;
            }
            return 0;
        }));
        Seq declaredMethods = adaptor.declaredMethods(type).map(m -> ModelMethod.of(m, this).withOverrides((Seq)superMethods.get(m.methodSignature()).getOrElse((Object)API.Seq())));
        this.validateClassAnnotations();
        declaredMethods.forEach(this::validateDeclaredMethodAnnotations);
        this.allMethods = declaredMethods.appendAll((Iterable)superMethods.filter(sm -> !declaredMethods.exists(dm -> dm.element().methodSignature().equals(sm._1))).map(Tuple2::_2).map(sm -> sm.size() == 1 ? (ModelMethod)sm.head() : ModelMethod.of(((ModelMethod)sm.head()).element(), this).withImplied(true).withOverrides(sm))).filter(m1 -> {
            boolean include = true;
            include &= this.validateObjectMethods((ModelMethod<S, T>)m1);
            include &= this.excludeStaticMethods((ModelMethod<S, T>)m1);
            include &= this.validateConflictingSuperCompositionRoles((ModelMethod<S, T>)m1);
            if (this.element.configs().exists(c1 -> c1.type().annotationType().equals(Configuration.class))) {
                include &= this.validateAbstractMethodImplementable(this.element, (ModelMethod<S, T>)m1);
            }
            if (!m1.element().configs().isEmpty()) {
                include &= this.validateOverridableMethod((ModelMethod<S, T>)m1);
                include &= this.validateMethodAccessibility(this.element, (ModelMethod<S, T>)m1, false);
                include &= this.validateProvisionOverrides((ModelMethod<S, T>)m1);
            }
            return include;
        });
        this.mountMethods = this.allMethods.filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Feature.Mount.class))).map(VavrX.touch(m -> model.modelOf(m.element().type()).allMethods().filter(mm -> this.validateAbstractMethodImplementable(m.element(), (ModelMethod<S, T>)mm)).filter(mm -> mm.element().configs().exists(c -> c.type().role())).forEach(mm -> this.validateMethodAccessibility(m.element(), (ModelMethod<S, T>)mm, true)))).appendAll((Iterable)this.element.configurationConfigOption().map(mc -> mc.mount().filter(cr -> {
            Object t = adaptor.typeOf((ClassRef)cr);
            if (adaptor.hasTypeParameters(t)) {
                model.message(Message.mountAttributeClassMustNotBeParametrized(this.element, adaptor.classElement(t)));
                return false;
            }
            return true;
        }).map(cr -> ModelMethod.builder().implied(true).modelType(this).element(CElement.builder().synthetic(true).parent((CElement)this.element).source(mc.source()).kind(_CElement.Kind.METHOD).name("synthetic$$" + cr.canonicalName().replace('.', '$')).type(adaptor.typeOf((ClassRef)cr)).accessPolicy(AccessPolicy.LOCAL).isStatic(false).isFinal(false).isAbstract(true).addConfigs(MountConfig.builder().injected(false).source(mc.source()).build()).build()).build())).getOrElse((Object)API.Seq())).filter(this::validateNoParameters).filter(this::validateReferenceType).map(VavrX.touch(m -> {
            if (!m.element().isAbstract()) {
                model.message(Message.mountMethodMustBeAbstract(m.element()));
            }
        })).filter(m -> {
            if (this.role != Role.CONFIGURATION) {
                model.message(Message.mountMethodsAllowedInConfigurationsOnly(m.element()));
                return false;
            }
            return true;
        }).filter(m -> {
            CElement cls = model.adaptor().classElement(m.element().type());
            if (!cls.configs().map(c -> c.type().annotationType()).exists(t -> t.equals(Feature.class) || t.equals(Configuration.class))) {
                model.message(Message.mountMethodMustReturnFeature(m.element(), cls));
                return false;
            }
            return true;
        });
        this.provisionMethods = this.allMethods.filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Provision.class))).filter(this::validateNoParameters).filter(this::validateReferenceType).map(m -> this.mapToMounts((ModelMethod<S, T>)m, ModelType::provisionMethods));
        this.mountMethods.map(VavrX.touch(m -> model.modelOf(m.element().type()).provisionMethods().filter(mp -> mp.element().isAbstract()).forEach(mp -> {
            if (!this.provisionMethods.filter(p -> !p.element().isAbstract() || p.via().isDefined()).exists(p -> p.element().canOverride(mp.element(), adaptor))) {
                model.message(Message.mountedAbstractProvisionHasNoImplementationCandidate(m.element(), mp.element()));
            }
        })));
        this.extensionPointMethods = this.allMethods.filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(ExtensionPoint.class))).filter(this::validateNoParameters).filter(this::validateReferenceType).map(VavrX.touch(m -> {
            CElement cls = model.adaptor().classElement(m.element().type());
            if (!cls.configs().exists(c -> c.type().annotationType().equals(ExtensionPoint.Acceptor.class))) {
                model.message(Message.extensionPointAcceptorReturnRecommended(m.element(), cls));
            }
        })).map(m -> this.mapToMounts((ModelMethod<S, T>)m, ModelType::extensionPointMethods));
        this.parameterMethods = this.allMethods.filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Parameter.class))).filter(this::validateNoParameters).map(VavrX.touch(m -> {
            if (!model.configType().isDefined() && m.element().isAbstract()) {
                model.message(Message.typesafeConfigNotOnClasspath(m.element()));
            } else if (m.element().parameterConfig().value().equals("*")) {
                if (!adaptor.isSubtypeOf(model.configType().get(), m.element().type())) {
                    model.message(Message.configTypeNotSupported(m.element()));
                }
            } else if (model.configSupportedTypeOption(m.element().type()).isEmpty()) {
                model.message(Message.configTypeNotSupported(m.element()));
            }
        })).appendAll(this.collectMounted(ModelType::parameterMethods));
        this.setupMethods = this.allMethods.filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Setup.class))).map(VavrX.touch(m -> {
            if (!adaptor.isNoType(m.element().type())) {
                model.message(Message.returnValueIgnored(m.element()));
            }
        })).appendAll(this.collectMounted(ModelType::setupMethods)).map(this.element.configs().exists(c -> c.type().annotationType().equals(Configuration.class)) ? m -> m.withArguments(this.mapSetupParameters((ModelMethod<S, T>)m)) : Function.identity());
    }

    private ModelMethod<S, T> mapToMounts(ModelMethod<S, T> method, Function<ModelType<S, T>, Seq<ModelMethod<S, T>>> mounted) {
        if (this.element.configurationConfigOption().isEmpty() || !method.element().isAbstract() || method.via().isDefined()) {
            return method;
        }
        Seq forwards = this.mountMethods.map(m -> API.Tuple((Object)m, this.model.modelOf(m.element().type()))).map(tpl -> tpl.map2(mounted)).flatMap(tpl -> ((Seq)tpl._2()).map(m -> API.Tuple((Object)((ModelMethod)tpl._1()), m.withVia((ModelMethod)tpl._1())))).filter(tpl -> ((ModelMethod)tpl._1()).element().mountConfig().injected() || !((ModelMethod)tpl._2()).element().isAbstract()).filter(tpl -> ((ModelMethod)tpl._2()).element().name().equals(method.element().name())).filter(tpl -> ((ModelMethod)tpl._2()).element().canOverride(method.element(), (Adaptor)this.model.adaptor()));
        if (forwards.isEmpty()) {
            this.model.message(Message.unresolvedProvision(this.element, method.element()));
            return method;
        }
        if (forwards.size() > 1) {
            this.model.message(Message.conflictingProvisions(method.element().withSource(this.element.source()), forwards.map(tp -> ((ModelMethod)tp._2()).element())));
            return method;
        }
        return method.withVia((ModelMethod)((Tuple2)forwards.head())._1());
    }

    private void validateClassAnnotations() {
        if (!this.element.configs().exists(c -> c.type().featureRole()) && this.element.configs().exists(c -> !c.type().role())) {
            this.model.message(Message.meldAnnotationOutsideFeature(this.element()));
        }
    }

    private void validateDeclaredMethodAnnotations(ModelMethod<S, T> m) {
        if (!this.element.configs().exists(c -> c.type().featureRole()) && !m.element().configs().isEmpty()) {
            this.model.message(Message.meldAnnotationOutsideFeature(m.element()));
        }
        if (m.element().configs().count(c -> c.type().role()) > 1) {
            this.model.message(Message.conflictingCompositionRoles(m.element(), API.Seq()));
        }
    }

    private boolean validateObjectMethods(ModelMethod<S, T> m) {
        if (this.model.objectMethods().exists(om -> m.element().canOverride((CElement)om, (Adaptor)this.model.adaptor()))) {
            if (!m.element().configs().isEmpty()) {
                m.addMessage(this.model, Message.objectOverride(m.element()));
            }
            return false;
        }
        return true;
    }

    private boolean excludeStaticMethods(ModelMethod<S, T> m) {
        return !m.element().isStatic();
    }

    private boolean validateOverridableMethod(ModelMethod<S, T> m) {
        if (!m.element().isOverridable()) {
            m.addMessage(this.model, Message.nonOverridableMethod(m.element()));
        }
        return true;
    }

    private boolean validateConflictingSuperCompositionRoles(ModelMethod<S, T> m) {
        Seq conflicts = m.overrides().filter(s -> !s.element().configs().isEmpty()).filter(s -> !m.element().configs().map(ElementConfig::type).equals(s.element().configs().map(ElementConfig::type)));
        if (!conflicts.isEmpty()) {
            this.model.message(Message.conflictingOverride(m.element(), conflicts.map(ModelMethod::element)));
        }
        return true;
    }

    private boolean validateMethodAccessibility(CElement<S, T> nonLocalMsgTarget, ModelMethod<S, T> m, boolean forOverride) {
        if (m.element().parent().equals(this.element)) {
            m.overrides().forEach(s -> {
                if (!s.element().accessibleTo((Adaptor)this.model.adaptor(), m.element())) {
                    this.model.message(Message.methodNotAccessible(m.element(), s.element()));
                }
            });
        } else if (!(m.element().accessibleTo((Adaptor)this.model.adaptor(), (CElement)this.element) || forOverride && m.element().accessPolicy() == AccessPolicy.PROTECTED)) {
            this.model.message(Message.methodNotAccessible(nonLocalMsgTarget, m.element()));
        }
        return true;
    }

    private boolean validateProvisionOverrides(ModelMethod<S, T> m) {
        m.element().configs().filter(c -> c.type().annotationType().equals(Provision.class)).map(ProvisionConfig.class::cast).filter(c -> !c.shared() && !c.override()).headOption().forEach(__ -> m.overrides().filter(s -> s.element().configs().filter(c -> c.type().annotationType().equals(Provision.class)).map(ProvisionConfig.class::cast).exists(ProvisionConfig::shared)).headOption().forEach(s -> {
            if (m.element().parent().equals(this.element)) {
                this.model.message(Message.provisionOverrideMissing(m.element(), s.element()));
            } else {
                this.model.message(Message.conflictingProvisions(this.element, API.Seq((Object[])new CElement[]{m.element(), s.element()})));
            }
        }));
        return true;
    }

    private boolean validateNoParameters(ModelMethod<S, T> m) {
        if (!m.element().parameters().isEmpty()) {
            this.model.message(Message.noParametersAllowed(m.element()));
        }
        return true;
    }

    private boolean validateReferenceType(ModelMethod<S, T> m) {
        if (!this.model.adaptor().isReference(m.element().type())) {
            this.model.message(Message.mustReturnReference(m.element()));
        }
        return true;
    }

    private boolean validateAbstractMethodImplementable(CElement<S, T> classElem, ModelMethod<S, T> m) {
        if (!m.element().isAbstract()) {
            return true;
        }
        if (!m.element().configs().exists(c -> c.type().willImplement())) {
            if (classElem.equals(this.element)) {
                this.model.message(Message.abstractMethodWillNotBeImplemented(m.element(), m.element()));
            } else {
                this.model.message(Message.abstractMethodWillNotBeImplemented(classElem, m.element()));
            }
        }
        return true;
    }

    private Seq<Either<ModelMethod<S, T>, BuiltinArgument>> mapSetupParameters(ModelMethod<S, T> method) {
        return method.element().parameters().map(param -> {
            Vector candidates = Vector.ofAll((Iterable)this.model.configType().filter(t -> this.model.adaptor().isSubtypeOf(t, param.type())).map(__ -> BuiltinArgument.CONFIG.argument()));
            candidates = candidates.appendAll((Iterable)this.extensionPointMethods.filter(epp -> this.model.adaptor().isSubtypeOf(epp.element().type(), param.type())).map(Either::left));
            if ((candidates = candidates.appendAll((Iterable)this.mountMethods.map(m -> API.Tuple((Object)m, this.model.modelOf(m.element().type()).extensionPointMethods())).flatMap(tplViaEpp -> ((Seq)tplViaEpp._2()).map(m -> API.Tuple((Object)((ModelMethod)tplViaEpp._1()), (Object)m))).filter(tplViaEpp -> this.model.adaptor().isSubtypeOf(((ModelMethod)tplViaEpp._2()).element().type(), param.type())).map(tplViaEpp -> ((ModelMethod)tplViaEpp._2()).withVia((ModelMethod)tplViaEpp._1())).map(Either::left))).isEmpty()) {
                CElement epType = this.model.adaptor().classElement(param.type());
                this.model.message((Message)method.via().map(via -> Message.unresolvedExtensionPoint(via.element(), param, epType)).getOrElse(() -> method.element().parentOption().eq((Object)Option.of(this.element)) ? Message.unresolvedExtensionPoint(param, epType) : Message.unresolvedExtensionPoint(this.element, param, epType)));
                return BuiltinArgument.NONE.argument();
            }
            if (candidates.size() > 1) {
                this.model.message(Message.conflictingExtensionPoints(param, candidates.filter(Either::isLeft).map(c -> ((ModelMethod)c.getLeft()).element())));
                return BuiltinArgument.NONE.argument();
            }
            return (Either)candidates.head();
        });
    }

    private Seq<ModelMethod<S, T>> collectMounted(Function<ModelType<S, T>, Seq<ModelMethod<S, T>>> mounted) {
        return this.mountMethods.flatMap(mount -> ((Seq)mounted.apply(this.model.modelOf(mount.element().type()))).map(m -> m.withVia(mount))).filter(m -> {
            boolean callable;
            boolean bl = callable = m.element().accessibleTo((Adaptor)this.model.adaptor(), (CElement)this.element) || m.element().accessPolicy() == AccessPolicy.PROTECTED;
            if (!callable) {
                this.model.message(Message.methodNotAccessible(m.element(), this.element));
            }
            return callable;
        });
    }

    public Model<S, T> model() {
        return this.model;
    }

    public T type() {
        return this.type;
    }

    public CElement<S, T> element() {
        return this.element;
    }

    public Role role() {
        return this.role;
    }

    public Seq<ModelType<S, T>> superTypes() {
        return this.superTypes;
    }

    public Seq<ModelMethod<S, T>> allMethods() {
        return this.allMethods;
    }

    public Seq<ModelMethod<S, T>> provisionMethods() {
        return this.provisionMethods;
    }

    public Seq<ModelMethod<S, T>> extensionPointMethods() {
        return this.extensionPointMethods;
    }

    public Seq<ModelMethod<S, T>> mountMethods() {
        return this.mountMethods;
    }

    public Seq<ModelMethod<S, T>> setupMethods() {
        return this.setupMethods;
    }

    public Seq<ModelMethod<S, T>> parameterMethods() {
        return this.parameterMethods;
    }

    public String toString() {
        return "ModelType{type=" + this.type + "}";
    }

    public static enum Role {
        FEATURE,
        CONFIGURATION,
        EXTENSION_POINT_API,
        NONE;


        public boolean isFeature() {
            return this == FEATURE || this == CONFIGURATION;
        }

        public static Role ofElement(CElement<?, ?> element) {
            return (Role)((Object)element.configs().map(Role::ofConfig).filter(r -> r != NONE).singleOption().getOrElse((Object)NONE));
        }

        private static Role ofConfig(ElementConfig<?> c) {
            if (c.type().annotationType().equals(Feature.class)) {
                return FEATURE;
            }
            if (c.type().annotationType().equals(Configuration.class)) {
                return CONFIGURATION;
            }
            if (c.type().annotationType().equals(ExtensionPoint.Acceptor.class)) {
                return EXTENSION_POINT_API;
            }
            return NONE;
        }
    }
}

