/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.config.ConfigurationConfig;
import ch.raffael.meldioc.model.config.ElementConfig;
import ch.raffael.meldioc.model.config.ModelAnnotationType;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.API;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;

@Immutable.Public
abstract class _ConfigurationConfig<S>
extends ElementConfig<S> {
    public static final ModelAnnotationType TYPE = ModelAnnotationType.of(Configuration.class);
    public static final String MOUNT = "mount";
    public static final String SHELL_NAME = "shellName";
    public static final String PACKAGE_LOCAL = "packageLocal";

    _ConfigurationConfig() {
    }

    public static ConfigurationConfig<Configuration> of(Configuration annotation) {
        return ConfigurationConfig.builder().source(annotation).shellName(annotation.shellName()).packageLocal(annotation.packageLocal()).build();
    }

    public abstract Seq<ClassRef> mount();

    public abstract String shellName();

    public abstract boolean packageLocal();

    public ClassRef shellClassRef(String packageName, String simpleName) {
        String targetName = this.shellName().replace("*", simpleName);
        int pos = simpleName.lastIndexOf(46);
        if (pos >= 0) {
            return ClassRef.of(targetName.substring(0, pos), targetName.substring(pos + 1));
        }
        return ClassRef.of(packageName, targetName);
    }

    @Override
    public final ModelAnnotationType type() {
        return TYPE;
    }

    @Override
    public Map<String, Object> valueMap() {
        return API.Map((Object)SHELL_NAME, (Object)this.shellName(), (Object)PACKAGE_LOCAL, (Object)this.packageLocal());
    }
}

