/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.messages;

import ch.raffael.meldioc.model.messages.Message;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public interface MessageSink<S, T> {
    public void message(Message<S, T> var1);

    default public Tracker<S, T> tracker() {
        return new Tracker(this);
    }

    public static <S, T> UniqueWrapper<S, T> uniqueWrapper(MessageSink<S, T> delegate) {
        return new UniqueWrapper<S, T>(delegate);
    }

    public static final class Tracker<S, T>
    implements MessageSink<S, T> {
        private final MessageSink<S, T> delegate;
        private boolean hasErrors = false;

        public Tracker(MessageSink<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void message(Message<S, T> message) {
            this.hasErrors = true;
            this.delegate.message(message);
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public boolean ok() {
            return !this.hasErrors;
        }
    }

    public static final class UniqueWrapper<S, T>
    implements MessageSink<S, T> {
        private final Set<Message<S, T>> seen = new ConcurrentHashMap(4, 0.7f, 1).keySet(true);
        private final MessageSink<S, T> delegate;

        public UniqueWrapper(MessageSink<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void message(Message<S, T> message) {
            if (this.seen.add(message)) {
                this.delegate.message(message);
            }
        }
    }
}

