/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.Adaptor;
import ch.raffael.meldioc.model.CElement;
import ch.raffael.meldioc.model.InconsistentModelException;
import ch.raffael.meldioc.model.config.ConfigurationConfig;
import ch.raffael.meldioc.model.config.ElementConfig;
import ch.raffael.meldioc.model.config.ExtensionPointAcceptorConfig;
import ch.raffael.meldioc.model.config.ExtensionPointConfig;
import ch.raffael.meldioc.model.config.FeatureConfig;
import ch.raffael.meldioc.model.config.MountConfig;
import ch.raffael.meldioc.model.config.ParameterConfig;
import ch.raffael.meldioc.model.config.ParameterPrefixConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.model.config.SetupConfig;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Immutable.Public
abstract class _CElement<S, T> {
    public static final String CONSTRUCTOR_NAME = "<init>";
    private static final Object PSEUDO_SOURCE = new Object();

    _CElement() {
    }

    public abstract Kind kind();

    public abstract String name();

    public abstract T type();

    public abstract S source();

    public CElement<S, T> parent() {
        return (CElement)this.parentOption().getOrElseThrow(() -> new InconsistentModelException("Element " + this + " has no parent", this));
    }

    @Value.Default
    public boolean synthetic() {
        return false;
    }

    public abstract Option<CElement<S, T>> parentOption();

    @Value.Redacted
    public abstract AccessPolicy accessPolicy();

    @Value.Redacted
    public abstract boolean isStatic();

    @Value.Redacted
    public abstract boolean isFinal();

    @Value.Redacted
    public abstract boolean isAbstract();

    public boolean isOverridable() {
        return !this.isFinal() && !this.isStatic() && this.accessPolicy() != AccessPolicy.PRIVATE;
    }

    @Value.Redacted
    abstract Seq<CElement<S, T>> parameters();

    @Value.Redacted
    public abstract Set<ElementConfig<S>> configs();

    public Option<CElement<S, T>> findClass() {
        Option e = Option.some((Object)((CElement)this));
        while (e.isDefined() && ((CElement)e.get()).kind() != Kind.CLASS) {
            e = ((CElement)e.get()).parentOption();
        }
        return e;
    }

    public CElement<S, T> findOutermost() {
        CElement p = (CElement)this;
        while (p.parentOption().isDefined()) {
            p = p.parent();
        }
        return p;
    }

    public boolean accessibleTo(Adaptor<S, T> adaptor, CElement<S, T> that) {
        if (this.kind() == Kind.PARAMETER || that.kind() == Kind.PARAMETER) {
            return false;
        }
        if (this.accessPolicy() == AccessPolicy.PUBLIC) {
            return true;
        }
        CElement thisClass = (CElement)this.findClass().getOrNull();
        if (thisClass == null) {
            return false;
        }
        CElement thatClass = (CElement)that.findClass().getOrNull();
        if (thatClass == null) {
            return false;
        }
        if (thisClass.equals(thatClass)) {
            return true;
        }
        if ((this.accessPolicy() == AccessPolicy.LOCAL || this.accessPolicy() == AccessPolicy.PROTECTED) && adaptor.packageOf(thisClass).equals(adaptor.packageOf(thatClass))) {
            return true;
        }
        if (this.accessPolicy() == AccessPolicy.PROTECTED) {
            return adaptor.isSubtypeOf(thatClass.type(), thisClass.type());
        }
        return false;
    }

    public boolean canOverride(CElement<S, T> that, Adaptor<S, T> adaptor) {
        if (this.kind() != Kind.METHOD || that.kind() != Kind.METHOD) {
            return false;
        }
        if (!this.methodSignature().equals(that.methodSignature())) {
            return false;
        }
        return adaptor.isSubtypeOf(this.type(), that.type());
    }

    @Value.Lazy
    public Tuple2<String, Seq<CElement<?, T>>> methodSignature() {
        return Tuple.of((Object)this.name(), (Object)this.parameters().zipWithIndex().map(tpl -> tpl.map1(p -> p.withoutSource().withName("arg" + tpl._2))).map(Tuple2::_1));
    }

    public CElement<?, T> withoutSource() {
        return ((CElement)this).withSource(PSEUDO_SOURCE);
    }

    public <ES extends S> ES source(Class<ES> type) throws InconsistentModelException {
        try {
            return type.cast(this.source());
        }
        catch (ClassCastException e) {
            throw new InconsistentModelException("Source of type " + type.getName() + " expected", this, (Throwable)e);
        }
    }

    public <ET extends T> ET type(Class<ET> type) throws InconsistentModelException {
        try {
            return type.cast(this.type());
        }
        catch (ClassCastException e) {
            throw new InconsistentModelException("Type reference of type " + type.getName() + " expected", this, (Throwable)e);
        }
    }

    public boolean isInnerClass() {
        if (((_CElement)this).kind() != Kind.CLASS) {
            return false;
        }
        CElement<S, T> c = this;
        while (((_CElement)c).parentOption().isDefined()) {
            if (((_CElement)c).parent().kind() != Kind.CLASS) {
                return true;
            }
            if (!((_CElement)c).isStatic()) {
                return true;
            }
            c = ((_CElement)c).parent();
        }
        return false;
    }

    public CElement<S, T> narrow(Kind kind) {
        if (this.kind() != kind) {
            throw new InconsistentModelException("Expected kind " + kind + ", actual kind is " + this.kind(), this);
        }
        return (CElement)this;
    }

    public <ES extends S, ET extends T> CElement<ES, ET> narrow(@Nullable Class<ES> sourceType, @Nullable Class<ET> typeType) {
        return this.narrow(null, sourceType, typeType);
    }

    public <ES extends S, ET extends T> CElement<ES, ET> narrow(@Nullable Kind kind, @Nullable Class<ES> sourceType, @Nullable Class<ET> typeType) {
        if (kind != null && this.kind() != kind) {
            throw new InconsistentModelException("Expected kind " + kind + ", actual kind is " + this.kind(), this);
        }
        if (sourceType != null) {
            this.source(sourceType);
        }
        if (typeType != null) {
            this.type(typeType);
        }
        return (CElement)this;
    }

    public CElement<Option.None<Void>, Option.None<Void>> detach() {
        return CElement.builder().from(this).source(_CElement.voidNone()).type(_CElement.voidNone()).parent(this.parentOption().map(_CElement::detach)).parameters(this.parameters().map(_CElement::detach)).build();
    }

    public ConfigurationConfig<S> configurationConfig() {
        return this.requireConfig(this.configurationConfigOption(), Configuration.class);
    }

    public Option<ConfigurationConfig<S>> configurationConfigOption() {
        return this.configs().find(ConfigurationConfig.class::isInstance).map(ConfigurationConfig.class::cast);
    }

    public SetupConfig<S> setupConfig() {
        return this.requireConfig(this.setupConfigOption(), Setup.class);
    }

    public Option<SetupConfig<S>> setupConfigOption() {
        return this.configs().find(SetupConfig.class::isInstance).map(SetupConfig.class::cast);
    }

    public ParameterConfig<S> parameterConfig() {
        return this.requireConfig(this.parameterConfigOption(), Parameter.class);
    }

    public Option<ParameterConfig<S>> parameterConfigOption() {
        return this.configs().find(ParameterConfig.class::isInstance).map(ParameterConfig.class::cast);
    }

    public ParameterPrefixConfig<S> parameterPrefixConfig() {
        return this.requireConfig(this.parameterPrefixConfigOption(), Parameter.Prefix.class);
    }

    public Option<ParameterPrefixConfig<S>> parameterPrefixConfigOption() {
        return this.configs().find(ParameterPrefixConfig.class::isInstance).map(ParameterPrefixConfig.class::cast);
    }

    public ExtensionPointAcceptorConfig<S> extensionPointAcceptorConfig() {
        return this.requireConfig(this.extensionPointAcceptorConfigOption(), ExtensionPoint.Acceptor.class);
    }

    public Option<ExtensionPointAcceptorConfig<S>> extensionPointAcceptorConfigOption() {
        return this.configs().find(ExtensionPointAcceptorConfig.class::isInstance).map(ExtensionPointAcceptorConfig.class::cast);
    }

    public ExtensionPointConfig<S> extensionPointConfig() {
        return this.requireConfig(this.extensionPointConfigOption(), ExtensionPoint.class);
    }

    public Option<ExtensionPointConfig<S>> extensionPointConfigOption() {
        return this.configs().find(ExtensionPointConfig.class::isInstance).map(ExtensionPointConfig.class::cast);
    }

    public FeatureConfig<S> featureConfig() {
        return this.requireConfig(this.featureConfigOption(), Feature.class);
    }

    public Option<FeatureConfig<S>> featureConfigOption() {
        return this.configs().find(FeatureConfig.class::isInstance).map(FeatureConfig.class::cast);
    }

    public MountConfig<S> mountConfig() {
        return this.requireConfig(this.mountConfigOption(), Feature.Mount.class);
    }

    public Option<MountConfig<S>> mountConfigOption() {
        return this.configs().find(MountConfig.class::isInstance).map(MountConfig.class::cast);
    }

    public ProvisionConfig<S> provisionConfig() {
        return this.requireConfig(this.provisionConfigOption(), Provision.class);
    }

    public Option<ProvisionConfig<S>> provisionConfigOption() {
        return this.configs().find(ProvisionConfig.class::isInstance).map(ProvisionConfig.class::cast);
    }

    private <C> C requireConfig(Option<C> option, Class<? extends Annotation> type) {
        return (C)option.getOrElseThrow(() -> new InconsistentModelException("Expected configuration of type @" + type.getName() + "not present", this));
    }

    @Value.Check
    void verify() {
        this.kind().verify(this);
    }

    private static Option.None<Void> voidNone() {
        return (Option.None)Option.none();
    }

    static abstract class Builder<S, T> {
        Builder() {
        }

        public CElement.Builder<S, T> parent(CElement<S, T> parent) {
            return this.parentOption(parent);
        }

        public CElement.Builder<S, T> parent(Option<CElement<S, T>> parent) {
            return this.parentOption(parent);
        }

        public abstract CElement.Builder<S, T> parentOption(Option<CElement<S, T>> var1);

        public abstract CElement.Builder<S, T> parentOption(CElement<S, T> var1);
    }

    public static enum Kind {
        CLASS{

            @Override
            public void verify(_CElement<?, ?> element) {
                super.verify(element);
                1.verifyOptionalParent(element, CLASS);
                1.verifyNoParameters(element);
            }
        }
        ,
        METHOD{

            @Override
            public void verify(_CElement<?, ?> element) {
                super.verify(element);
                2.verifyParent(element, CLASS);
            }
        }
        ,
        PARAMETER{

            @Override
            public void verify(_CElement<?, ?> element) {
                super.verify(element);
                3.verifyNoParameters(element);
                if (element.parentOption().isDefined()) {
                    throw new InconsistentModelException("Method parameters must not have a parent", element);
                }
            }
        };


        void verify(_CElement<?, ?> element) {
            element.narrow(this);
        }

        static void verifyNoParameters(_CElement<?, ?> element) {
            if (!element.parameters().isEmpty()) {
                throw new InconsistentModelException("Elements of kind " + element.kind() + " cannot have parameters", element);
            }
        }

        static void verifyOptionalParent(_CElement<?, ?> element, Kind kind) {
            element.parentOption().forEach(p -> {
                if (p.kind() != kind) {
                    throw new InconsistentModelException("Parent of kind " + p.kind() + " must be a " + kind, element);
                }
            });
        }

        static void verifyParent(_CElement<?, ?> element, Kind kind) {
            if (element.parentOption().isEmpty()) {
                throw new InconsistentModelException("Elements of kind " + element.kind() + " must have a parent", element);
            }
            Kind.verifyOptionalParent(element, kind);
        }
    }
}

