/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.config.AnnotationAttribute;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;

@Immutable.Public
abstract class _AnnotationAttribute {
    _AnnotationAttribute() {
    }

    static Map<String, AnnotationAttribute> allOf(Class<? extends Annotation> type) {
        return (Map)Stream.of(type.getDeclaredMethods()).filter(m -> !m.isSynthetic()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(_AnnotationAttribute::of).collect(LinkedHashMap.collector(AnnotationAttribute::name));
    }

    static AnnotationAttribute of(Method method) {
        Object def;
        Class<Object> type;
        boolean isArray = method.getReturnType().isArray();
        Class<?> clazz = type = isArray ? method.getReturnType().getComponentType() : method.getReturnType();
        if (Class.class.isAssignableFrom(type)) {
            type = ClassRef.class;
        }
        if ((def = method.getDefaultValue()) instanceof Class) {
            def = ClassRef.of((Class)def);
        }
        return AnnotationAttribute.builder().name(method.getName()).valueType(isArray ? Array.newInstance(type, 0).getClass() : type).defaultValue((Option<Object>)Option.of((Object)def)).build();
    }

    public abstract String name();

    public abstract Class<?> valueType();

    public abstract Option<Object> defaultValue();
}

