/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.model.Adaptor;
import ch.raffael.meldioc.model.CElement;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.ConfigRef;
import ch.raffael.meldioc.model.InconsistentModelException;
import ch.raffael.meldioc.model.ModelType;
import ch.raffael.meldioc.model._CElement;
import ch.raffael.meldioc.model._ClassRef;
import ch.raffael.meldioc.model.messages.Message;
import ch.raffael.meldioc.model.messages.MessageSink;
import io.vavr.collection.HashMap;
import io.vavr.collection.HashSet;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import javax.annotation.Nullable;

public final class Model<S, T>
implements MessageSink<S, T> {
    private static final Seq<ConfigRef<ClassRef>> STANDARD_CONFIG_REFS = List.of((Object[])new ConfigRef[]{ConfigRef.of(_ClassRef.Primitives.INT, "getInt"), ConfigRef.of(_ClassRef.Primitives.LONG, "getLong"), ConfigRef.of(_ClassRef.Primitives.DOUBLE, "getDouble"), ConfigRef.of(_ClassRef.Primitives.BOOLEAN, "getBoolean"), ConfigRef.of(_ClassRef.Lang.INTEGER, "getInt"), ConfigRef.of(_ClassRef.Lang.LONG, "getLong"), ConfigRef.of(_ClassRef.Lang.DOUBLE, "getDouble"), ConfigRef.of(_ClassRef.Lang.BOOLEAN, "getBoolean"), ConfigRef.of(_ClassRef.Lang.NUMBER, "getNumber"), ConfigRef.of(_ClassRef.Lang.STRING, "getString"), ConfigRef.of(_ClassRef.Lang.CHAR_SEQUENCE, "getString"), ConfigRef.of(ClassRef.of("java.time", "Duration"), "getDuration"), ConfigRef.of(ClassRef.of("java.time", "Period"), "getPeriod"), ConfigRef.of(ClassRef.of("java.time.temporal", "TemporalAmount"), "getTemporal"), ConfigRef.of(ClassRef.of("com.typesafe.config", "Config"), "getConfig"), ConfigRef.of(ClassRef.of("com.typesafe.config", "ConfigMemorySize"), "getMemorySize")});
    private static final ClassRef CONFIG_REF = ClassRef.of("com.typesafe.config", "Config");
    private final Adaptor<S, T> adaptor;
    private final MessageSink<S, T> messages;
    private HashMap<T, Entry<S, T>> pool = HashMap.empty();
    private final T objectType;
    private final T enumType;
    private final T runtimeExceptionType;
    private final T errorType;
    private final Seq<CElement<S, T>> objectMethods;
    private final Seq<ConfigRef<T>> configSupportedTypes;
    private final Option<T> configType;

    private Model(Adaptor<S, T> adaptor, MessageSink<S, T> messages) {
        this.adaptor = adaptor;
        this.messages = MessageSink.uniqueWrapper(messages);
        this.objectType = adaptor.typeOf(_ClassRef.Lang.OBJECT);
        this.runtimeExceptionType = adaptor.typeOf(_ClassRef.Lang.RUNTIME_EXCEPTION);
        this.errorType = adaptor.typeOf(_ClassRef.Lang.ERROR);
        this.objectMethods = this.adaptor.declaredMethods(this.objectType).map(m -> m.narrow(_CElement.Kind.METHOD)).map(m -> m.withConfigs(HashSet.empty()));
        this.enumType = adaptor.typeOf(_ClassRef.Lang.ENUM);
        this.configSupportedTypes = STANDARD_CONFIG_REFS.map(cr -> ConfigRef.of(adaptor.typeOf((ClassRef)cr.type()), cr.configMethodName())).filter(cr -> !adaptor.isNoType(cr.type())).flatMap(cr -> adaptor.isReference(cr.type()) ? List.of((Object[])new ConfigRef[]{cr.withType(adaptor.listOf(cr.type())), cr.withType(adaptor.collectionOf(cr.type())), cr.withType(adaptor.iterableOf(cr.type()))}).flatMap(Model::mapConfigListRef).append(cr) : List.of((Object)cr)).filter(cr -> !adaptor.isNoType(cr.type()));
        this.configType = Option.some(adaptor.typeOf(CONFIG_REF)).filter(adaptor::isReference);
    }

    private static <T> Option<ConfigRef<T>> mapConfigListRef(ConfigRef<T> ref) {
        ConfigRef<T> listRef = ref.withConfigMethodName(ref.configMethodName() + "List");
        switch (listRef.configMethodName()) {
            case "getConfigList": 
            case "getPeriodList": 
            case "getTemporalList": {
                return Option.none();
            }
        }
        return Option.some(listRef);
    }

    public static <S, T> Model<S, T> create(Adaptor<S, T> adaptor, MessageSink<S, T> messages) {
        return new Model<S, T>(adaptor, messages);
    }

    public static <S, T, A extends Adaptor<S, T> & MessageSink<S, T>> Model<S, T> create(A adaptor) {
        return Model.create(adaptor, adaptor);
    }

    public ModelType<S, T> modelOf(T type) {
        return (ModelType)this.pool.computeIfAbsent(type, e -> new Entry()).apply((e, m) -> {
            Entry entry = e;
            synchronized (entry) {
                this.pool = m;
                if (e.model == null) {
                    if (e.initializing) {
                        throw new IllegalStateException("Model initialization recursion detected on type " + type);
                    }
                    e.initializing = true;
                    try {
                        e.model = new ModelType(this, type);
                    }
                    finally {
                        e.initializing = false;
                    }
                }
                return e.model;
            }
        });
    }

    public Adaptor<S, T> adaptor() {
        return this.adaptor;
    }

    public T objectType() {
        return this.objectType;
    }

    public T enumType() {
        return this.enumType;
    }

    public T runtimeExceptionType() {
        return this.runtimeExceptionType;
    }

    public T errorType() {
        return this.errorType;
    }

    public Seq<CElement<S, T>> objectMethods() {
        return this.objectMethods;
    }

    public Option<ConfigRef<T>> configSupportedTypeOption(T type) {
        if (this.adaptor.isEnumType(type)) {
            return Option.some(ConfigRef.of(type, "getEnum").withTargetTypeArgument(type));
        }
        if (this.objectType.equals(type)) {
            return Option.none();
        }
        T componentType = this.adaptor.componentTypeOfIterable(type);
        if (this.adaptor.isEnumType(componentType) && (this.adaptor.isSubtypeOf(type, this.adaptor.listOf(componentType)) || this.adaptor.isSubtypeOf(type, this.adaptor.collectionOf(componentType)) || this.adaptor.isSubtypeOf(type, this.adaptor.iterableOf(componentType)))) {
            return Option.some(ConfigRef.of(componentType, "getEnumList").withTargetTypeArgument(componentType));
        }
        return this.configSupportedTypes.filter(t -> this.adaptor.isSubtypeOf(t.type(), type)).headOption();
    }

    public ConfigRef<T> configSupportedType(CElement<S, T> element) {
        return (ConfigRef)this.configSupportedTypeOption(element.type()).getOrElseThrow(() -> new InconsistentModelException("Configuration supported type expected", element));
    }

    public Option<T> configType() {
        return this.configType;
    }

    @Override
    public void message(Message<S, T> message) {
        this.messages.message(message);
    }

    private static final class Entry<S, T> {
        private boolean initializing = false;
        @Nullable
        private ModelType<S, T> model;

        private Entry() {
        }
    }
}

