/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.config.AnnotationAttribute;
import ch.raffael.meldioc.model.config.ModelAnnotationType;
import ch.raffael.meldioc.model.config._AnnotationAttribute;
import ch.raffael.meldioc.util.immutables.IllegalBuilderStateException;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Immutable.Public
abstract class _ModelAnnotationType {
    private static final Lazy<Map<Class<? extends Annotation>, ModelAnnotationType>> ALL_MAP = Lazy.of(() -> List.of((Object[])new Tuple2[]{_ModelAnnotationType.mapEntry(Provision.class, b -> b.onMethod().willImplement().willDecorate()), _ModelAnnotationType.mapEntry(ExtensionPoint.Acceptor.class, b -> b.onClass().auxiliaryRole()), _ModelAnnotationType.mapEntry(ExtensionPoint.class, b -> b.onMethod().willDecorate()), _ModelAnnotationType.mapEntry(Parameter.class, b -> b.onMethod().willImplement().willDecorate()), _ModelAnnotationType.mapEntry(Parameter.Prefix.class, b -> b.onClass().modifier()), _ModelAnnotationType.mapEntry(Setup.class, b -> b.onMethod().supportsParameters()), _ModelAnnotationType.mapEntry(Feature.Mount.class, b -> b.onMethod().willImplement()), _ModelAnnotationType.mapEntry(Feature.class, b -> b.onClass().featureRole().willImplement().willDecorate()), _ModelAnnotationType.mapEntry(Configuration.class, b -> b.onClass().featureRole().willImplement().willDecorate()), _ModelAnnotationType.mapEntry(Feature.DependsOn.class, b -> b.modifier().onImplements())}).toMap(t -> t));
    private static final Lazy<Set<ModelAnnotationType>> ALL = Lazy.of(() -> LinkedHashSet.ofAll((Iterable)((Map)ALL_MAP.get()).values()));

    _ModelAnnotationType() {
    }

    private static <T extends Annotation> Tuple2<Class<T>, ModelAnnotationType> mapEntry(Class<T> annotationType, Consumer<? super ModelAnnotationType.Builder> conf) {
        ModelAnnotationType.Builder builder = ModelAnnotationType.builder().annotationType(annotationType);
        conf.accept(builder);
        return Tuple.of(annotationType, (Object)builder.build());
    }

    public static Set<ModelAnnotationType> all() {
        return (Set)ALL.get();
    }

    public static <A extends Annotation> ModelAnnotationType of(Class<A> annotationType) {
        return (ModelAnnotationType)((Map)ALL_MAP.get()).get(annotationType).getOrElseThrow(() -> new IllegalArgumentException("Not a model annotation type: " + annotationType));
    }

    public abstract Class<? extends Annotation> annotationType();

    @Value.Lazy
    @Value.Auxiliary
    public Map<String, AnnotationAttribute> attributes() {
        return _AnnotationAttribute.allOf(this.annotationType());
    }

    @Value.Derived
    @Value.Auxiliary
    public String displayName() {
        return "@" + this.annotationType().getSimpleName();
    }

    @Value.Default
    public boolean role() {
        return true;
    }

    public boolean modifier() {
        return !this.role();
    }

    @Value.Default
    public boolean auxiliaryRole() {
        return false;
    }

    @Value.Default
    public boolean featureRole() {
        return false;
    }

    @Value.Default
    public boolean onMethod() {
        return false;
    }

    @Value.Default
    public boolean onClass() {
        return false;
    }

    @Value.Default
    public boolean onInterface() {
        return this.onClass();
    }

    @Value.Default
    public boolean onImplements() {
        return false;
    }

    @Value.Default
    public boolean supportsParameters() {
        return false;
    }

    @Value.Default
    public boolean willDecorate() {
        return false;
    }

    @Value.Default
    public boolean willImplement() {
        return false;
    }

    @Value.Check
    void check() {
        if (this.featureRole() && !this.role()) {
            throw new IllegalBuilderStateException("featureRole but not role");
        }
        if (this.auxiliaryRole() && !this.role()) {
            throw new IllegalBuilderStateException("auxiliary role but not role");
        }
    }

    static abstract class Builder {
        Builder() {
        }

        public ModelAnnotationType.Builder modifier() {
            return this.self().role(false);
        }

        public ModelAnnotationType.Builder auxiliaryRole() {
            return this.self().auxiliaryRole(true);
        }

        public ModelAnnotationType.Builder featureRole() {
            return this.self().featureRole(true);
        }

        public ModelAnnotationType.Builder onMethod() {
            return this.self().onMethod(true);
        }

        public ModelAnnotationType.Builder onClass() {
            return this.self().onClass(true);
        }

        public ModelAnnotationType.Builder onInterface() {
            return this.self().onInterface(true);
        }

        public ModelAnnotationType.Builder onImplements() {
            return this.self().onImplements(true);
        }

        public ModelAnnotationType.Builder supportsParameters() {
            return this.self().supportsParameters(true);
        }

        public ModelAnnotationType.Builder willDecorate() {
            return this.self().willDecorate(true);
        }

        public ModelAnnotationType.Builder willImplement() {
            return this.self().willImplement(true);
        }

        private ModelAnnotationType.Builder self() {
            return (ModelAnnotationType.Builder)this;
        }
    }
}

