/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.messages;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.model.CElement;
import ch.raffael.meldioc.model._CElement;
import ch.raffael.meldioc.model.messages.SimpleMessage;
import ch.raffael.meldioc.util.Strings;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Message<S, T> {
    public static final Map<String, Function<? super CElement<?, ?>, String>> RENDER_ATTRIBUTE_EXTRACTORS = HashMap.of((Object)"name", CElement::name, (Object)"kind", e -> e.kind().name().toLowerCase(), (Object)"Kind", e -> Strings.capitalize((CharSequence)e.kind().name().toLowerCase()));
    public static final Pattern RENDER_SUBSTITUTION_RE = Pattern.compile("\\{(?<idx>\\d+)(:(?<attr>\\w+))?}");

    public Option<Id> id();

    public CElement<S, T> element();

    public Seq<Message<S, T>> origins();

    public String message();

    public Seq<CElement<S, T>> conflicts();

    public boolean languageError();

    default public String renderMessage(Function<? super S, ? extends CharSequence> elementRenderer) {
        return Message.defaultRenderMessage(this, elementRenderer);
    }

    public static <S, T> SimpleMessage<S, T> conflictingCompositionRoles(CElement<S, T> element, Seq<CElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingCompositionRoles, element, "Conflicting composition roles", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> conflictingOverride(CElement<S, T> element, Seq<CElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingOverride, element, "Composition roles in conflict with inherited roles", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> objectOverride(CElement<S, T> element) {
        return SimpleMessage.of(Id.ObjectOverride, element, "Standard Object methods cannot be used for composition");
    }

    public static <S, T> SimpleMessage<S, T> nonOverridableMethod(CElement<S, T> element) {
        return SimpleMessage.of(Id.NonOverridableMethod, element, "Composition methods cannot be final, native or static or private");
    }

    public static <S, T> SimpleMessage<S, T> provisionOverrideMissing(CElement<S, T> element, CElement<S, T> conflict) {
        return SimpleMessage.of(Id.ProvisionOverrideMissing, element, "Non-singleton provision overriding singleton provision must specify override=true (overrides {1})", conflict);
    }

    public static <S, T> SimpleMessage<S, T> unresolvedProvision(CElement<S, T> element, CElement<S, T> conflict) {
        return SimpleMessage.of(Id.UnresolvedProvision, element, "Unresolved provision '{1:name}'", conflict);
    }

    public static <S, T> SimpleMessage<S, T> conflictingProvisions(CElement<S, T> element, Seq<CElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingProvisions, element, "Conflicting provisions for '{1:name}'", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> elementNotAccessible(CElement<S, T> element, CElement<S, T> conflict) {
        if (!element.equals(conflict)) {
            return SimpleMessage.of(Id.ElementNotAccessible, element, "{1:Kind} {1:name} not accessible", conflict);
        }
        return SimpleMessage.of(Id.ElementNotAccessible, element, "{1:Kind} not accessible", conflict);
    }

    public static <S, T> SimpleMessage<S, T> abstractMethodWillNotBeImplemented(CElement<S, T> element, CElement<S, T> conflict) {
        return SimpleMessage.of(Id.AbstractMethodWillNotBeImplemented, element, "Abstract method {1} will not be implemented by the configuration", conflict);
    }

    public static <S, T> SimpleMessage<S, T> noParametersAllowed(CElement<S, T> element) {
        return SimpleMessage.of(Id.NoParametersAllowed, element, "Method must not take any parameters");
    }

    public static <S, T> SimpleMessage<S, T> mustReturnReference(CElement<S, T> element) {
        return SimpleMessage.of(Id.MustReturnReference, element, "Method must return a reference type");
    }

    public static <S, T> SimpleMessage<S, T> mountMethodMustBeAbstract(CElement<S, T> element) {
        return SimpleMessage.of(Id.MountMethodMustBeAbstract, element, "Mount methods must be abstract");
    }

    public static <S, T> SimpleMessage<S, T> mountMethodsAllowedInConfigurationsOnly(CElement<S, T> element) {
        return SimpleMessage.of(Id.MountMethodsAllowedInConfigurationsOnly, element, "Mount methods are allowed in configurations only");
    }

    public static <S, T> SimpleMessage<S, T> mountMethodMustReturnFeature(CElement<S, T> element, CElement<S, T> conflict) {
        return SimpleMessage.of(Id.MountMethodMustReturnFeature, element, "Mount methods must return a @" + Feature.class.getSimpleName() + " or @" + Configuration.class.getSimpleName(), conflict);
    }

    public static <S, T> SimpleMessage<S, T> mountAttributeClassMustNotBeParametrized(CElement<S, T> element, CElement<S, T> conflict) {
        return SimpleMessage.of(Id.MountAttributeClassMustNotBeParametrized, element, "Mounted class '{1:name}' must not be parametrized", conflict);
    }

    public static <S, T> SimpleMessage<S, T> mountedAbstractProvisionHasNoImplementationCandidate(CElement<S, T> mountMethod, CElement<S, T> provisionMethod) {
        return SimpleMessage.of(Id.MountedAbstractProvisionHasNoImplementationCandidate, mountMethod, "Mounted abstract provision '{1:name}' has no implementation candidate", provisionMethod);
    }

    public static <S, T> SimpleMessage<S, T> missingNoArgsConstructor(CElement<S, T> type) {
        return Message.missingNoArgsConstructor(type, type);
    }

    public static <S, T> SimpleMessage<S, T> missingNoArgsConstructor(CElement<S, T> elem, CElement<S, T> type) {
        if (elem.kind() == _CElement.Kind.METHOD) {
            return SimpleMessage.of(Id.MissingNoArgsConstructor, elem, "Illegal return type: class has no accessible no-arg constructor", type);
        }
        return SimpleMessage.of(Id.MissingNoArgsConstructor, elem, "Class has no accessible no-arg constructor", type);
    }

    public static <S, T> SimpleMessage<S, T> illegalInnerClass(CElement<S, T> type) {
        return Message.illegalInnerClass(type, type);
    }

    public static <S, T> SimpleMessage<S, T> illegalInnerClass(CElement<S, T> elem, CElement<S, T> type) {
        if (elem.kind() == _CElement.Kind.METHOD) {
            return SimpleMessage.of(Id.IllegalInnerClass, elem, "Illegal return type: features and configurations must be top-level or nested classes");
        }
        return SimpleMessage.of(Id.IllegalInnerClass, elem, "Illegal inner class: features and configurations must be top-level or nested classes");
    }

    public static <S, T> SimpleMessage<S, T> extensionPointAcceptorReturnRecommended(CElement<S, T> element, CElement<S, T> conflict) {
        return SimpleMessage.of(Id.ExtensionPointAcceptorReturnRecommended, element, "Extension point provisions should return a type annotated with @" + ExtensionPoint.class.getSimpleName() + "." + ExtensionPoint.Acceptor.class.getSimpleName(), conflict);
    }

    public static <S, T> SimpleMessage<S, T> returnValueIgnored(CElement<S, T> element) {
        return SimpleMessage.of(Id.ReturnValueIgnored, element, "Return value ignored");
    }

    public static <S, T> SimpleMessage<S, T> meldAnnotationOutsideFeature(CElement<S, T> element) {
        return SimpleMessage.of(Id.MeldAnnotationOutsideFeature, element, "Meld annotation outside feature");
    }

    public static <S, T> SimpleMessage<S, T> typesafeConfigNotOnClasspath(CElement<S, T> element) {
        return SimpleMessage.of(Id.TypesafeConfigNotOnClasspath, element, "Typesafe config is not on classpath, configuration not supported");
    }

    public static <S, T> SimpleMessage<S, T> configTypeNotSupported(CElement<S, T> element) {
        return SimpleMessage.of(Id.ConfigTypeNotSupported, element, "Type not supported for configuration");
    }

    public static <S, T> SimpleMessage<S, T> unresolvedExtensionPoint(CElement<S, T> epConsumer, CElement<S, T> epType) {
        return SimpleMessage.of(Id.UnresolvedExtensionPoint, epConsumer, "Unresolved extension point {1}", epType);
    }

    public static <S, T> SimpleMessage<S, T> unresolvedExtensionPoint(CElement<S, T> source, CElement<S, T> epConsumer, CElement<S, T> epType) {
        SimpleMessage<S, T> origin = Message.unresolvedExtensionPoint(epConsumer, epType);
        origin = origin.withMessage(origin.message());
        return Message.unresolvedExtensionPoint(source, epType).withOrigins((Seq<Message<S, T>>)List.of(origin));
    }

    public static <S, T> SimpleMessage<S, T> conflictingExtensionPoints(CElement<S, T> element, Seq<CElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingExtensionPoints, element, "Conflicting extension points", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> incompatibleThrowsClause(CElement<S, T> element, CElement<S, T> provision, CElement<S, T> exception) {
        return SimpleMessage.of(Id.IncompatibleThrowsClause, element, "Incompatible throws clause for provision {1}, implementing method throws {2}", provision, exception);
    }

    public static <S, T> SimpleMessage<S, T> missingFeatureImportAnnotation(CElement<S, T> element, CElement<S, T> superType) {
        return SimpleMessage.of(Id.MissingFeatureImportAnnotation, element, "Class extends/implements non-feature class {1} without `@Feature.Import` annotation\nTHIS WILL BE AN ERROR IN THE NEXT MAJOR RELEASE", superType);
    }

    public static <S, T> String defaultRenderMessage(Message<S, T> msg, Function<? super S, ? extends CharSequence> elementRenderer) {
        Seq args = msg.conflicts().prepend(msg.element());
        StringBuffer result = new StringBuffer();
        Matcher matcher = RENDER_SUBSTITUTION_RE.matcher(msg.message());
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group("idx"));
            Option element = index < args.length() ? Option.some((Object)((CElement)args.get(index))) : Option.none();
            String attr = matcher.group("attr");
            if (attr == null) {
                matcher.appendReplacement(result, (String)element.map(CElement::source).map(elementRenderer).map(Object::toString).getOrElse((Object)("<?" + matcher.group() + ">")));
                continue;
            }
            matcher.appendReplacement(result, (String)element.flatMap(e -> RENDER_ATTRIBUTE_EXTRACTORS.get((Object)attr).map(f -> (String)f.apply(e))).getOrElse(() -> "<?" + matcher.group() + ">"));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static enum Id {
        ConflictingCompositionRoles,
        ConflictingOverride,
        ObjectOverride,
        NonOverridableMethod,
        ProvisionOverrideMissing,
        UnresolvedProvision,
        ConflictingProvisions,
        ElementNotAccessible,
        AbstractMethodWillNotBeImplemented,
        NoParametersAllowed,
        MustReturnReference,
        MountMethodMustBeAbstract,
        MountMethodsAllowedInConfigurationsOnly,
        MountMethodMustReturnFeature,
        MountAttributeClassMustNotBeParametrized,
        MountedAbstractProvisionHasNoImplementationCandidate,
        MissingNoArgsConstructor,
        IllegalInnerClass,
        TypesafeConfigNotOnClasspath,
        ConfigTypeNotSupported,
        UnresolvedExtensionPoint,
        ConflictingExtensionPoints,
        IncompatibleThrowsClause,
        MissingFeatureImportAnnotation(true),
        ExtensionPointAcceptorReturnRecommended(true),
        ReturnValueIgnored(true),
        MeldAnnotationOutsideFeature(true);

        public static final String ID_PREFIX = "meld.";
        private final String id = "meld." + this.name();
        private final boolean warning;

        private Id() {
            this(false);
        }

        private Id(boolean warning) {
            this.warning = warning;
        }

        public String id() {
            return this.id;
        }

        public boolean warning() {
            return this.warning;
        }
    }
}

