/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.messages;

import ch.raffael.meldioc.model.messages.Message;
import io.vavr.collection.List;
import io.vavr.collection.Seq;

public interface MessageSink<S, T> {
    public void message(Message<S, T> var1);

    default public Tracker<S, T> tracker() {
        return new Tracker(this);
    }

    public static <S, T> UniqueWrapper<S, T> uniqueWrapper(MessageSink<S, T> delegate) {
        return new UniqueWrapper<S, T>(delegate);
    }

    public static final class Tracker<S, T>
    implements MessageSink<S, T> {
        private final MessageSink<S, T> delegate;
        private boolean hasErrors = false;

        public Tracker(MessageSink<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void message(Message<S, T> message) {
            this.hasErrors = true;
            this.delegate.message(message);
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public boolean ok() {
            return !this.hasErrors;
        }
    }

    public static final class UniqueWrapper<S, T>
    implements MessageSink<S, T> {
        private Seq<Message<S, T>> seen = List.empty();
        private final Object lock = new Object();
        private final MessageSink<S, T> delegate;

        public UniqueWrapper(MessageSink<S, T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void message(Message<S, T> message) {
            boolean report;
            Object object = this.lock;
            synchronized (object) {
                boolean bl = report = !this.seen.contains(message);
                if (report) {
                    this.seen = this.seen.append(message);
                }
            }
            if (report) {
                this.delegate.message(message);
            }
        }
    }
}

