/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.model._ClassRef;
import ch.raffael.meldioc.util.immutables.IllegalBuilderStateException;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="_ClassRef", generator="Immutables")
@Immutable
public final class ClassRef
extends _ClassRef {
    private final String packageName;
    private final String className;
    private final int arrayDimensions;

    private ClassRef(String packageName, String className) {
        this.packageName = Objects.requireNonNull(packageName, "packageName");
        this.className = Objects.requireNonNull(className, "className");
        this.arrayDimensions = super.arrayDimensions();
    }

    private ClassRef(Builder builder) {
        this.packageName = builder.packageName;
        this.className = builder.className;
        this.arrayDimensions = builder.arrayDimensionsIsSet() ? builder.arrayDimensions : super.arrayDimensions();
    }

    private ClassRef(String packageName, String className, int arrayDimensions) {
        this.packageName = packageName;
        this.className = className;
        this.arrayDimensions = arrayDimensions;
    }

    @Override
    public String packageName() {
        return this.packageName;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public int arrayDimensions() {
        return this.arrayDimensions;
    }

    public final ClassRef withPackageName(String value) {
        String newValue = Objects.requireNonNull(value, "packageName");
        if (this.packageName.equals(newValue)) {
            return this;
        }
        return new ClassRef(newValue, this.className, this.arrayDimensions);
    }

    public final ClassRef withClassName(String value) {
        String newValue = Objects.requireNonNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ClassRef(this.packageName, newValue, this.arrayDimensions);
    }

    public final ClassRef withArrayDimensions(int value) {
        if (this.arrayDimensions == value) {
            return this;
        }
        return new ClassRef(this.packageName, this.className, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ClassRef && this.equalTo((ClassRef)another);
    }

    private boolean equalTo(ClassRef another) {
        return this.packageName.equals(another.packageName) && this.className.equals(another.className) && this.arrayDimensions == another.arrayDimensions;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.packageName.hashCode();
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + this.arrayDimensions;
        return h;
    }

    public String toString() {
        return "ClassRef{packageName=" + this.packageName + ", className=" + this.className + ", arrayDimensions=" + this.arrayDimensions + "}";
    }

    public static ClassRef of(String packageName, String className) {
        return new ClassRef(packageName, className);
    }

    static ClassRef copyOf(_ClassRef instance) {
        if (instance instanceof ClassRef) {
            return (ClassRef)instance;
        }
        return ClassRef.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ClassRef", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PACKAGE_NAME = 1L;
        private static final long INIT_BIT_CLASS_NAME = 2L;
        private static final long OPT_BIT_ARRAY_DIMENSIONS = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String packageName;
        @Nullable
        private String className;
        private int arrayDimensions;

        private Builder() {
        }

        public final Builder from(ClassRef instance) {
            return this.from((_ClassRef)instance);
        }

        final Builder from(_ClassRef instance) {
            Objects.requireNonNull(instance, "instance");
            this.packageName(instance.packageName());
            this.className(instance.className());
            this.arrayDimensions(instance.arrayDimensions());
            return this;
        }

        public final Builder packageName(String packageName) {
            this.packageName = Objects.requireNonNull(packageName, "packageName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder className(String className) {
            this.className = Objects.requireNonNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder arrayDimensions(int arrayDimensions) {
            this.arrayDimensions = arrayDimensions;
            this.optBits |= 1L;
            return this;
        }

        public ClassRef build() {
            this.checkRequiredAttributes();
            return new ClassRef(this);
        }

        private boolean arrayDimensionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean packageNameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean classNameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalBuilderStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.packageNameIsSet()) {
                attributes.add("packageName");
            }
            if (!this.classNameIsSet()) {
                attributes.add("className");
            }
            return "Cannot build ClassRef, some of required attributes are not set " + attributes;
        }
    }
}

