/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.Set;
import org.immutables.value.Value;

@Immutable.Public
abstract class _ClassRef {
    _ClassRef() {
    }

    public static ClassRef of(Class<?> clazz) {
        int arrayDimensions = 0;
        while (clazz.isArray()) {
            ++arrayDimensions;
            clazz = clazz.getComponentType();
        }
        StringBuilder className = new StringBuilder();
        Class<?> outermost = _ClassRef.buildClassName(clazz, className);
        int pos = outermost.getName().lastIndexOf(46);
        ClassRef ref = pos >= 0 ? ClassRef.of(outermost.getName().substring(0, pos), className.toString()) : ClassRef.of("", className.toString());
        return arrayDimensions == 0 ? ref : ref.withArrayDimensions(arrayDimensions);
    }

    private static Class<?> buildClassName(Class<?> clazz, StringBuilder buf) {
        if (clazz.getEnclosingClass() == null) {
            buf.setLength(0);
            buf.append(clazz.getSimpleName());
            return clazz;
        }
        Class<?> c = _ClassRef.buildClassName(clazz.getEnclosingClass(), buf);
        buf.append('.').append(clazz.getSimpleName());
        return c;
    }

    @Value.Parameter
    public abstract String packageName();

    @Value.Parameter
    public abstract String className();

    @Value.Default
    public int arrayDimensions() {
        return 0;
    }

    public final ClassRef asArray() {
        ClassRef self = (ClassRef)this;
        return self.withArrayDimensions(self.arrayDimensions() + 1);
    }

    public final boolean isPrimitive() {
        return Primitives.ALL.contains((Object)((ClassRef)this));
    }

    public final String binaryName() {
        return this.packageName().isEmpty() ? this.className() : this.packageName() + "." + this.className().replace('.', '$');
    }

    public final String canonicalName() {
        return this.packageName().isEmpty() ? this.className() : this.packageName() + "." + this.className();
    }

    public final String simpleName() {
        return _ClassRef.lastPart(this.className());
    }

    private static String lastPart(String s) {
        int pos = s.lastIndexOf(46);
        return pos < 0 ? s : s.substring(pos + 1);
    }

    public static final class Primitives {
        public static final ClassRef INT = ClassRef.of("", "int");
        public static final ClassRef LONG = ClassRef.of("", "long");
        public static final ClassRef SHORT = ClassRef.of("", "short");
        public static final ClassRef BYTE = ClassRef.of("", "byte");
        public static final ClassRef DOUBLE = ClassRef.of("", "double");
        public static final ClassRef FLOAT = ClassRef.of("", "float");
        public static final ClassRef CHAR = ClassRef.of("", "char");
        public static final ClassRef BOOLEAN = ClassRef.of("", "boolean");
        public static final ClassRef VOID = ClassRef.of("", "void");
        public static final Set<ClassRef> ALL = LinkedHashSet.of((Object[])new ClassRef[]{INT, LONG, SHORT, BYTE, DOUBLE, FLOAT, CHAR, BOOLEAN});
    }

    public static final class Lang {
        public static final ClassRef OBJECT = ClassRef.of("java.lang", "Object");
        public static final ClassRef ENUM = ClassRef.of("java.lang", "Enum");
        public static final ClassRef NUMBER = ClassRef.of("java.lang", "Number");
        public static final ClassRef INTEGER = ClassRef.of("java.lang", "Integer");
        public static final ClassRef LONG = ClassRef.of("java.lang", "Long");
        public static final ClassRef SHORT = ClassRef.of("java.lang", "Short");
        public static final ClassRef BYTE = ClassRef.of("java.lang", "Byte");
        public static final ClassRef DOUBLE = ClassRef.of("java.lang", "Double");
        public static final ClassRef FLOAT = ClassRef.of("java.lang", "Float");
        public static final ClassRef CHAR = ClassRef.of("java.lang", "Character");
        public static final ClassRef BOOLEAN = ClassRef.of("java.lang", "Boolean");
        public static final ClassRef STRING = ClassRef.of("java.lang", "String");
        public static final ClassRef CHAR_SEQUENCE = ClassRef.of("java.lang", "CharSequence");
        public static final ClassRef THROWABLE = ClassRef.of("java.lang", "Throwable");
        public static final ClassRef EXCEPTION = ClassRef.of("java.lang", "Exception");
        public static final ClassRef RUNTIME_EXCEPTION = ClassRef.of("java.lang", "RuntimeException");
        public static final ClassRef ERROR = ClassRef.of("java.lang", "Error");
    }
}

