/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.config.AnnotationAttribute;
import ch.raffael.meldioc.model.config.ModelAnnotationType;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.Map;
import java.lang.annotation.Annotation;
import java.util.function.Function;

public abstract class ElementConfig<S> {
    private static final Lazy<Map<Class<? extends Annotation>, Function<? super Annotation, ? extends ElementConfig>>> BUILDERS = Lazy.of(() -> Array.of((Object[])new Tuple2[]{ElementConfig.entry(Configuration.class, ElementConfig::of), ElementConfig.entry(Setup.class, ElementConfig::of), ElementConfig.entry(Parameter.class, ElementConfig::of), ElementConfig.entry(ExtensionPoint.class, ElementConfig::of), ElementConfig.entry(Feature.class, ElementConfig::of), ElementConfig.entry(Provision.class, ElementConfig::of), ElementConfig.entry(Feature.Mount.class, ElementConfig::of)}).toMap(t -> t));

    private static Tuple2<Class<? extends Annotation>, Function<? super Annotation, ? extends ElementConfig>> entry(Class<? extends Annotation> annotationType, Function<? super Annotation, ? extends ElementConfig> fun) {
        return Tuple.of(annotationType, fun);
    }

    public static <A extends Annotation> ElementConfig<A> of(A annotation) {
        return (ElementConfig)((Function)((Map)BUILDERS.get()).get(annotation.annotationType()).getOrElseThrow(() -> new IllegalArgumentException("No model annotation type: " + annotation.annotationType()))).apply(annotation);
    }

    ElementConfig() {
    }

    public abstract ModelAnnotationType type();

    public abstract S source();

    public boolean isConfigType(Class<? extends Annotation> type) {
        return this.type().annotationType().equals(type);
    }

    public abstract Map<String, Object> valueMap();

    public Map<String, Object> valueMapWithoutDefaults() {
        return this.valueMap().filter((n, v) -> (Boolean)this.type().attributes().get(n).flatMap(AnnotationAttribute::defaultValue).map(d -> !d.equals(v)).getOrElse((Object)true));
    }

    public String displayName() {
        return this.type().displayName();
    }
}

