/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.model.BuiltinArgument;
import ch.raffael.meldioc.model.Model;
import ch.raffael.meldioc.model.ModelMethod_Immutable;
import ch.raffael.meldioc.model.ModelMethod_With;
import ch.raffael.meldioc.model.ModelType;
import ch.raffael.meldioc.model.SrcElement;
import ch.raffael.meldioc.model.messages.Message;
import ch.raffael.meldioc.model.messages.MessageSink;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import org.immutables.value.Value;

@Immutable.Pure
public abstract class ModelMethod<S, T>
implements ModelMethod_With<S, T> {
    ModelMethod() {
    }

    public static <S, T> Builder<S, T> builder() {
        return new Builder();
    }

    public static <S, T> ModelMethod<S, T> of(SrcElement<S, T> element, ModelType<S, T> modelType) {
        return ModelMethod_Immutable.of(element, modelType);
    }

    @Value.Parameter
    public abstract SrcElement<S, T> element();

    @Value.Parameter
    public abstract ModelType<S, T> modelType();

    @Value.Lazy
    public T returnType() {
        return (T)this.via().flatMap(v -> this.modelType().model().modelOf(v.element().type()).allMethods().toStream().map(ModelMethod::element).find(m -> m.methodSignature().equals(this.element().methodSignature())).map(SrcElement::type)).getOrElse(this.element().type());
    }

    @Value.Lazy
    public Seq<T> exceptions() {
        return (Seq)this.via().fold(() -> this.implyReason() == ImplyReason.HIERARCHY ? this.inheritedExceptions() : this.element().exceptions(), __ -> this.viaExceptions());
    }

    private Seq<T> inheritedExceptions() {
        Model model = this.modelType().model();
        return this.element().exceptions().filter(e -> model.adaptor().isSubtypeOf(e, model.runtimeExceptionType()) || model.adaptor().isSubtypeOf(e, model.errorType()) || this.overrides().forAll(o -> o.exceptions().exists(oe -> model.adaptor().isSubtypeOf(e, oe))));
    }

    private Seq<T> viaExceptions() {
        return (Seq)this.via().flatMap(v -> this.modelType().model().modelOf(v.element().type()).allMethods().toStream().filter(m -> m.element().methodSignature().equals(this.element().methodSignature())).headOption()).map(ModelMethod::exceptions).getOrElse((Object)List.empty());
    }

    public abstract Seq<ModelMethod<S, T>> overrides();

    public abstract Option<ModelMethod<S, T>> via();

    public ModelMethod<S, T> withVia(ModelMethod<S, T> via) {
        return this.withVia(Option.some(via));
    }

    public boolean implied() {
        return this.implyReason() != ImplyReason.NONE;
    }

    @Value.Default
    public ImplyReason implyReason() {
        return ImplyReason.NONE;
    }

    @Value.Auxiliary
    public abstract Seq<Either<ModelMethod<S, T>, BuiltinArgument>> arguments();

    @Value.Auxiliary
    public abstract Seq<Message<S, T>> messages();

    @Override
    public abstract ModelMethod<S, T> withMessages(Seq<Message<S, T>> var1);

    ModelMethod<S, T> addMessage(MessageSink<S, T> sink, Message<S, T> msg) {
        sink.message(msg);
        return this.withMessages(this.messages().append(msg));
    }

    ModelMethod<S, T> addMessages(MessageSink<S, T> sink, Iterable<? extends Message<S, T>> msg) {
        msg.forEach(sink::message);
        return this.withMessages(this.messages().appendAll(msg));
    }

    public static final class Builder<S, T>
    extends ModelMethod_Immutable.Builder<S, T> {
        Builder() {
        }
    }

    public static enum ImplyReason {
        NONE,
        HIERARCHY,
        MOUNT,
        SYNTHESIZED;

    }
}

