/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.Adaptor;
import ch.raffael.meldioc.model.BuiltinArgument;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.Model;
import ch.raffael.meldioc.model.ModelMethod;
import ch.raffael.meldioc.model.SrcElement;
import ch.raffael.meldioc.model.config.ElementConfig;
import ch.raffael.meldioc.model.config.ModelAnnotationType;
import ch.raffael.meldioc.model.config.MountConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.model.messages.Message;
import ch.raffael.meldioc.model.messages.SimpleMessage;
import ch.raffael.meldioc.util.VavrX;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.collection.Vector;
import io.vavr.control.Either;
import io.vavr.control.Option;
import java.util.function.Function;

public final class ModelType<S, T> {
    private final Model<S, T> model;
    private final T type;
    private final SrcElement<S, T> element;
    private final Seq<ModelType<S, T>> superTypes;
    private final Seq<ModelType<S, T>> importedSuperTypes;
    private final Seq<ModelMethod<S, T>> allMethods;
    private final Seq<ModelMethod<S, T>> provisionMethods;
    private final Seq<ModelMethod<S, T>> extensionPointMethods;
    private final Seq<ModelMethod<S, T>> mountMethods;
    private final Seq<ModelMethod<S, T>> setupMethods;
    private final Seq<ModelMethod<S, T>> parameterMethods;
    private final boolean isIllegalFeatureElement;

    public ModelType(Model<S, T> model, T type) {
        this.model = model;
        this.type = type;
        Tuple2<SrcElement<S, T>, Boolean> checkFeatureElement = this.checkFeatureElement();
        this.element = (SrcElement)checkFeatureElement._1();
        this.isIllegalFeatureElement = (Boolean)checkFeatureElement._2();
        Adaptor adaptor = model.adaptor();
        Seq<Adaptor.SuperType<T>> rawSuperTypes = adaptor.superTypes(type);
        this.superTypes = rawSuperTypes.map(Adaptor.SuperType::type).map(model::modelOf);
        this.importedSuperTypes = rawSuperTypes.filter(Adaptor.SuperType::imported).map(Adaptor.SuperType::type).map(model::modelOf);
        if (this.element.configurationConfigOption().isDefined() || this.element.featureConfigOption().isDefined()) {
            this.validateExtendable(this.element.configurationConfigOption().isDefined(), this.element, Option.none());
            this.validateImports();
        }
        Map superMethods = this.superTypes.toStream().flatMap(cm -> cm.allMethods).groupBy(m -> m.element().methodSignature()).mapValues(candidates -> candidates.sorted((left, right) -> {
            boolean lSubR = adaptor.isSubtypeOf(left.element().type(), right.element().type());
            boolean rSubR = adaptor.isSubtypeOf(right.element().type(), left.element().type());
            if (lSubR && rSubR) {
                return 0;
            }
            if (lSubR) {
                return -1;
            }
            if (rSubR) {
                return 1;
            }
            return 0;
        }));
        List declaredMethods = adaptor.declaredMethods(type).toStream().map(m -> ModelMethod.of(m, this).withOverrides((Seq)superMethods.get(m.methodSignature()).getOrElse((Object)List.empty()))).toList();
        this.validateClassAnnotations();
        declaredMethods.forEach(this::validateDeclaredMethodAnnotations);
        this.allMethods = this.findAllMethods((Map<Tuple2<String, Seq<SrcElement<?, T>>>, Seq<ModelMethod<S, T>>>)superMethods, (Seq<ModelMethod<S, T>>)declaredMethods);
        this.mountMethods = this.findMountMethods(adaptor);
        this.provisionMethods = this.findProvisionMethods();
        this.extensionPointMethods = this.findExtensionPointMethods();
        this.parameterMethods = this.findParameterMethods(adaptor);
        this.setupMethods = this.findSetupMethods(adaptor);
    }

    void message(SimpleMessage<S, T> message) {
        if (this.isIllegalFeatureElement) {
            if (message.isId(Message.Id.MeldAnnotationOutsideFeature)) {
                return;
            }
            if (message.isId(Message.Id.ConflictingOverride) && message.element().configs().isEmpty()) {
                return;
            }
        }
        this.model.message(message);
    }

    private Tuple2<SrcElement<S, T>, Boolean> checkFeatureElement() {
        SrcElement<S, T> element = this.model.adaptor().classElement(this.type);
        if (!element.configurationConfigOption().isDefined() && !element.featureConfigOption().isDefined()) {
            return Tuple.of(element, (Object)false);
        }
        if (this.model.adaptor().isEnumType(this.type) || this.model.adaptor().isRecordType(this.type) || this.model.adaptor().isAnnotationType(this.type)) {
            this.message(Message.illegalFeatureClass(element));
            return Tuple.of(element.withConfigs(element.configs().reject(c -> c.isConfigType(Feature.class) || c.isConfigType(Configuration.class))), (Object)true);
        }
        return Tuple.of(element, (Object)false);
    }

    private Seq<ModelMethod<S, T>> findAllMethods(Map<Tuple2<String, Seq<SrcElement<?, T>>>, Seq<ModelMethod<S, T>>> superMethods, Seq<ModelMethod<S, T>> declaredMethods) {
        return declaredMethods.toStream().appendAll((Iterable)superMethods.toStream().filter(sm -> !declaredMethods.exists(dm -> dm.element().methodSignature().equals(sm._1))).map(Tuple2::_2).map(sm -> sm.size() == 1 ? (ModelMethod)sm.head() : ModelMethod.of(((ModelMethod)sm.head()).element(), this).withImplyReason(ModelMethod.ImplyReason.HIERARCHY).withOverrides(sm))).filter(m1 -> {
            boolean include = true;
            include &= this.validateObjectMethods((ModelMethod<S, T>)m1);
            include &= this.excludeStaticMethods((ModelMethod<S, T>)m1);
            include &= this.validateConflictingSuperCompositionRoles((ModelMethod<S, T>)m1);
            if (this.element.configs().exists(c1 -> c1.type().annotationType().equals(Configuration.class))) {
                include &= this.validateAbstractMethodImplementable(this.element, (ModelMethod<S, T>)m1);
            }
            if (!m1.element().configs().isEmpty()) {
                include &= this.validateOverridableMethod((ModelMethod<S, T>)m1);
                include &= this.validateMethodAccessibility(this.element, (ModelMethod<S, T>)m1, false);
                include &= this.validateProvisionOverrideAttribute((ModelMethod<S, T>)m1);
            }
            return include;
        }).map(this.element.featureConfigOption().isDefined() && this.model.adaptor().isInterface(this.element.type()) ? VavrX.tap(m -> {
            if (m.element().provisionConfigOption().isEmpty()) {
                this.message(Message.featureInterfacesShouldDeclareProvisionsOnly(m.element(), this.element));
            }
        }) : Function.identity());
    }

    private Seq<ModelMethod<S, T>> findMountMethods(Adaptor<S, T> adaptor) {
        return this.allMethods.toStream().filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Feature.Mount.class))).map(VavrX.tap(m -> this.model.modelOf(m.element().type()).allMethods().filter(mm -> this.validateAbstractMethodImplementable(m.element(), (ModelMethod<S, T>)mm)).filter(mm -> mm.element().configs().exists(c -> c.type().role())).forEach(mm -> this.validateMethodAccessibility(m.element(), (ModelMethod<S, T>)mm, true)))).appendAll((Iterable)this.element.configurationConfigOption().map(mc -> this.synthesizeMountMethods(mc.mount(), adaptor, mc.source())).getOrElse((Object)List.empty())).filter(this::validateNoParameters).filter(this::validateReferenceType).map(VavrX.tap(m -> {
            if (!m.element().isAbstract()) {
                this.message(Message.mountMethodMustBeAbstract(m.element()));
            }
        })).map(VavrX.tap(m -> {
            SrcElement ret = adaptor.classElement(m.element().type());
            if (adaptor.classElement(m.element().type()).isInnerClass()) {
                this.message(Message.illegalInnerClass(m.element(), ret));
            }
        })).filter(m -> {
            if (this.element.configurationConfigOption().isEmpty()) {
                this.message(Message.mountMethodsAllowedInConfigurationsOnly(m.element()));
                return false;
            }
            return true;
        }).filter(m -> {
            SrcElement<S, T> cls = this.model.adaptor().classElement(m.element().type());
            if (!cls.configs().map(c -> c.type().annotationType()).exists(t -> t.equals(Feature.class) || t.equals(Configuration.class))) {
                this.message(Message.mountMethodMustReturnFeature(m.element(), cls));
                return false;
            }
            return true;
        }).map(VavrX.tap(m -> {
            if (!m.element().mountConfig().injected()) {
                this.validateExtendable(true, this.model.adaptor().classElement(m.element().type()), Option.some(m.element()));
            }
        })).toList();
    }

    private Seq<ModelMethod<S, T>> synthesizeMountMethods(Seq<ClassRef> classRefs, Adaptor<S, T> adaptor, S source) {
        return classRefs.toStream().filter(cr -> {
            Object t = adaptor.typeOf((ClassRef)cr);
            if (adaptor.hasTypeParameters(t)) {
                this.message(Message.mountAttributeClassMustNotBeParametrized(this.element, adaptor.classElement(t)));
                return false;
            }
            return true;
        }).map(cr -> ModelMethod.builder().implyReason(ModelMethod.ImplyReason.SYNTHESIZED).modelType(this).element(SrcElement.builder().synthetic(true).parent(this.element).source(source).kind(SrcElement.Kind.METHOD).name("synthetic$$" + cr.canonicalName().replace('.', '$')).type(adaptor.typeOf((ClassRef)cr)).accessPolicy(AccessPolicy.LOCAL).isStatic(false).isFinal(false).isSealed(false).isAbstract(true).addConfigs((ElementConfig)MountConfig.builder().injected(false).source(source).build()).build()).build()).toList();
    }

    private Seq<ModelMethod<S, T>> findProvisionMethods() {
        List declaredLocal = this.allMethods.toStream().filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Provision.class))).filter(this::validateNoParameters).filter(this::validateReferenceType).toList();
        if (!this.element().configurationConfigOption().isDefined()) {
            return declaredLocal;
        }
        List declaredMounted = this.mountMethods.toStream().flatMap(m -> this.model.modelOf(m.element().type()).provisionMethods().map(p -> Tuple.of((Object)m, (Object)p))).map(m -> ModelMethod.builder().modelType(this).element(((ModelMethod)m._2()).element()).via((ModelMethod)m._1()).build()).toList();
        List allDeclared = declaredLocal.appendAll((Iterable)declaredMounted);
        List impliedLocal = declaredMounted.toStream().reject(p -> declaredLocal.exists(l -> l.element().name().equals(p.element().name()))).filter(p -> {
            this.allMethods.filter(m -> m.element().provisionConfigOption().isEmpty()).filter(m -> m.element().methodSignature().equals(p.element().methodSignature())).forEach(m -> this.message(Message.mountedProvisionOverridesMethod(this.findErrorReportElement((ModelMethod<S, T>)m), m.element(), ((ModelMethod)p.via().get()).element())));
            return true;
        }).groupBy(p -> p.element().name()).mapValues(v -> Tuple.of((Object)v, (Object)ModelMethod.builder().modelType(this).via(Option.none()).implyReason(ModelMethod.ImplyReason.MOUNT).element(SrcElement.builder().kind(SrcElement.Kind.METHOD).name(((ModelMethod)v.head()).element().name()).type(this.model.objectType()).exceptions((Seq)List.of(this.model.throwableType())).addConfigs((ElementConfig)ProvisionConfig.builder().singleton(v.exists(p -> (Boolean)p.element().provisionConfigOption().map(ProvisionConfig::singleton).getOrElse((Object)false))).override(false).source(this.element.source()).build()).source(this.element().source()).parentOption((SrcElement)this.element).accessPolicy(AccessPolicy.LOCAL).isAbstract(true).isStatic(false).isFinal(false).isSealed(false).build()).build())).values().toStream().map(Tuple2::_2).toList();
        List allLocal = declaredLocal.appendAll((Iterable)impliedLocal);
        Map implementations = allDeclared.toStream().groupBy(p -> p.element().name()).values().toStream().map(v -> {
            Stream i = v.filter(this::isConcreteProvision);
            if (i.isEmpty()) {
                v.forEach(p -> this.message(Message.unresolvedProvision(this.findErrorReportElement((ModelMethod<S, T>)p), p.element())));
                return Option.none();
            }
            if (i.length() > 1) {
                v.forEach(p -> this.message(Message.conflictingProvisions(this.findErrorReportElement((ModelMethod<S, T>)p), v.remove(p).map(ModelMethod::element))));
                return Option.none();
            }
            return i.headOption();
        }).flatMap(Value::toStream).toMap(p -> p.element().name(), Function.identity());
        Stream resolved = allLocal.toStream().map(p -> (ModelMethod)implementations.get((Object)p.element().name()).filter(i -> this.validateImplementationCompatibility((ModelMethod<S, T>)p, (ModelMethod<S, T>)i, (List<ModelMethod<S, T>>)declaredMounted)).map(i -> p.withVia(i.via())).getOrElse(p));
        return resolved;
    }

    private boolean validateImplementationCompatibility(ModelMethod<S, T> provision, ModelMethod<S, T> impl, List<ModelMethod<S, T>> mounted) {
        mounted.toStream().filter(m -> m.element().name().equals(provision.element().name())).filter(m -> !this.model.adaptor().isSubtypeOf(impl.element().type(), m.element().type())).forEach(m -> this.message(Message.incompatibleProvisionTypes(this.findErrorReportElement((ModelMethod<S, T>)m), m.element(), impl.element(), impl.via().map(ModelMethod::element))));
        if (!this.model.adaptor().isSubtypeOf(impl.element().type(), provision.element().type())) {
            this.message(Message.incompatibleProvisionTypes((SrcElement)provision.via().map(ModelMethod::element).getOrElse(() -> this.findErrorReportElement(provision)), provision.element(), impl.element(), impl.via().map(ModelMethod::element)));
        }
        mounted.toStream().filter(m -> m.element().name().equals(provision.element().name())).forEach(m -> this.incompatibleExceptions(m.exceptions(), impl.exceptions()).forEach(e -> this.message(Message.incompatibleProvisionThrows(this.findErrorReportElement((ModelMethod<S, T>)m), provision.element(), this.model.adaptor().classElement(e)))));
        this.incompatibleExceptions(provision.exceptions(), impl.exceptions()).forEach(e -> this.message(Message.incompatibleProvisionThrows(this.findErrorReportElement(provision), provision.element(), this.model.adaptor().classElement(e))));
        return true;
    }

    private boolean isConcreteProvision(ModelMethod<S, T> provision) {
        return !provision.element().isAbstract() || (Boolean)provision.via().flatMap(v -> v.element().mountConfigOption().map(MountConfig::injected)).getOrElse((Object)false) != false || provision.overrides().exists(this::isConcreteProvision);
    }

    private Stream<T> incompatibleExceptions(Seq<T> declared, Seq<T> check) {
        Seq thrown = declared.append(this.model.runtimeExceptionType()).append(this.model.errorType());
        return check.toStream().filter(e -> !thrown.exists(t -> this.model.adaptor().isSubtypeOf(e, t)));
    }

    private Seq<ModelMethod<S, T>> findExtensionPointMethods() {
        return this.allMethods.toStream().filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(ExtensionPoint.class))).filter(this::validateNoParameters).filter(this::validateReferenceType).map(VavrX.tap(m -> {
            SrcElement<S, T> cls = this.model.adaptor().classElement(m.element().type());
            if (!cls.configs().exists(c -> c.type().annotationType().equals(ExtensionPoint.class))) {
                this.message(Message.extensionPointReturnRecommended(m.element(), cls));
            }
        })).toList();
    }

    private Seq<ModelMethod<S, T>> findParameterMethods(Adaptor<S, T> adaptor) {
        List params = this.allMethods.toStream().filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Parameter.class))).filter(this::validateNoParameters).map(VavrX.tap(m -> {
            if (m.element().parameterConfig().value().equals("*")) {
                if (!adaptor.isSubtypeOf(this.model.configType().get(), m.element().type())) {
                    this.message(Message.configTypeNotSupported(m.element()));
                }
            } else if (this.model.configSupportedTypeOption(m.element().type()).isEmpty()) {
                this.message(Message.configTypeNotSupported(m.element()));
            }
        })).appendAll(this.collectMounted(ModelType::parameterMethods)).toList();
        if (this.element.configurationConfigOption().isDefined() && !this.supportsParameters()) {
            params.filter(p -> p.element().isAbstract()).forEach(p -> this.message(Message.typesafeConfigNotOnClasspath(this.findErrorReportElement((ModelMethod<S, T>)p))));
        }
        return params;
    }

    private Seq<ModelMethod<S, T>> findSetupMethods(Adaptor<S, T> adaptor) {
        return this.allMethods.toStream().filter(m -> m.element().configs().exists(c -> c.type().annotationType().equals(Setup.class))).map(VavrX.tap(m -> {
            if (!adaptor.isNoType(m.element().type())) {
                this.message(Message.returnValueIgnored(m.element()));
            }
        })).appendAll(this.collectMounted(ModelType::setupMethods)).map(this.element.configs().exists(c -> c.type().annotationType().equals(Configuration.class)) ? m -> m.withArguments(this.mapSetupParameters((ModelMethod<S, T>)m)) : Function.identity()).toList();
    }

    private void validateExtendable(boolean direct, SrcElement<S, T> type, Option<SrcElement<S, T>> from) {
        if (direct && (type.isFinal() || type.isSealed())) {
            this.message(Message.typeNotExtendable((SrcElement)from.getOrElse(type), type));
        }
        if (type.isInnerClass()) {
            this.message(Message.illegalInnerClass(type));
            direct = false;
        }
        SrcElement<S, T> outer = this.element.findOutermost();
        SrcElement c2 = type;
        while (c2.parentOption().isDefined()) {
            if (c2.accessPolicy() == AccessPolicy.PRIVATE || !c2.accessibleTo(this.model.adaptor(), outer)) {
                this.message(Message.elementNotAccessible(this.element, type));
                direct = false;
            }
            c2 = c2.parent();
        }
        if (direct && !this.model.adaptor().isInterface(type.type())) {
            List ctors = this.model.adaptor().constructors(type.type());
            if (ctors.isEmpty()) {
                ctors = List.of((Object)SrcElement.builder().kind(SrcElement.Kind.METHOD).parent(type).name("<init>").type(this.model.adaptor().noType()).accessPolicy(type.accessPolicy()).isStatic(false).isFinal(false).isSealed(false).isAbstract(false).parameters((Seq)List.empty()).source(type.source()).synthetic(true).build());
            }
            Option ac = ctors.find(e -> e.parameters().isEmpty()).filter(c -> c.accessPolicy() != AccessPolicy.PRIVATE).filter(c -> c.accessibleToByExtension(this.model.adaptor(), outer));
            ac.onEmpty(() -> this.message((SimpleMessage)from.fold(() -> Message.missingNoArgsConstructor(type), m -> Message.missingNoArgsConstructor(m, type))));
        }
    }

    private void validateImports() {
        this.superTypes.toStream().filter(t -> t.element().featureConfigOption().isEmpty()).filter(t -> t.element().configurationConfigOption().isEmpty()).forEach(t -> {
            if (!this.isImported((ModelType<S, T>)t)) {
                this.message(Message.missingFeatureImportAnnotation(this.element, t.element()));
            }
        });
    }

    private void validateClassAnnotations() {
        if (!this.element.configs().exists(c -> c.type().featureRole()) && this.element.configs().exists(c -> !c.type().role())) {
            this.message(Message.meldAnnotationOutsideFeature(this.element()));
        }
    }

    private void validateDeclaredMethodAnnotations(ModelMethod<S, T> method) {
        if (!this.element.configs().exists(c -> c.type().featureRole()) && !method.element().configs().isEmpty()) {
            this.message(Message.meldAnnotationOutsideFeature(method.element()));
        }
        if (method.element().configs().count(c -> c.type().role()) > 1) {
            this.message(Message.conflictingCompositionRoles(method.element(), List.empty()));
        }
    }

    private boolean validateObjectMethods(ModelMethod<S, T> method) {
        if (this.model.objectMethods().exists(om -> method.element().canOverride((SrcElement<S, T>)om, this.model.adaptor()))) {
            if (!method.element().configs().isEmpty()) {
                method.addMessage(this.model, Message.objectOverride(method.element()));
            }
            return false;
        }
        return true;
    }

    private boolean excludeStaticMethods(ModelMethod<S, T> method) {
        return !method.element().isStatic();
    }

    private boolean validateOverridableMethod(ModelMethod<S, T> method) {
        if (!method.element().isOverridable()) {
            method.addMessage(this.model, Message.nonOverridableMethod(method.element()));
        }
        return true;
    }

    private boolean validateConflictingSuperCompositionRoles(ModelMethod<S, T> method) {
        List conflicts = method.overrides().toStream().filter(s -> !s.element().configs().isEmpty()).filter(s -> !method.element().configs().map(ElementConfig::type).equals((Object)s.element().configs().map(ElementConfig::type))).toList();
        if (!conflicts.isEmpty()) {
            this.message(Message.conflictingOverride(method.element(), conflicts.map(ModelMethod::element)));
        }
        return true;
    }

    private boolean validateMethodAccessibility(SrcElement<S, T> nonLocalMsgTarget, ModelMethod<S, T> method, boolean forOverride) {
        if (method.element().parent().equals(this.element)) {
            method.overrides().forEach(s -> {
                if (!s.element().accessibleTo(this.model.adaptor(), method.element())) {
                    this.message(Message.elementNotAccessible(method.element(), s.element()));
                }
            });
        } else if (!method.element().accessibleTo(this.model.adaptor(), this.element, forOverride)) {
            this.message(Message.elementNotAccessible(nonLocalMsgTarget, method.element()));
        }
        return true;
    }

    private boolean validateProvisionOverrideAttribute(ModelMethod<S, T> method) {
        method.element().configs().toStream().filter(c -> c.type().annotationType().equals(Provision.class)).map(ProvisionConfig.class::cast).filter(c -> !c.singleton() && !c.override()).headOption().forEach(__ -> method.overrides().filter(s -> s.element().configs().filter(c -> c.type().annotationType().equals(Provision.class)).map(ProvisionConfig.class::cast).exists(c -> c.singleton())).headOption().forEach(s -> {
            if (method.element().parent().equals(this.element)) {
                this.message(Message.provisionOverrideMissing(method.element(), s.element()));
            } else {
                this.message(Message.conflictingProvisions(this.element, List.of((Object[])new SrcElement[]{method.element(), s.element()})));
            }
        }));
        return true;
    }

    private boolean validateNoParameters(ModelMethod<S, T> method) {
        if (!method.element().parameters().isEmpty()) {
            this.message(Message.noParametersAllowed(method.element()));
        }
        return true;
    }

    private boolean validateReferenceType(ModelMethod<S, T> method) {
        if (!this.model.adaptor().isReference(method.element().type())) {
            this.message(Message.mustReturnReference(method.element()));
        }
        return true;
    }

    private boolean validateAbstractMethodImplementable(SrcElement<S, T> classElem, ModelMethod<S, T> m) {
        if (!m.element().isAbstract()) {
            return true;
        }
        if (!m.element().configs().exists(c -> c.type().willImplement())) {
            if (classElem.equals(this.element)) {
                this.message(Message.abstractMethodWillNotBeImplemented(m.element(), m.element()));
            } else {
                this.message(Message.abstractMethodWillNotBeImplemented(classElem, m.element()));
            }
        }
        return true;
    }

    private Seq<Either<ModelMethod<S, T>, BuiltinArgument>> mapSetupParameters(ModelMethod<S, T> method) {
        return method.element().parameters().map(param -> {
            Vector candidates = Vector.ofAll((Iterable)this.model.configType().filter(t -> this.model.adaptor().isSubtypeOf(t, param.type())).map(__ -> BuiltinArgument.CONFIG.argument()));
            candidates = candidates.appendAll((Iterable)this.extensionPointMethods.filter(epp -> this.model.adaptor().isSubtypeOf(epp.element().type(), param.type())).map(Either::left));
            if ((candidates = candidates.appendAll((Iterable)this.mountMethods.map(m -> Tuple.of((Object)m, this.model.modelOf(m.element().type()).extensionPointMethods())).flatMap(tplViaEpp -> ((Seq)tplViaEpp._2()).map(m -> Tuple.of((Object)((ModelMethod)tplViaEpp._1()), (Object)m))).filter(tplViaEpp -> this.model.adaptor().isSubtypeOf(((ModelMethod)tplViaEpp._2()).element().type(), param.type())).map(tplViaEpp -> ((ModelMethod)tplViaEpp._2()).withVia((ModelMethod)tplViaEpp._1())).map(Either::left))).isEmpty()) {
                SrcElement epType = this.model.adaptor().classElement(param.type());
                this.message((SimpleMessage)method.via().map(via -> Message.unresolvedExtensionPoint(via.element(), param, epType)).getOrElse(() -> method.element().parentOption().eq((Object)Option.of(this.element)) ? Message.unresolvedExtensionPoint(param, epType) : Message.unresolvedExtensionPoint(this.element, param, epType)));
                return BuiltinArgument.NONE.argument();
            }
            if (candidates.size() > 1) {
                this.message(Message.conflictingExtensionPoints(param, candidates.filter(Either::isLeft).map(c -> ((ModelMethod)c.getLeft()).element())));
                return BuiltinArgument.NONE.argument();
            }
            return (Either)candidates.head();
        });
    }

    private Seq<ModelMethod<S, T>> collectMounted(Function<ModelType<S, T>, Seq<ModelMethod<S, T>>> mounted) {
        return this.mountMethods.toStream().flatMap(mount -> ((Seq)mounted.apply(this.model.modelOf(mount.element().type()))).map(m -> m.withVia(mount))).filter(m -> {
            boolean callable = m.element().accessibleToByExtension(this.model.adaptor(), this.element);
            if (!callable) {
                this.message(Message.elementNotAccessible(m.element(), this.element));
            }
            return callable;
        }).toList();
    }

    private SrcElement<S, T> findErrorReportElement(ModelMethod<S, T> method) {
        return this.findErrorReportElement(((ModelMethod)method.via().getOrElse(method)).element());
    }

    private SrcElement<S, T> findErrorReportElement(SrcElement<S, T> element) {
        return Stream.iterate((Object)Option.some(element), e -> e.flatMap(SrcElement::parentOption)).takeWhile(Option::isDefined).flatMap(Function.identity()).exists(e -> e.equals(this.element)) ? element : this.element;
    }

    public Model<S, T> model() {
        return this.model;
    }

    public T type() {
        return this.type;
    }

    public SrcElement<S, T> element() {
        return this.element;
    }

    public Seq<ModelType<S, T>> superTypes() {
        return this.superTypes;
    }

    public boolean isImported(ModelType<S, T> type) {
        return type.type().equals(this.model.objectType()) || this.importedSuperTypes.exists(i -> this.model().adaptor().isSubtypeOf(i.type(), type.type()));
    }

    public Seq<ModelMethod<S, T>> allMethods() {
        return this.allMethods;
    }

    public Seq<ModelMethod<S, T>> provisionMethods() {
        return this.provisionMethods;
    }

    public Seq<ModelMethod<S, T>> extensionPointMethods() {
        return this.extensionPointMethods;
    }

    public Seq<ModelMethod<S, T>> mountMethods() {
        return this.mountMethods;
    }

    public Seq<ModelMethod<S, T>> setupMethods() {
        return this.setupMethods;
    }

    public Seq<ModelMethod<S, T>> parameterMethods() {
        return this.parameterMethods;
    }

    public boolean supportsParameters() {
        return this.model.configType().isDefined();
    }

    public String toString() {
        return "ModelType{type=" + String.valueOf(this.type) + ",roles=" + String.valueOf(this.element.configs().map(ElementConfig::type).filter(ModelAnnotationType::role).map(t -> t.annotationType().getSimpleName()).mkCharSeq((CharSequence)"[", (CharSequence)",", (CharSequence)"]")) + "}";
    }
}

